/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.datastore.core.tests.historytree.overlapping;

import java.io.File;
import java.io.IOException;
import org.eclipse.tracecompass.datastore.core.interval.HTInterval;
import org.eclipse.tracecompass.datastore.core.interval.IHTInterval;
import org.eclipse.tracecompass.datastore.core.tests.historytree.AbstractHistoryTreeTestBase;
import org.eclipse.tracecompass.datastore.core.tests.historytree.HtTestUtils;
import org.eclipse.tracecompass.datastore.core.tests.stubs.historytree.overlapping.OverlappingHistoryTreeStub;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.AbstractHistoryTree;
import org.eclipse.tracecompass.internal.provisional.datastore.core.historytree.overlapping.OverlappingNode;
import org.junit.Assert;
import org.junit.Test;

public class OverlappingHistoryTreeTest
extends AbstractHistoryTreeTestBase<HTInterval, OverlappingNode<HTInterval>> {
    private static final HTInterval DEFAULT_OBJECT = new HTInterval(0L, 0L);

    protected OverlappingHistoryTreeStub createHistoryTree(File stateHistoryFile, int blockSize, int maxChildren, int providerVersion, long treeStart) throws IOException {
        return new OverlappingHistoryTreeStub(stateHistoryFile, blockSize, maxChildren, providerVersion, treeStart);
    }

    protected OverlappingHistoryTreeStub createHistoryTree(File existingStateFile, int expectedProviderVersion) throws IOException {
        return new OverlappingHistoryTreeStub(existingStateFile, expectedProviderVersion);
    }

    @Override
    protected HTInterval createInterval(long start, long end) {
        return new HTInterval(start, end);
    }

    @Override
    protected long fillValues(AbstractHistoryTree<HTInterval, OverlappingNode<HTInterval>> ht, int fillSize, long start) {
        int nbValues = fillSize / DEFAULT_OBJECT.getSizeOnDisk();
        int i = 0;
        while (i < nbValues) {
            ht.insert((IHTInterval)new HTInterval(start + (long)i, start + (long)i + 1L));
            ++i;
        }
        return start + (long)nbValues;
    }

    @Test
    public void testInsertions() {
        long start = 10L;
        OverlappingHistoryTreeStub ht = (OverlappingHistoryTreeStub)this.setupSmallTree(3, start);
        OverlappingNode<HTInterval> node = ht.getLatestLeaf();
        long time = this.fillValues((AbstractHistoryTree<HTInterval, OverlappingNode<HTInterval>>)ht, node.getNodeFreeSpace(), start);
        long lastStart = time - 10L;
        Assert.assertEquals((long)1L, (long)ht.getNodeCount());
        Assert.assertEquals((long)1L, (long)ht.getDepth());
        ht.insert((IHTInterval)this.createInterval(lastStart, time + 1L));
        Assert.assertEquals((long)3L, (long)ht.getNodeCount());
        Assert.assertEquals((long)2L, (long)ht.getDepth());
        Assert.assertEquals((long)1L, (long)ht.getLastInsertionLocation());
        ht.insert((IHTInterval)this.createInterval(lastStart - 5L, time + 1L));
        Assert.assertEquals((long)0L, (long)ht.getLastInsertionLocation());
        node = ht.getLatestLeaf();
        ++time;
        time = this.fillValues((AbstractHistoryTree<HTInterval, OverlappingNode<HTInterval>>)ht, node.getNodeFreeSpace(), time);
        ht.insert((IHTInterval)this.createInterval(lastStart - 5L, time + 1L));
        Assert.assertEquals((long)4L, (long)ht.getNodeCount());
        Assert.assertEquals((long)2L, (long)ht.getDepth());
        Assert.assertEquals((long)0L, (long)ht.getLastInsertionLocation());
        OverlappingNode<HTInterval> newNode = ht.getLatestLeaf();
        Assert.assertTrue((node.getSequenceNumber() != newNode.getSequenceNumber() ? 1 : 0) != 0);
        Assert.assertEquals((long)lastStart, (long)newNode.getNodeStart());
        node = ht.getLatestLeaf();
        time = this.fillValues((AbstractHistoryTree<HTInterval, OverlappingNode<HTInterval>>)ht, node.getNodeFreeSpace(), node.getNodeStart());
        Assert.assertEquals((long)4L, (long)ht.getNodeCount());
        Assert.assertEquals((long)2L, (long)ht.getDepth());
        ht.insert((IHTInterval)this.createInterval(time, time + 1L));
        Assert.assertEquals((long)7L, (long)ht.getNodeCount());
        Assert.assertEquals((long)3L, (long)ht.getDepth());
        Assert.assertEquals((long)2L, (long)ht.getLastInsertionLocation());
        node = ht.getLatestLeaf();
        time = this.fillValues((AbstractHistoryTree<HTInterval, OverlappingNode<HTInterval>>)ht, node.getNodeFreeSpace(), time);
        ht.insert((IHTInterval)this.createInterval(start + 1L, time));
        Assert.assertEquals((long)0L, (long)ht.getLastInsertionLocation());
        ht.insert((IHTInterval)this.createInterval(time, time + 1L));
        Assert.assertEquals((long)8L, (long)ht.getNodeCount());
        ht.closeTree(ht.getTreeEnd());
        HtTestUtils.assertTreeIntegrity(ht);
    }
}

