/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.views.distribution.model;

public class BaseDistributionData {
    public static final int OUT_OF_RANGE_BUCKET = -1;
    protected final int fNbBuckets;
    protected long fBucketDuration;
    protected int fLastBucket;
    protected long fFirstBucketTime;
    protected long fFirstEventTime;
    protected long fLastEventTime;

    public BaseDistributionData(int nbBuckets) {
        this.fNbBuckets = nbBuckets;
        this.clear();
    }

    public int getNbBuckets() {
        return this.fNbBuckets;
    }

    public long getBucketDuration() {
        return this.fBucketDuration;
    }

    public void setBucketDuration(long bucketDuration) {
        this.fBucketDuration = bucketDuration;
    }

    public int getLastBucket() {
        return this.fLastBucket;
    }

    public void setLastBucket(int lastBucket) {
        this.fLastBucket = lastBucket;
    }

    public long getFirstBucketTime() {
        return this.fFirstBucketTime;
    }

    public void setFirstBucketTime(long firstBucketTime) {
        this.fFirstBucketTime = firstBucketTime;
    }

    public long getLastBucketTime() {
        return this.getBucketStartTime(this.fLastBucket);
    }

    public long getFirstEventTime() {
        return this.fFirstEventTime;
    }

    public void setFirstEventTime(long firstEventTime) {
        this.fFirstEventTime = firstEventTime;
    }

    public long getLastEventTime() {
        return this.fLastEventTime;
    }

    public void setLastEventTime(long lastEventTime) {
        this.fLastEventTime = lastEventTime;
    }

    public long getBucketStartTime(int index) {
        return this.fFirstBucketTime + (long)index * this.fBucketDuration;
    }

    public long getBucketEndTime(int index) {
        return this.getBucketStartTime(index) + this.fBucketDuration;
    }

    public int getIndex(long time) {
        return (int)((time - this.fFirstBucketTime) / this.fBucketDuration);
    }

    public boolean isIndexValid(int index) {
        return index >= 0 && index <= this.fNbBuckets - 1;
    }

    public void clear() {
        this.fFirstBucketTime = 0L;
        this.fFirstEventTime = 0L;
        this.fLastEventTime = 0L;
        this.fLastBucket = 0;
        this.fBucketDuration = 1L;
    }
}

