/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.core.refactoring.resource;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IPath;
import org.eclipse.ltk.core.refactoring.RefactoringContribution;
import org.eclipse.ltk.core.refactoring.RefactoringDescriptor;
import org.eclipse.ltk.core.refactoring.resource.MoveRenameResourceDescriptor;
import org.eclipse.ltk.internal.core.refactoring.resource.ResourceProcessors;

public final class MoveRenameResourceRefactoringContribution
extends RefactoringContribution {
    private static final String ATTRIBUTE_INPUT = "input";
    private static final String ATTRIBUTE_NAME = "name";
    private static final String ATTRIBUTE_DESTINATION = "destination";
    private static final String ATTRIBUTE_UPDATE_REFERENCES = "updateReferences";

    @Override
    public Map<String, String> retrieveArgumentMap(RefactoringDescriptor descriptor) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (descriptor instanceof MoveRenameResourceDescriptor) {
            MoveRenameResourceDescriptor resourceDescriptor = (MoveRenameResourceDescriptor)descriptor;
            map.put(ATTRIBUTE_INPUT, ResourceProcessors.resourcePathToHandle(descriptor.getProject(), resourceDescriptor.getResourcePath()));
            map.put(ATTRIBUTE_NAME, resourceDescriptor.getNewName());
            IPath destinationPath = resourceDescriptor.getDestinationPath();
            map.put(ATTRIBUTE_DESTINATION, ResourceProcessors.resourcePathToHandle(descriptor.getProject(), destinationPath));
            map.put(ATTRIBUTE_UPDATE_REFERENCES, resourceDescriptor.isUpdateReferences() ? "true" : "false");
            return map;
        }
        return null;
    }

    @Override
    public RefactoringDescriptor createDescriptor() {
        return new MoveRenameResourceDescriptor();
    }

    @Override
    public RefactoringDescriptor createDescriptor(String id, String project, String description, String comment, Map<String, String> arguments, int flags) {
        String pathString = arguments.get(ATTRIBUTE_INPUT);
        String newName = arguments.get(ATTRIBUTE_NAME);
        String destination = arguments.get(ATTRIBUTE_DESTINATION);
        if (destination == null) {
            throw new IllegalArgumentException("Can not restore MoveRenameResourceDescriptor from map, destination missing");
        }
        IPath destPath = ResourceProcessors.handleToResourcePath(project, destination);
        boolean updateReferences = "true".equals(arguments.get(ATTRIBUTE_UPDATE_REFERENCES));
        if (pathString != null && newName != null) {
            IPath path = ResourceProcessors.handleToResourcePath(project, pathString);
            MoveRenameResourceDescriptor descriptor = new MoveRenameResourceDescriptor();
            descriptor.setProject(project);
            descriptor.setDescription(description);
            descriptor.setComment(comment);
            descriptor.setFlags(flags);
            descriptor.setNewName(newName);
            descriptor.setDestinationPath(destPath);
            descriptor.setResourcePath(path);
            descriptor.setUpdateReferences(updateReferences);
            return descriptor;
        }
        throw new IllegalArgumentException("Can not restore MoveRenameResourceDescriptor from map");
    }
}

