/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.stream;

import java.util.List;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.tracecompass.ctf.core.event.metadata.DeclarationScope;
import org.eclipse.tracecompass.ctf.core.trace.CTFTrace;
import org.eclipse.tracecompass.ctf.parser.CTFParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.AbstractScopedCommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.CTFJsonMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ICommonTreeParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.ParseException;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TsdlUtils;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypeAliasParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.TypedefParser;
import org.eclipse.tracecompass.internal.ctf.core.event.metadata.tsdl.stream.StreamDeclarationParser;
import org.eclipse.tracecompass.internal.ctf.core.event.types.ICTFMetadataNode;
import org.eclipse.tracecompass.internal.ctf.core.trace.CTFStream;

public final class StreamParser
extends AbstractScopedCommonTreeParser {
    public static final StreamParser INSTANCE = new StreamParser();

    private StreamParser() {
    }

    @Override
    public Object parse(ICTFMetadataNode streamNode, ICommonTreeParser.ICommonTreeParserParameter param) throws ParseException {
        if (!(param instanceof Param)) {
            throw new IllegalArgumentException("Param must be a " + Param.class.getCanonicalName());
        }
        Param parameter = (Param)param;
        CTFTrace trace = ((Param)param).fTrace;
        CTFStream stream = new CTFStream(trace);
        DeclarationScope scope = new DeclarationScope(parameter.fCurrentScope, "stream");
        if (streamNode instanceof CTFJsonMetadataNode) {
            StreamDeclarationParser.INSTANCE.parse(streamNode, new StreamDeclarationParser.Param(trace, stream, scope));
        } else {
            List<ICTFMetadataNode> children = streamNode.getChildren();
            if (children == null) {
                throw new ParseException("Empty stream block");
            }
            for (ICTFMetadataNode child : children) {
                String type = child.getType();
                if (CTFParser.tokenNames[111].equals(type)) {
                    TypeAliasParser.INSTANCE.parse(child, new TypeAliasParser.Param(trace, scope));
                    continue;
                }
                if (CTFParser.tokenNames[114].equals(type)) {
                    TypedefParser.INSTANCE.parse(child, new TypedefParser.Param(trace, scope));
                    continue;
                }
                if (CTFParser.tokenNames[85].equals(type) || CTFParser.tokenNames[86].equals(type)) {
                    StreamDeclarationParser.INSTANCE.parse(child, new StreamDeclarationParser.Param(trace, stream, scope));
                    continue;
                }
                throw TsdlUtils.childTypeError(child);
            }
        }
        if (!(!stream.isIdSet() || trace.packetHeaderIsSet() && trace.getPacketHeader().hasField("stream_id"))) {
            throw new ParseException("Stream has an ID, but there is no stream_id field in packet header.");
        }
        trace.addStream(stream);
        return stream;
    }

    @NonNullByDefault
    public static final class Param
    implements ICommonTreeParser.ICommonTreeParserParameter {
        private final DeclarationScope fCurrentScope;
        private final CTFTrace fTrace;

        public Param(CTFTrace trace, DeclarationScope currentScope) {
            this.fTrace = trace;
            this.fCurrentScope = currentScope;
        }
    }
}

