/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.atrace.event;

import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.atrace.event.SystraceProcessDumpEventField;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.event.GenericFtraceEventTypeFactory;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventType;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfCallsite;
import org.eclipse.tracecompass.tmf.core.event.lookup.ITmfSourceLookup;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class SystraceProcessDumpEvent
extends PlatformObject
implements ITmfEvent,
ITmfSourceLookup {
    private final @NonNull String fName;
    private final @Nullable ITmfCallsite fCallsite;
    private final ITmfTrace fTrace;
    private final long fRank;
    private final @NonNull ITmfTimestamp fTimestamp;
    private final ITmfEventType fType;
    private final ITmfEventField fContent;

    public SystraceProcessDumpEvent(ITmfTrace trace, long rank, ITmfTimestamp timestamp, SystraceProcessDumpEventField field) {
        this.fTrace = trace;
        this.fRank = rank;
        this.fTimestamp = timestamp != null ? timestamp : TmfTimestamp.ZERO;
        this.fType = GenericFtraceEventTypeFactory.get((String)field.getName());
        this.fContent = field;
        this.fName = "ftrace_process_dump";
        this.fCallsite = null;
    }

    public @NonNull String getName() {
        return this.fName;
    }

    public @Nullable ITmfCallsite getCallsite() {
        return this.fCallsite;
    }

    public ITmfTrace getTrace() {
        ITmfTrace trace = this.fTrace;
        if (trace == null) {
            throw new IllegalStateException("Null traces are only allowed on special kind of events and getTrace() should not be called on them");
        }
        return trace;
    }

    public long getRank() {
        return this.fRank;
    }

    public ITmfTimestamp getTimestamp() {
        return this.fTimestamp;
    }

    public ITmfEventType getType() {
        return this.fType;
    }

    public ITmfEventField getContent() {
        return this.fContent;
    }
}

