/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.c;

import org.eclipse.cdt.core.dom.ast.ASTVisitor;
import org.eclipse.cdt.core.dom.ast.IASTCompletionContext;
import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTFieldReference;
import org.eclipse.cdt.core.dom.ast.IASTName;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IVariable;
import org.eclipse.cdt.internal.core.dom.parser.ASTNode;
import org.eclipse.cdt.internal.core.dom.parser.IASTAmbiguityParent;
import org.eclipse.cdt.internal.core.dom.parser.ProblemType;
import org.eclipse.cdt.internal.core.dom.parser.c.CVisitor;

public class CASTFieldReference
extends ASTNode
implements IASTFieldReference,
IASTAmbiguityParent,
IASTCompletionContext {
    private IASTExpression owner;
    private IASTName name;
    private boolean ptr;

    public CASTFieldReference() {
    }

    public CASTFieldReference(IASTName name, IASTExpression owner) {
        this(name, owner, false);
    }

    public CASTFieldReference(IASTName name, IASTExpression owner, boolean ptr) {
        this.setFieldOwner(owner);
        this.setFieldName(name);
        this.ptr = ptr;
    }

    @Override
    public CASTFieldReference copy() {
        return this.copy(IASTNode.CopyStyle.withoutLocations);
    }

    @Override
    public CASTFieldReference copy(IASTNode.CopyStyle style) {
        CASTFieldReference copy = new CASTFieldReference();
        copy.setFieldOwner(this.owner == null ? null : this.owner.copy(style));
        copy.setFieldName(this.name == null ? null : this.name.copy(style));
        copy.ptr = this.ptr;
        return this.copy(copy, style);
    }

    @Override
    public IASTExpression getFieldOwner() {
        return this.owner;
    }

    @Override
    public void setFieldOwner(IASTExpression expression) {
        this.assertNotFrozen();
        this.owner = expression;
        if (expression != null) {
            expression.setParent(this);
            expression.setPropertyInParent(FIELD_OWNER);
        }
    }

    @Override
    public IASTName getFieldName() {
        return this.name;
    }

    @Override
    public void setFieldName(IASTName name) {
        this.assertNotFrozen();
        this.name = name;
        if (name != null) {
            name.setParent(this);
            name.setPropertyInParent(FIELD_NAME);
        }
    }

    @Override
    public boolean isPointerDereference() {
        return this.ptr;
    }

    @Override
    public void setIsPointerDereference(boolean value) {
        this.assertNotFrozen();
        this.ptr = value;
    }

    @Override
    public boolean accept(ASTVisitor action) {
        if (action.shouldVisitExpressions) {
            switch (action.visit(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        if (this.owner != null && !this.owner.accept(action)) {
            return false;
        }
        if (this.name != null && !this.name.accept(action)) {
            return false;
        }
        if (action.shouldVisitExpressions) {
            switch (action.leave(this)) {
                case 2: {
                    return false;
                }
                case 1: {
                    return true;
                }
            }
        }
        return true;
    }

    @Override
    public int getRoleForName(IASTName n) {
        if (n == this.name) {
            return 1;
        }
        return 3;
    }

    @Override
    public void replace(IASTNode child, IASTNode other) {
        if (child == this.owner) {
            other.setPropertyInParent(child.getPropertyInParent());
            other.setParent(child.getParent());
            this.owner = (IASTExpression)other;
        }
    }

    @Override
    public IType getExpressionType() {
        IBinding binding = this.getFieldName().resolveBinding();
        if (binding instanceof IVariable) {
            return ((IVariable)binding).getType();
        }
        return new ProblemType(10004);
    }

    @Override
    public boolean isLValue() {
        if (this.isPointerDereference()) {
            return true;
        }
        return this.getFieldOwner().isLValue();
    }

    @Override
    public final IASTExpression.ValueCategory getValueCategory() {
        return this.isLValue() ? IASTExpression.ValueCategory.LVALUE : IASTExpression.ValueCategory.PRVALUE;
    }

    @Override
    public IBinding[] findBindings(IASTName n, boolean isPrefix) {
        return CVisitor.findBindingsForContentAssist(n, isPrefix);
    }
}

