/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.scr.impl.metadata;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.felix.scr.impl.metadata.ComponentMetadata;
import org.apache.felix.scr.impl.metadata.MetadataStoreHelper;

public class ServiceMetadata {
    private Boolean m_serviceFactory;
    private String m_scopeName;
    private Scope m_scope = Scope.singleton;
    private List<String> m_provides = new ArrayList<String>();
    private boolean m_validated = false;

    public void setServiceFactory(boolean serviceFactory) {
        if (this.m_validated) {
            return;
        }
        this.m_serviceFactory = serviceFactory;
    }

    public void setScope(String scopeName) {
        if (this.m_validated) {
            return;
        }
        this.m_scopeName = scopeName;
    }

    public Scope getScope() {
        return this.m_scope;
    }

    public void addProvide(String provide) {
        if (this.m_validated) {
            return;
        }
        this.m_provides.add(provide);
    }

    public String[] getProvides() {
        return this.m_provides.toArray(new String[this.m_provides.size()]);
    }

    void validate(ComponentMetadata componentMetadata) {
        if (this.m_provides.size() == 0) {
            throw componentMetadata.validationFailure("At least one provided interface must be declared in the service element");
        }
        for (String provide : this.m_provides) {
            if (provide != null) continue;
            throw componentMetadata.validationFailure("Null provides.  Possibly service is not specified as value of attribute 'interface'");
        }
        if (this.m_serviceFactory != null) {
            if (componentMetadata.getDSVersion().isDS13()) {
                throw componentMetadata.validationFailure("service-factory can only be specified in version 1.2 and earlier");
            }
            Scope scope = this.m_scope = this.m_serviceFactory != false ? Scope.bundle : Scope.singleton;
        }
        if (this.m_scopeName != null) {
            if (!componentMetadata.getDSVersion().isDS13()) {
                throw componentMetadata.validationFailure("service scope can only be specified in version 1.3 and later");
            }
            try {
                this.m_scope = Scope.valueOf(this.m_scopeName);
            }
            catch (IllegalArgumentException e) {
                throw componentMetadata.validationFailure("Service scope may be only 'singleton' 'bundle' or 'prototype' not " + this.m_scopeName);
            }
        }
        this.m_validated = true;
    }

    void collectStrings(Set<String> strings) {
        for (String s : this.m_provides) {
            MetadataStoreHelper.addString(s, strings);
        }
        MetadataStoreHelper.addString(this.m_scopeName, strings);
        MetadataStoreHelper.addString(this.m_scope.toString(), strings);
    }

    void store(DataOutputStream out, MetadataStoreHelper.MetaDataWriter metaDataWriter) throws IOException {
        out.writeInt(this.m_provides.size());
        for (String s : this.m_provides) {
            metaDataWriter.writeString(s, out);
        }
        metaDataWriter.writeString(this.m_scopeName, out);
        metaDataWriter.writeString(this.m_scope.toString(), out);
        out.writeBoolean(this.m_serviceFactory != null);
        if (this.m_serviceFactory != null) {
            out.writeBoolean(this.m_serviceFactory);
        }
    }

    static ServiceMetadata load(DataInputStream in, MetadataStoreHelper.MetaDataReader metaDataReader) throws IOException {
        ServiceMetadata result = new ServiceMetadata();
        int providerSize = in.readInt();
        for (int i = 0; i < providerSize; ++i) {
            result.addProvide(metaDataReader.readString(in));
        }
        result.m_scopeName = metaDataReader.readString(in);
        result.m_scope = Scope.valueOf(metaDataReader.readString(in));
        if (in.readBoolean()) {
            result.m_serviceFactory = in.readBoolean();
        }
        result.m_validated = true;
        return result;
    }

    public static enum Scope {
        singleton,
        bundle,
        prototype;

    }
}

