/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.debugging.model;

import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.ease.debugging.events.model.SetVariablesRequest;
import org.eclipse.ease.debugging.model.EaseDebugTarget;
import org.eclipse.ease.debugging.model.EaseDebugValue;

public class EaseDebugVariable
implements IVariable,
Comparable<EaseDebugVariable> {
    private IDebugElement fParent;
    private final String fName;
    private EaseDebugValue fValue;
    private final String fReferenceTypeName;
    private boolean fChanged = false;
    private Type fType = Type.NATIVE;

    public EaseDebugVariable(String name, Object value, IDebugElement parent, String referenceTypeName) {
        this.fName = name;
        this.fValue = new EaseDebugValue(parent, value);
        this.fParent = parent;
        this.fReferenceTypeName = referenceTypeName;
        if (EaseDebugValue.isPrimitiveType(this.getValue().getValue())) {
            this.fType = Type.PRIMITIVE;
        }
    }

    public EaseDebugVariable(String name, Object value, String referenceTypeName) {
        this(name, value, null, referenceTypeName);
    }

    public void setParent(IDebugElement parent) {
        this.fParent = parent;
        this.getValue().setParent(this.fParent);
    }

    protected IDebugElement getParent() {
        return this.fParent;
    }

    public EaseDebugValue getValue() {
        return this.fValue;
    }

    public String getName() {
        return this.fName;
    }

    public String getReferenceTypeName() {
        return this.fReferenceTypeName != null ? this.fReferenceTypeName : this.fValue.getReferenceTypeName();
    }

    public boolean hasValueChanged() {
        return this.fChanged;
    }

    public String toString() {
        return String.valueOf(this.getName()) + ":" + this.getValue().getValueString();
    }

    public String getModelIdentifier() {
        return this.getDebugTarget().getModelIdentifier();
    }

    public EaseDebugTarget getDebugTarget() {
        return (EaseDebugTarget)this.fParent.getDebugTarget();
    }

    public ILaunch getLaunch() {
        return this.getDebugTarget().getLaunch();
    }

    public <T> T getAdapter(Class<T> adapter) {
        return null;
    }

    public boolean supportsValueModification() {
        return true;
    }

    public boolean verifyValue(String expression) {
        return true;
    }

    public void setValue(String expression) throws DebugException {
        this.getDebugTarget().fireDispatchEvent(new SetVariablesRequest(this.fParent, this, expression));
    }

    public void setValue(IValue value) throws DebugException {
        this.setValue(value.getValueString());
    }

    public boolean verifyValue(IValue value) {
        try {
            return this.verifyValue(value.getValueString());
        }
        catch (DebugException e) {
            return false;
        }
    }

    public void update(EaseDebugValue value) {
        value.setParent(this.getParent());
        this.fChanged = !this.getValue().getValueString().equals(value.getValueString());
        this.fValue = value;
    }

    @Override
    public int compareTo(EaseDebugVariable o) {
        return this.getName().compareTo(o.getName());
    }

    public Type getType() {
        return this.fType;
    }

    public void setType(Type type) {
        this.fType = type;
    }

    public static enum Type {
        PRIMITIVE,
        NATIVE,
        NATIVE_OBJECT,
        NATIVE_ARRAY,
        JAVA_OBJECT;

    }
}

