/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.viewers.xychart.linechart;

import java.text.Format;
import java.util.Arrays;
import java.util.List;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGBA;
import org.eclipse.swt.widgets.Control;
import org.eclipse.tracecompass.internal.tmf.ui.Messages;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.ui.viewers.TmfAbstractToolTipHandler;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.IAxis;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.ITmfChartTimeProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.IXYSeries;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.TmfBaseProvider;
import org.eclipse.tracecompass.tmf.ui.viewers.xychart.linechart.TmfCommonXAxisChartViewer;

public class TmfCommonXLineChartTooltipProvider
extends TmfBaseProvider {
    private XYToolTipHandler fToolTipHandler = new XYToolTipHandler();

    public TmfCommonXLineChartTooltipProvider(ITmfChartTimeProvider tmfChartViewer) {
        super(tmfChartViewer);
        this.register();
    }

    @Override
    public TmfAbstractToolTipHandler getTooltipHandler() {
        return this.fToolTipHandler;
    }

    @Override
    public void refresh() {
    }

    private final class XYToolTipHandler
    extends TmfAbstractToolTipHandler {
        private static final String HTML_COLOR_TOOLTIP = "<span style=\"color:%s;\">%s</span>";

        private XYToolTipHandler() {
        }

        private boolean isValid(int index, IXYSeries serie) {
            double[] ySeries = serie.getYSeries();
            return serie.isVisible() && ySeries != null && ySeries.length > index;
        }

        @Override
        public void fill(Control control, MouseEvent event, Point pt) {
            if (TmfCommonXLineChartTooltipProvider.this.getChartViewer().getWindowDuration() != 0L) {
                IAxis xAxis = TmfCommonXLineChartTooltipProvider.this.getXAxis();
                double xCoordinate = xAxis.getDataCoordinate(pt.x);
                List<IXYSeries> series = TmfCommonXLineChartTooltipProvider.this.getSeries();
                if (xCoordinate < 0.0 || series.isEmpty()) {
                    return;
                }
                double[] xS = series.get(0).getXSeries();
                if (xS == null) {
                    return;
                }
                int index = Arrays.binarySearch(xS, xCoordinate);
                index = index >= 0 ? index : -index - 1;
                int maxLen = 0;
                for (IXYSeries serie : series) {
                    if (!this.isValid(index, serie)) continue;
                    maxLen = Math.max(maxLen, serie.getId().length());
                }
                TmfCommonXAxisChartViewer viewer = null;
                Format format = null;
                ITmfChartTimeProvider timeProvider = TmfCommonXLineChartTooltipProvider.this.getChartViewer();
                if (timeProvider instanceof TmfCommonXAxisChartViewer) {
                    viewer = (TmfCommonXAxisChartViewer)timeProvider;
                    format = viewer.getSwtChart().getAxisSet().getYAxes()[0].getTick().getFormat();
                }
                ITmfTimestamp time = TmfTimestamp.fromNanos((long)((long)xCoordinate + TmfCommonXLineChartTooltipProvider.this.getChartViewer().getTimeOffset()));
                this.addItem(null, TmfAbstractToolTipHandler.ToolTipString.fromString(Messages.TmfCommonXLineChartTooltipProvider_time), TmfAbstractToolTipHandler.ToolTipString.fromTimestamp(time.toString(), time.toNanos()));
                for (IXYSeries serie : series) {
                    double[] yS = serie.getYSeries();
                    if (!this.isValid(index, serie)) continue;
                    String key = serie.getId();
                    Color color = serie.getColor();
                    if (key != null && color != null && viewer != null) {
                        RGBA rgba = color.getRGBA();
                        RGBAColor rgbaColor = new RGBAColor(rgba.rgb.red, rgba.rgb.green, rgba.rgb.blue, rgba.alpha);
                        key = String.format(HTML_COLOR_TOOLTIP, rgbaColor, key);
                    }
                    if (key == null) {
                        key = "";
                    }
                    double yValue = yS[index];
                    if (format == null) {
                        this.addItem(null, TmfAbstractToolTipHandler.ToolTipString.fromHtml(key), TmfAbstractToolTipHandler.ToolTipString.fromDecimal(yValue));
                        continue;
                    }
                    this.addItem(null, TmfAbstractToolTipHandler.ToolTipString.fromHtml(key), TmfAbstractToolTipHandler.ToolTipString.fromString(format.format(yValue)));
                }
            }
        }
    }
}

