/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers;

import org.eclipse.tracecompass.analysis.os.linux.core.kernel.StateValues;
import org.eclipse.tracecompass.analysis.os.linux.core.model.ProcessStatus;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.Attributes;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandlerUtils;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.statevalue.ITmfStateValue;
import org.eclipse.tracecompass.statesystem.core.statevalue.TmfStateValue;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.event.ITmfEventField;

public class SchedSwitchHandler
extends KernelEventHandler {
    public SchedSwitchHandler(IKernelAnalysisEventLayout layout) {
        super(layout);
    }

    @Override
    public void handleEvent(ITmfStateSystemBuilder ss, ITmfEvent event) throws AttributeNotFoundException {
        Integer cpu = KernelEventHandlerUtils.getCpu(event);
        if (cpu == null) {
            return;
        }
        ITmfEventField content = event.getContent();
        String prevProcessName = (String)content.getFieldValue(String.class, new String[]{this.getLayout().fieldPrevComm()});
        Integer prevTid = (Integer)content.getFieldValue(Integer.class, new String[]{this.getLayout().fieldPrevTid()});
        Long prevState = (Long)content.getFieldValue(Long.class, new String[]{this.getLayout().fieldPrevState()});
        Integer prevPrio = (Integer)content.getFieldValue(Integer.class, new String[]{this.getLayout().fieldPrevPrio()});
        String nextProcessName = (String)content.getFieldValue(String.class, new String[]{this.getLayout().fieldNextComm()});
        Integer nextTid = (Integer)content.getFieldValue(Integer.class, new String[]{this.getLayout().fieldNextTid()});
        Integer nextPrio = (Integer)content.getFieldValue(Integer.class, new String[]{this.getLayout().fieldNextPrio()});
        if (prevTid == null || prevState == null || nextTid == null) {
            return;
        }
        String formerThreadAttributeName = Attributes.buildThreadAttributeName(prevTid, cpu);
        String currenThreadAttributeName = Attributes.buildThreadAttributeName(nextTid, cpu);
        int nodeThreads = KernelEventHandlerUtils.getNodeThreads(ss);
        int formerThreadNode = ss.getQuarkRelativeAndAdd(nodeThreads, new String[]{formerThreadAttributeName});
        int newCurrentThreadNode = ss.getQuarkRelativeAndAdd(nodeThreads, new String[]{currenThreadAttributeName});
        long timestamp = KernelEventHandlerUtils.getTimestamp(event);
        SchedSwitchHandler.setOldProcessStatus(ss, prevState, formerThreadNode, cpu, timestamp);
        KernelEventHandlerUtils.setProcessToRunning(timestamp, newCurrentThreadNode, ss);
        int quark = ss.getQuarkRelativeAndAdd(newCurrentThreadNode, new String[]{"Current_cpu_rq"});
        ss.modifyAttribute(timestamp, (Object)cpu, quark);
        if (prevProcessName != null) {
            SchedSwitchHandler.setProcessExecName(ss, prevProcessName, formerThreadNode, timestamp);
        }
        if (nextProcessName != null) {
            SchedSwitchHandler.setProcessExecName(ss, nextProcessName, newCurrentThreadNode, timestamp);
        }
        if (prevPrio != null) {
            SchedSwitchHandler.setProcessPrio(ss, prevPrio, formerThreadNode, timestamp);
        }
        if (nextPrio != null) {
            SchedSwitchHandler.setProcessPrio(ss, nextPrio, newCurrentThreadNode, timestamp);
        }
        int currentCPUNode = KernelEventHandlerUtils.getCurrentCPUNode(cpu, ss);
        SchedSwitchHandler.setCpuProcess(ss, nextTid, timestamp, currentCPUNode);
        SchedSwitchHandler.setCpuStatus(ss, nextTid, newCurrentThreadNode, timestamp, currentCPUNode, cpu);
    }

    private static void setOldProcessStatus(ITmfStateSystemBuilder ss, Long prevState, Integer formerThreadNode, int cpu, long timestamp) {
        ITmfStateValue value = ProcessStatus.getStatusFromKernelState(prevState).getStateValue();
        ss.modifyAttribute(timestamp, value.unboxValue(), formerThreadNode.intValue());
        boolean staysOnRunQueue = ProcessStatus.WAIT_CPU.getStateValue().equals(value);
        int quark = ss.getQuarkRelativeAndAdd(formerThreadNode.intValue(), new String[]{"Current_cpu_rq"});
        value = staysOnRunQueue ? TmfStateValue.newValueInt((int)cpu) : TmfStateValue.nullValue();
        ss.modifyAttribute(timestamp, value.unboxValue(), quark);
    }

    private static void setCpuStatus(ITmfStateSystemBuilder ss, Integer nextTid, Integer newCurrentThreadNode, long timestamp, int currentCPUNode, int cpu) {
        if (nextTid > 0) {
            int quark = ss.getQuarkRelativeAndAdd(newCurrentThreadNode.intValue(), new String[]{"System_call"});
            ITmfStateValue queryOngoingState = ss.queryOngoingState(quark);
            ITmfStateValue value = queryOngoingState.isNull() ? StateValues.CPU_STATUS_RUN_USERMODE_VALUE : StateValues.CPU_STATUS_RUN_SYSCALL_VALUE;
            ss.modifyAttribute(timestamp, value.unboxValue(), currentCPUNode);
        } else {
            KernelEventHandlerUtils.updateCpuStatus(timestamp, cpu, ss);
        }
    }

    private static void setCpuProcess(ITmfStateSystemBuilder ss, Integer nextTid, long timestamp, int currentCPUNode) {
        int quark = ss.getQuarkRelativeAndAdd(currentCPUNode, new String[]{"Current_thread"});
        ss.modifyAttribute(timestamp, (Object)nextTid, quark);
    }

    private static void setProcessPrio(ITmfStateSystemBuilder ss, Integer prio, Integer threadNode, long timestamp) {
        int quark = ss.getQuarkRelativeAndAdd(threadNode.intValue(), new String[]{"Prio"});
        ss.modifyAttribute(timestamp, (Object)prio, quark);
    }

    private static void setProcessExecName(ITmfStateSystemBuilder ss, String processName, Integer threadNode, long timestamp) {
        int quark = ss.getQuarkRelativeAndAdd(threadNode.intValue(), new String[]{"Exec_name"});
        ss.modifyAttribute(timestamp, (Object)processName, quark);
    }
}

