/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ls.core.internal.javadoc;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.ILocalVariable;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.ITypeParameter;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.IDocElement;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.MemberRef;
import org.eclipse.jdt.core.dom.MethodRef;
import org.eclipse.jdt.core.dom.MethodRefParameter;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.TagElement;
import org.eclipse.jdt.core.dom.TextElement;
import org.eclipse.jdt.core.manipulation.internal.javadoc.CoreJavaDocSnippetStringEvaluator;
import org.eclipse.jdt.core.manipulation.internal.javadoc.CoreJavadocAccess;
import org.eclipse.jdt.core.manipulation.internal.javadoc.CoreJavadocAccessImpl;
import org.eclipse.jdt.core.manipulation.internal.javadoc.CoreJavadocContentAccessUtility;
import org.eclipse.jdt.core.manipulation.internal.javadoc.CoreMarkdownAccessImpl;
import org.eclipse.jdt.core.manipulation.internal.javadoc.IJavadocContentFactory;
import org.eclipse.jdt.core.manipulation.internal.javadoc.JavadocLookup;
import org.eclipse.jdt.internal.core.manipulation.JavaManipulationPlugin;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.ui.viewsupport.CoreJavaElementLinks;
import org.eclipse.jdt.ls.core.internal.JDTUtils;
import org.eclipse.jdt.ls.core.internal.JavaLanguageServerPlugin;
import org.eclipse.jdt.ls.core.internal.javadoc.JavaDoc2MarkdownConverter;
import org.eclipse.jdt.ls.core.internal.javadoc.JavaDoc2PlainTextConverter;
import org.eclipse.jdt.ls.core.internal.javadoc.JavaDocHTMLPathHandler;
import org.eclipse.lsp4j.Location;

public class JavadocContentAccess2 {
    public static final String SNIPPET = "SNIPPET";
    public static final IJavadocContentFactory JDT_LS_JAVADOC_CONTENT_FACTORY = new IJavadocContentFactory(){

        public IJavadocContentFactory.IJavadocAccess createJavadocAccess(IJavaElement element, Javadoc javadoc, String source, JavadocLookup lookup) {
            if (source.startsWith("///")) {
                if (lookup == null) {
                    return new CoreMarkdownAccessImpl(element, javadoc, source);
                }
                return new CoreMarkdownAccessImpl(element, javadoc, source, lookup);
            }
            if (lookup == null) {
                return new JdtLsJavadocAccessImpl(element, javadoc, source);
            }
            return new JdtLsJavadocAccessImpl(element, javadoc, source, lookup);
        }
    };

    @Deprecated
    public static Reader getPlainTextContentReader(IMember member) throws JavaModelException {
        String content = JavadocContentAccess2.getPlainTextContent(member);
        return content == null ? null : new StringReader(content);
    }

    @Deprecated
    public static Reader getMarkdownContentReader(IJavaElement member) throws JavaModelException {
        String content = JavadocContentAccess2.getMarkdownContent(member);
        return content == null ? null : new StringReader(content);
    }

    public static String getPlainTextContent(IMember member) throws JavaModelException {
        Reader contentReader = CoreJavadocContentAccessUtility.getHTMLContentReader((IMember)member, (boolean)true, (boolean)true);
        if (contentReader != null) {
            try {
                return new JavaDoc2PlainTextConverter(contentReader).getAsString();
            }
            catch (IOException e) {
                throw new JavaModelException((Throwable)e, 1009);
            }
        }
        return null;
    }

    public static String getMarkdownContent(IJavaElement element) {
        CoreJavadocAccess access = JavadocContentAccess2.createJdtLsJavadocAccess();
        try {
            block49: {
                String content = JavadocContentAccess2.getJavaDocNode(element);
                if (content == null || !content.startsWith("///")) break block49;
                Javadoc node = CoreJavadocContentAccessUtility.getJavadocNode((IJavaElement)element, (String)content);
                HashMap<String, List> javadocTags = new HashMap<String, List>();
                StringBuilder buf = new StringBuilder();
                for (Object e : node.tags()) {
                    TagElement tag = (TagElement)e;
                    if (tag.getTagName() != null) {
                        javadocTags.computeIfAbsent(tag.getTagName(), k -> new ArrayList()).add(tag);
                        continue;
                    }
                    buf.append("\n");
                    JavadocContentAccess2.collectTagElements(content, element, tag, buf);
                }
                for (Map.Entry entry : javadocTags.entrySet()) {
                    String tagName;
                    String heading = switch (tagName = (String)entry.getKey()) {
                        case "@apiNote" -> "API Note:";
                        case "@author" -> "Author:";
                        case "@implSpec" -> "Impl Spec:";
                        case "@implNote" -> "Impl Note:";
                        case "@param" -> "Parameters:";
                        case "@provides" -> "Provides:";
                        case "@return" -> "Returns:";
                        case "@throws" -> "Throws:";
                        case "@exception" -> "Throws:";
                        case "@since" -> "Since:";
                        case "@see" -> "See:";
                        case "@version" -> "See:";
                        case "@uses" -> "Uses:";
                        default -> "";
                    };
                    buf.append("\n");
                    buf.append("* **" + heading + "**");
                    for (TagElement tag : (List)entry.getValue()) {
                        buf.append("\n");
                        buf.append("  * ");
                        JavadocContentAccess2.collectTagElements(content, element, tag, buf);
                    }
                }
                return buf.length() > 0 ? buf.substring(1) : content;
            }
            String rawHtml = access.getHTMLContent(element, true);
            return new JavaDoc2MarkdownConverter(rawHtml).getAsString();
        }
        catch (IOException | CoreException throwable) {
            return null;
        }
    }

    private static void collectTagElements(String content, IJavaElement element, TagElement tag, StringBuilder buf) {
        LinkedList queue = new LinkedList();
        queue.addAll(tag.fragments());
        while (!queue.isEmpty()) {
            int nextStart;
            ASTNode e = (ASTNode)queue.pop();
            if (e instanceof TagElement) {
                TagElement t = (TagElement)e;
                if ("@link".equals(t.getTagName()) || "@linkplain".equals(t.getTagName())) {
                    JavadocContentAccess2.collectLinkedTag(element, t, buf);
                } else {
                    JavadocContentAccess2.collectTagElements(content, element, t, buf);
                }
            } else if (e instanceof TextElement) {
                buf.append(((TextElement)e).getText());
            } else if ("@see".equals(tag.getTagName())) {
                JavadocContentAccess2.collectLinkedTag(element, tag, buf);
            }
            ASTNode next = (ASTNode)queue.peek();
            if (next == null) continue;
            int currEnd = e.getStartPosition() + e.getLength();
            if (currEnd != (nextStart = next.getStartPosition())) {
                if (content.substring(currEnd, nextStart).split("///").length > 2) {
                    buf.append("  \n");
                    continue;
                }
                buf.append("\n");
                continue;
            }
            buf.append(" ");
        }
    }

    private static void collectLinkedTag(IJavaElement element, TagElement t, StringBuilder buf) {
        List children = t.fragments();
        if (t.fragments().size() > 0) {
            try {
                String[] res;
                String linkTitle;
                if (t.fragments().size() == 2) {
                    linkTitle = ((TextElement)t.fragments().get(0)).getText();
                    res = JavadocContentAccess2.collectLinkElement((ASTNode)children.get(1));
                } else {
                    res = JavadocContentAccess2.collectLinkElement((ASTNode)children.get(0));
                    linkTitle = res[0].isEmpty() && ((IDocElement)children.get(0)).toString().startsWith("#") && res.length > 1 ? res[1] : res[0];
                }
                buf.append("[" + linkTitle + "]");
                String uri = JdtLsJavadocAccessImpl.createLinkURIHelper("eclipse-javadoc", element, res[0], res.length > 1 ? res[1] : null, res.length > 2 ? Arrays.asList(res).subList(2, res.length).toArray(new String[0]) : null);
                buf.append("(" + uri + ")");
            }
            catch (URISyntaxException ex) {
                JavaManipulationPlugin.log((Throwable)ex);
            }
        }
    }

    private static String[] collectLinkElement(ASTNode e) {
        String refTypeName = null;
        String refMemberName = null;
        String[] refMethodParamTypes = null;
        String[] refMethodParamNames = null;
        if (e instanceof Name) {
            Name name = (Name)e;
            refTypeName = name.getFullyQualifiedName();
        } else if (e instanceof MemberRef) {
            MemberRef memberRef = (MemberRef)e;
            Name qualifier = memberRef.getQualifier();
            refTypeName = qualifier == null ? "" : qualifier.getFullyQualifiedName();
            refMemberName = memberRef.getName().getIdentifier();
        } else if (e instanceof MethodRef) {
            MethodRef methodRef = (MethodRef)e;
            Name qualifier = methodRef.getQualifier();
            refTypeName = qualifier == null ? "" : qualifier.getFullyQualifiedName();
            refMemberName = methodRef.getName().getIdentifier();
            List params = methodRef.parameters();
            int ps = params.size();
            refMethodParamTypes = new String[ps];
            refMethodParamNames = new String[ps];
            int i = 0;
            while (i < ps) {
                MethodRefParameter param = (MethodRefParameter)params.get(i);
                refMethodParamTypes[i] = ASTNodes.asString((ASTNode)param.getType());
                SimpleName paramName = param.getName();
                if (paramName != null) {
                    refMethodParamNames[i] = paramName.getIdentifier();
                }
                ++i;
            }
        } else if (e instanceof TextElement) {
            refTypeName = ((TextElement)e).getText();
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(refTypeName);
        if (refMemberName != null) {
            result.add(refMemberName);
        }
        if (refMethodParamTypes != null) {
            result.addAll(Arrays.asList(refMethodParamTypes));
        }
        return result.toArray(new String[0]);
    }

    private static CoreJavadocAccess createJdtLsJavadocAccess() {
        return new CoreJavadocAccess(JDT_LS_JAVADOC_CONTENT_FACTORY){
            protected final String UL_CLASS_BLOCK_LIST = "<ul class=\"blockList\">";
            protected final String CONTENT_CONTAINER = "<div class=\"contentContainer\">";

            public String getHTMLContent(IPackageFragment packageFragment) throws CoreException {
                String content = this.readHTMLContent(packageFragment);
                return this.sanitizePackageJavadoc(content);
            }

            protected String sanitizePackageJavadoc(String content) {
                int nextListIndex;
                if (content == null || content.isEmpty()) {
                    return content;
                }
                if (content.indexOf("<div class=\"contentContainer\">") == 0 && (nextListIndex = content.indexOf("<ul class=\"blockList\">")) > 0) {
                    content = content.substring("<div class=\"contentContainer\">".length(), nextListIndex);
                }
                return content;
            }

            protected StringBuffer createSuperMethodReferencesHTML(ArrayList<IMethod> superInterfaceMethods, IMethod superClassMethod) {
                return null;
            }
        };
    }

    public static String getJavaDocNode(IJavaElement element) throws JavaModelException {
        IMember member;
        if (element instanceof ILocalVariable) {
            member = ((ILocalVariable)element).getDeclaringMember();
        } else if (element instanceof ITypeParameter) {
            member = ((ITypeParameter)element).getDeclaringMember();
        } else if (element instanceof IMember) {
            member = (IMember)element;
        } else {
            return null;
        }
        IBuffer buf = member.getOpenable().getBuffer();
        if (buf == null) {
            return null;
        }
        ISourceRange javadocRange = member.getJavadocRange();
        if (javadocRange == null) {
            return null;
        }
        String rawJavadoc = buf.getText(javadocRange.getOffset(), javadocRange.getLength());
        return rawJavadoc;
    }

    private static class JdtLsJavadocAccessImpl
    extends CoreJavadocAccessImpl {
        public JdtLsJavadocAccessImpl(IJavaElement element, Javadoc javadoc, String source) {
            super(element, javadoc, source);
        }

        public JdtLsJavadocAccessImpl(IJavaElement element, Javadoc javadoc, String source, JavadocLookup lookup) {
            super(element, javadoc, source, lookup);
        }

        protected CoreJavaDocSnippetStringEvaluator createSnippetEvaluator(IJavaElement element) {
            return new CoreJavaDocSnippetStringEvaluator(this.fElement){

                protected String getOneTagElementString(TagElement snippetTag, Object fragment) {
                    String str = super.getOneTagElementString(snippetTag, fragment);
                    return JavadocContentAccess2.SNIPPET + str;
                }

                protected String getModifiedStringForTagElement(TagElement tagElement, List<TagElement> tagElements) {
                    Object str = super.getModifiedString(tagElement, tagElements);
                    if ("@link".equals(tagElement.getTagName())) {
                        int leadingSpaces = 0;
                        while (((String)str).length() > leadingSpaces + 1 && ((String)str).charAt(leadingSpaces) == ' ') {
                            ++leadingSpaces;
                        }
                        try {
                            str = new JavaDoc2MarkdownConverter((String)str).getAsString();
                            int i = 0;
                            while (i < leadingSpaces) {
                                str = " " + (String)str;
                                ++i;
                            }
                            str = (String)str + "  \n";
                        }
                        catch (IOException e) {
                            JavaLanguageServerPlugin.logException(e.getMessage(), e);
                        }
                    }
                    return str;
                }

                protected String getDefaultBoldTag() {
                    return "**";
                }

                protected String getDefaultItalicTag() {
                    return "*";
                }

                protected String getDefaultHighlightedTag() {
                    return "***";
                }

                protected String getStartTag(String tag) {
                    return tag;
                }

                protected String getEndTag(String tag) {
                    return tag;
                }
            };
        }

        protected void handleInlineTagElement(TagElement node) {
            String name = node.getTagName();
            if ("@value".equals(name) && this.handleValueTag(node)) {
                return;
            }
            boolean isLink = "@link".equals(name);
            boolean isLinkplain = "@linkplain".equals(name);
            boolean isCode = "@code".equals(name);
            boolean isLiteral = "@literal".equals(name);
            boolean isSummary = "@summary".equals(name);
            boolean isIndex = "@index".equals(name);
            boolean isSnippet = "@snippet".equals(name);
            boolean isReturn = "@return".equals(name);
            if (isLiteral || isCode || isSummary || isIndex) {
                ++this.fLiteralContent;
            }
            if (isCode || isLink && this.addCodeTagOnLink()) {
                if (isCode && this.fPreCounter > 0 && this.fBuf.lastIndexOf("<pre>") == this.fBuf.length() - 5) {
                    this.fInPreCodeCounter = this.fPreCounter - 1;
                }
                this.fBuf.append("<code>");
            }
            if (isReturn) {
                this.fBuf.append("Returns");
            }
            if (isLink || isLinkplain) {
                this.handleLink(node.fragments());
            } else if (isSummary) {
                this.handleSummary(node.fragments());
            } else if (isIndex) {
                this.handleIndex(node.fragments());
            } else if (isCode || isLiteral) {
                this.handleContentElements(node.fragments(), true, node);
            } else if (isReturn) {
                this.handleContentElements(node.fragments(), false, node);
            } else if (isSnippet) {
                this.handleSnippet(node);
            } else if (!this.handleInheritDoc(node) && !this.handleDocRoot(node)) {
                int start = node.getStartPosition();
                String text = this.fSource.substring(start, start + node.getLength());
                this.fBuf.append(this.removeDocLineIntros(text));
            }
            if (isReturn) {
                this.fBuf.append(".");
            }
            if (isCode || isLink && this.addCodeTagOnLink()) {
                this.fBuf.append("</code>");
            }
            if (isSnippet) {
                this.fBuf.append("</code></pre>");
            }
            if (isLiteral || isCode || isSummary || isIndex) {
                --this.fLiteralContent;
            }
        }

        protected void handleSnippet(TagElement node) {
            if (node != null) {
                Object val = node.getProperty("IsSnippetValid");
                Object valError = node.getProperty("SnippetError");
                if (val instanceof Boolean && ((Boolean)val).booleanValue() && valError == null) {
                    int fs = node.fragments().size();
                    if (fs > 0) {
                        this.fBuf.append("<pre>");
                        Object valID = node.getProperty("SnippetID");
                        if (valID instanceof String && !valID.toString().isBlank()) {
                            this.fBuf.append("<code id=" + valID.toString() + ">");
                        } else {
                            this.fBuf.append("<code>");
                        }
                        this.fSnippetStringEvaluator.AddTagElementString(node, this.fBuf);
                    }
                } else {
                    this.handleInvalidSnippet(node);
                }
            }
        }

        protected void handleInLineTextElement(TextElement te, boolean skipLeadingWhitespace, TagElement tagElement, ASTNode previousNode) {
            String text = te.getText();
            if (JavaDocHTMLPathHandler.containsHTMLTag(text)) {
                text = JavaDocHTMLPathHandler.getValidatedHTMLSrcAttribute(te, this.fElement);
            }
            if (skipLeadingWhitespace) {
                text = text.replaceFirst("^\\s", "");
            }
            text = text.replaceAll("(\r\n?|\n)([ \t]*\\*)", "$1");
            text = this.handlePreCounter(tagElement, text);
            this.handleInLineText(text, previousNode);
        }

        protected void handleLink(List<? extends ASTNode> fragments) {
            TextElement textElement;
            String text;
            if (fragments == null || fragments.isEmpty()) {
                return;
            }
            ASTNode aSTNode = fragments.get(0);
            if (aSTNode instanceof TextElement && (text = (textElement = (TextElement)aSTNode).getText()).contains("##")) {
                String interestingPart = text.replaceFirst("##\\w+\\s*", "");
                this.handleText(interestingPart);
                return;
            }
            super.handleLink(fragments);
        }

        protected boolean addCodeTagOnLink() {
            return false;
        }

        protected void handleInLineText(String text, ASTNode previousNode) {
            TagElement previousTag;
            boolean isInSnippet = previousNode instanceof TagElement && "@snippet".equals((previousTag = (TagElement)previousNode).getTagName());
            this.handleText(this.markSnippet(text, isInSnippet));
        }

        protected void handleBlockTags(String title, List<TagElement> tags) {
            if (tags.isEmpty()) {
                return;
            }
            this.handleBlockTagTitle(title);
            this.fBuf.append(this.getBlockTagStart());
            for (TagElement tag : tags) {
                this.handleSingleTag(tag);
            }
            this.fBuf.append(this.getBlockTagEnd());
            this.fBuf.append(this.getBlockTagEntryEnd());
        }

        protected void handleSingleTag(TagElement tag) {
            this.fBuf.append(this.getBlockTagEntryStart());
            if ("@see".equals(tag.getTagName())) {
                this.handleSeeTag(tag);
            } else {
                this.handleContentElements(tag.fragments());
            }
            this.fBuf.append(this.getBlockTagEntryEnd());
        }

        protected void handleReturnTagBody(TagElement tag, CharSequence returnDescription) {
            if (tag == null) {
                return;
            }
            this.fBuf.append(this.getBlockTagStart());
            super.handleReturnTagBody(tag, returnDescription);
            this.fBuf.append(this.getBlockTagEnd());
            this.fBuf.append(this.getBlockTagEntryEnd());
        }

        protected void handleBlockTagBody(TagElement tag) {
            List fragments = tag.fragments();
            if (!fragments.isEmpty()) {
                this.fBuf.append(this.getBlockTagStart());
                this.fBuf.append(this.getBlockTagEntryStart());
                super.handleContentElements(fragments);
                this.fBuf.append(this.getBlockTagEntryEnd());
                this.fBuf.append(this.getBlockTagEnd());
            }
        }

        protected void handleBlockTagTitle(String title) {
            this.fBuf.append("<li><b>");
            this.fBuf.append(title);
            this.fBuf.append("</b>");
        }

        protected void handleExceptionTagsBody(List<TagElement> tags, List<String> exceptionNames, CharSequence[] exceptionDescriptions) {
            if (tags.isEmpty() && (exceptionNames == null || exceptionNames.isEmpty())) {
                return;
            }
            this.fBuf.append(this.getBlockTagStart());
            super.handleExceptionTagsBody(tags, exceptionNames, exceptionDescriptions);
            this.fBuf.append(this.getBlockTagEnd());
            this.fBuf.append(this.getBlockTagEntryEnd());
        }

        protected void handleParameterTags(List<TagElement> tags, List<String> parameterNames, CharSequence[] parameterDescriptions, boolean isTypeParameters) {
            if (tags.isEmpty() && this.containsOnlyNull(parameterNames)) {
                return;
            }
            String tagTitle = isTypeParameters ? "Type Parameters:" : "Parameters:";
            this.handleBlockTagTitle(tagTitle);
            if (!tags.isEmpty()) {
                this.fBuf.append(this.getBlockTagStart());
                for (TagElement tag : tags) {
                    this.handleSingleParameterTag(tag);
                }
                this.fBuf.append(this.getBlockTagEnd());
            }
            int i = 0;
            while (i < parameterDescriptions.length) {
                CharSequence description = parameterDescriptions[i];
                String name = parameterNames.get(i);
                if (name != null) {
                    this.handleSingleParameterDescription(name, description, isTypeParameters);
                }
                ++i;
            }
        }

        protected void handleSingleParameterDescription(String name, CharSequence description, boolean isTypeParameters) {
            this.fBuf.append(this.getBlockTagStart());
            super.handleSingleParameterDescription(name, description, isTypeParameters);
            this.fBuf.append(this.getBlockTagEnd());
        }

        protected String markSnippet(String text, boolean isInSnippet) {
            if (isInSnippet) {
                StringBuilder builder = new StringBuilder();
                text.lines().forEach(l -> {
                    builder.append(JavadocContentAccess2.SNIPPET);
                    builder.append((String)l);
                    builder.append("\n");
                });
                return builder.toString();
            }
            return text;
        }

        protected String createLinkURI(String scheme, IJavaElement element, String refTypeName, String refMemberName, String[] refParameterTypes) throws URISyntaxException {
            return JdtLsJavadocAccessImpl.createLinkURIHelper(scheme, this.fElement, refTypeName, refMemberName, refParameterTypes);
        }

        public static String createLinkURIHelper(String scheme, IJavaElement element, String refTypeName, String refMemberName, String[] refParameterTypes) throws URISyntaxException {
            URI javadocURI = CoreJavaElementLinks.createURIAsUri((String)scheme, (IJavaElement)element, (String)refTypeName, (String)refMemberName, (String[])refParameterTypes);
            IJavaElement linkTarget = CoreJavaElementLinks.parseURI((URI)javadocURI);
            if (linkTarget == null) {
                return "";
            }
            try {
                Location locationToElement = JDTUtils.toLocation(linkTarget);
                if (locationToElement != null) {
                    return locationToElement.getUri() + "#" + (locationToElement.getRange().getStart().getLine() + 1);
                }
            }
            catch (JavaModelException javaModelException) {
                // empty catch block
            }
            return "";
        }

        protected String getBlockTagStart() {
            return "<ul>";
        }

        protected String getBlockTagEnd() {
            return "</ul>";
        }

        protected String getBlockTagEntryStart() {
            return "<li>";
        }

        protected String getBlockTagEntryEnd() {
            return "</li>";
        }
    }
}

