/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.serialize;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.gradle.api.JavaVersion;
import org.gradle.internal.Cast;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.exceptions.Contextual;
import org.gradle.internal.exceptions.DefaultMultiCauseException;
import org.gradle.internal.exceptions.MultiCauseException;
import org.gradle.internal.io.StreamByteBuffer;
import org.gradle.internal.serialize.ContextualPlaceholderException;
import org.gradle.internal.serialize.ExceptionReplacingObjectInputStream;
import org.gradle.internal.serialize.ExceptionReplacingObjectOutputStream;
import org.gradle.internal.serialize.NestedExceptionPlaceholder;
import org.gradle.internal.serialize.PlaceholderAssertionError;
import org.gradle.internal.serialize.PlaceholderException;
import org.gradle.internal.serialize.StackTraceElementPlaceholder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ExceptionPlaceholder
implements Serializable {
    private static final Set<String> CANDIDATE_GET_CAUSES = Collections.unmodifiableSet(new HashSet<String>(){
        {
            this.add("getCauses");
            this.add("getFailures");
        }
    });
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ExceptionPlaceholder.class);
    private final String type;
    private byte[] serializedException;
    private String message;
    private String toString;
    private final boolean contextual;
    private final boolean assertionError;
    private final List<ExceptionPlaceholder> causes;
    private final List<ExceptionPlaceholder> suppressed;
    private List<StackTraceElementPlaceholder> stackTrace;
    private Throwable toStringRuntimeExec;
    private Throwable getMessageExec;

    public ExceptionPlaceholder(Throwable original, Function<OutputStream, ExceptionReplacingObjectOutputStream> objectOutputStreamCreator, Set<Throwable> dejaVu) {
        List<Object> suppressed;
        List<Object> causes;
        boolean hasCycle = !dejaVu.add(original);
        Throwable throwable = original;
        this.type = throwable.getClass().getName();
        this.contextual = throwable.getClass().getAnnotation(Contextual.class) != null;
        this.assertionError = throwable instanceof AssertionError;
        try {
            this.stackTrace = throwable.getStackTrace() == null ? Collections.emptyList() : this.convertStackTrace(throwable.getStackTrace());
        }
        catch (Throwable ignored) {
            this.stackTrace = Collections.emptyList();
        }
        try {
            this.message = throwable.getMessage();
        }
        catch (Throwable failure) {
            this.getMessageExec = failure;
        }
        if (ExceptionPlaceholder.isJava14()) {
            throwable = Java14NullPointerExceptionUsefulMessageSupport.maybeReplaceUsefulNullPointerMessage(throwable);
        }
        try {
            this.toString = throwable.toString();
        }
        catch (Throwable failure) {
            this.toStringRuntimeExec = failure;
        }
        if (hasCycle) {
            causes = Collections.emptyList();
            suppressed = Collections.emptyList();
        } else {
            causes = ExceptionPlaceholder.extractCauses(throwable);
            suppressed = ExceptionPlaceholder.extractSuppressed(throwable);
        }
        StreamByteBuffer buffer = new StreamByteBuffer();
        ExceptionReplacingObjectOutputStream oos = objectOutputStreamCreator.apply(buffer.getOutputStream());
        oos.setObjectTransformer(new Function<Object, Object>(){
            boolean seenFirst;

            @Override
            public Object apply(Object obj) {
                if (!this.seenFirst) {
                    this.seenFirst = true;
                    return obj;
                }
                int causeIndex = causes.indexOf(obj);
                if (causeIndex >= 0) {
                    return new NestedExceptionPlaceholder(NestedExceptionPlaceholder.Kind.cause, causeIndex);
                }
                int suppressedIndex = suppressed.indexOf(obj);
                if (suppressedIndex >= 0) {
                    return new NestedExceptionPlaceholder(NestedExceptionPlaceholder.Kind.suppressed, suppressedIndex);
                }
                return obj;
            }
        });
        try {
            oos.writeObject(throwable);
            oos.close();
            this.serializedException = buffer.readAsByteArray();
        }
        catch (Throwable throwable2) {
            // empty catch block
        }
        this.causes = ExceptionPlaceholder.convertToExceptionPlaceholderList(causes, objectOutputStreamCreator, dejaVu);
        this.suppressed = ExceptionPlaceholder.convertToExceptionPlaceholderList(suppressed, objectOutputStreamCreator, dejaVu);
    }

    private List<StackTraceElementPlaceholder> convertStackTrace(StackTraceElement[] stackTrace) {
        ArrayList<StackTraceElementPlaceholder> placeholders = new ArrayList<StackTraceElementPlaceholder>(stackTrace.length);
        for (StackTraceElement stackTraceElement : stackTrace) {
            placeholders.add(new StackTraceElementPlaceholder(stackTraceElement));
        }
        return placeholders;
    }

    private StackTraceElement[] convertStackTrace(List<StackTraceElementPlaceholder> placeholders) {
        StackTraceElement[] stackTrace = new StackTraceElement[placeholders.size()];
        for (int i = 0; i < placeholders.size(); ++i) {
            stackTrace[i] = placeholders.get(i).toStackTraceElement();
        }
        return stackTrace;
    }

    private static List<? extends Throwable> extractSuppressed(Throwable throwable) {
        if (ExceptionPlaceholder.isJava7()) {
            return Arrays.asList(throwable.getSuppressed());
        }
        return Collections.emptyList();
    }

    private static List<ExceptionPlaceholder> convertToExceptionPlaceholderList(List<? extends Throwable> throwables, Function<OutputStream, ExceptionReplacingObjectOutputStream> objectOutputStreamCreator, Set<Throwable> dejaVu) {
        if (throwables.isEmpty()) {
            return Collections.emptyList();
        }
        if (throwables.size() == 1) {
            return Collections.singletonList(new ExceptionPlaceholder(throwables.get(0), objectOutputStreamCreator, dejaVu));
        }
        ArrayList<ExceptionPlaceholder> placeholders = new ArrayList<ExceptionPlaceholder>(throwables.size());
        for (Throwable throwable : throwables) {
            placeholders.add(new ExceptionPlaceholder(throwable, objectOutputStreamCreator, dejaVu));
        }
        return placeholders;
    }

    private static boolean isJava7() {
        return JavaVersion.current().isJava7Compatible();
    }

    private static boolean isJava14() {
        return JavaVersion.current().isCompatibleWith(JavaVersion.VERSION_14);
    }

    public Throwable read(Function<String, Class<?>> classNameTransformer, Function<InputStream, ExceptionReplacingObjectInputStream> objectInputStreamCreator) throws IOException {
        List<Throwable> causes = ExceptionPlaceholder.recreateExceptions(this.causes, classNameTransformer, objectInputStreamCreator);
        List<Throwable> suppressed = ExceptionPlaceholder.recreateExceptions(this.suppressed, classNameTransformer, objectInputStreamCreator);
        if (this.serializedException != null) {
            ExceptionReplacingObjectInputStream ois = objectInputStreamCreator.apply(new ByteArrayInputStream(this.serializedException));
            ois.setObjectTransformer(obj -> {
                if (obj instanceof NestedExceptionPlaceholder) {
                    NestedExceptionPlaceholder placeholder = (NestedExceptionPlaceholder)obj;
                    int index = placeholder.getIndex();
                    switch (placeholder.getKind()) {
                        case cause: {
                            return causes.get(index);
                        }
                        case suppressed: {
                            return suppressed.get(index);
                        }
                    }
                }
                return obj;
            });
            try {
                return (Throwable)ois.readObject();
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Throwable failure) {
                LOGGER.debug("Ignoring failure to de-serialize throwable.", failure);
            }
        }
        try {
            Class<?> clazz = classNameTransformer.apply(this.type);
            if (clazz != null && causes.size() <= 1) {
                Constructor<?> constructor = clazz.getConstructor(String.class);
                Throwable reconstructed = (Throwable)constructor.newInstance(this.message);
                if (!causes.isEmpty()) {
                    reconstructed.initCause(causes.get(0));
                }
                reconstructed.setStackTrace(this.convertStackTrace(this.stackTrace));
                ExceptionPlaceholder.registerSuppressedExceptions(suppressed, reconstructed);
                return reconstructed;
            }
        }
        catch (UncheckedException clazz) {
        }
        catch (NoSuchMethodException clazz) {
        }
        catch (Throwable ignored) {
            LOGGER.debug("Ignoring failure to recreate throwable.", ignored);
        }
        Serializable placeholder = causes.size() <= 1 ? (this.contextual ? new ContextualPlaceholderException(this.type, this.message, this.getMessageExec, this.toString, this.toStringRuntimeExec, causes.isEmpty() ? null : causes.get(0)) : (this.assertionError ? new PlaceholderAssertionError(this.type, this.message, this.getMessageExec, this.toString, this.toStringRuntimeExec, causes.isEmpty() ? null : causes.get(0)) : new PlaceholderException(this.type, this.message, this.getMessageExec, this.toString, this.toStringRuntimeExec, causes.isEmpty() ? null : causes.get(0)))) : new DefaultMultiCauseException(this.message, causes);
        placeholder.setStackTrace(this.convertStackTrace(this.stackTrace));
        ExceptionPlaceholder.registerSuppressedExceptions(suppressed, placeholder);
        return placeholder;
    }

    private static void registerSuppressedExceptions(List<Throwable> suppressed, Throwable reconstructed) {
        if (!suppressed.isEmpty()) {
            for (Throwable throwable : suppressed) {
                reconstructed.addSuppressed(throwable);
            }
        }
    }

    private static List<? extends Throwable> extractCauses(Throwable throwable) {
        Throwable causeTmp;
        if (throwable instanceof MultiCauseException) {
            return ((MultiCauseException)((Object)throwable)).getCauses();
        }
        List<? extends Throwable> causes = ExceptionPlaceholder.tryExtractMultiCauses(throwable);
        if (causes != null) {
            return causes;
        }
        try {
            causeTmp = throwable.getCause();
        }
        catch (Throwable ignored) {
            causeTmp = null;
        }
        return causeTmp == null ? Collections.emptyList() : Collections.singletonList(causeTmp);
    }

    private static Method findCandidateGetCausesMethod(Throwable throwable) {
        Method[] declaredMethods;
        for (Method method : declaredMethods = throwable.getClass().getDeclaredMethods()) {
            Class<?> returnType;
            if (!CANDIDATE_GET_CAUSES.contains(method.getName()) || !Collection.class.isAssignableFrom(returnType = method.getReturnType())) continue;
            return method;
        }
        return null;
    }

    private static List<? extends Throwable> tryExtractMultiCauses(Throwable throwable) {
        Method causesMethod = ExceptionPlaceholder.findCandidateGetCausesMethod(throwable);
        if (causesMethod != null) {
            Collection causes;
            try {
                causes = (Collection)Cast.uncheckedCast(causesMethod.invoke((Object)throwable, new Object[0]));
            }
            catch (IllegalAccessException e) {
                return null;
            }
            catch (InvocationTargetException e) {
                return null;
            }
            if (causes == null || causes.isEmpty()) {
                return null;
            }
            for (Object cause : causes) {
                if (cause instanceof Throwable) continue;
                return null;
            }
            ArrayList<Throwable> result = new ArrayList<Throwable>(causes.size());
            for (Object cause : causes) {
                result.add((Throwable)Cast.uncheckedCast(cause));
            }
            return result;
        }
        return null;
    }

    private static List<Throwable> recreateExceptions(List<ExceptionPlaceholder> exceptions, Function<String, Class<?>> classNameTransformer, Function<InputStream, ExceptionReplacingObjectInputStream> objectInputStreamCreator) throws IOException {
        if (exceptions.isEmpty()) {
            return Collections.emptyList();
        }
        if (exceptions.size() == 1) {
            return Collections.singletonList(exceptions.get(0).read(classNameTransformer, objectInputStreamCreator));
        }
        ArrayList<Throwable> result = new ArrayList<Throwable>();
        for (ExceptionPlaceholder placeholder : exceptions) {
            result.add(placeholder.read(classNameTransformer, objectInputStreamCreator));
        }
        return result;
    }

    private static class Java14NullPointerExceptionUsefulMessageSupport {
        private Java14NullPointerExceptionUsefulMessageSupport() {
        }

        private static Throwable maybeReplaceUsefulNullPointerMessage(Throwable throwable) {
            if (throwable instanceof NullPointerException) {
                StackTraceElement[] stackTrace = throwable.getStackTrace();
                try {
                    throwable = new NullPointerException(throwable.getMessage());
                }
                catch (Exception e) {
                    return throwable;
                }
                throwable.setStackTrace(stackTrace);
            }
            return throwable;
        }
    }
}

