/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jndi.toolkit.url;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;

public class Uri {
    protected String uri;
    protected String scheme;
    protected String host = null;
    protected int port = -1;
    protected boolean hasAuthority;
    protected String path;
    protected String query = null;
    protected String fragment;

    public Uri(String string) throws MalformedURLException {
        this.init(string);
    }

    protected Uri() {
    }

    protected ParseMode parseMode() {
        return ParseMode.COMPAT;
    }

    protected void init(String string) throws MalformedURLException {
        this.uri = string;
        this.parse(string, this.parseMode());
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPath() {
        return this.path;
    }

    public String getQuery() {
        return this.query;
    }

    public String toString() {
        return this.uri;
    }

    private void parse(String string, ParseMode parseMode) throws MalformedURLException {
        switch (parseMode) {
            case STRICT: {
                this.parseStrict(string);
                break;
            }
            case COMPAT: {
                this.parseCompat(string);
                break;
            }
            case LEGACY: {
                this.parseLegacy(string);
            }
        }
    }

    private void parseStrict(String string) throws MalformedURLException {
        try {
            if (!this.isSchemeOnly(string)) {
                URI uRI = new URI(string);
                this.scheme = uRI.getScheme();
                if (this.scheme == null) {
                    throw new MalformedURLException("Invalid URI: " + string);
                }
                String string2 = uRI.getRawAuthority();
                boolean bl = this.hasAuthority = string2 != null;
                if (this.hasAuthority) {
                    String string3;
                    String string4 = uRI.getHost();
                    int n = uRI.getPort();
                    if (string4 != null) {
                        this.host = string4;
                    }
                    if (n != -1) {
                        this.port = n;
                    }
                    if (!(string3 = (string4 == null ? "" : string4) + (n == -1 ? "" : ":" + n)).equals(string2)) {
                        throw new MalformedURLException("unsupported authority: " + string2);
                    }
                }
                this.path = uRI.getRawPath();
                if (uRI.getRawQuery() != null) {
                    this.query = "?" + uRI.getRawQuery();
                }
                if (uRI.getRawFragment() != null) {
                    if (!this.acceptsFragment()) {
                        throw new MalformedURLException("URI fragments not supported: " + string);
                    }
                    this.fragment = "#" + uRI.getRawFragment();
                }
            } else {
                URI uRI;
                String string5 = string.substring(0, string.indexOf(58));
                if (!string5.equals((uRI = new URI(string + "/")).getScheme()) || !this.checkSchemeOnly(string, uRI.getScheme())) {
                    throw this.newInvalidURISchemeException(string);
                }
                this.scheme = string5;
                this.path = "";
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            MalformedURLException malformedURLException = new MalformedURLException(uRISyntaxException.getMessage());
            malformedURLException.initCause(uRISyntaxException);
            throw malformedURLException;
        }
    }

    private void parseCompat(String string) throws MalformedURLException {
        int n;
        int n2 = string.indexOf(58);
        int n3 = string.indexOf(47);
        int n4 = string.indexOf(63);
        int n5 = string.indexOf(35);
        if (n2 < 0 || n3 > 0 && n2 > n3 || n4 > 0 && n2 > n4 || n5 > 0 && n2 > n5) {
            throw new MalformedURLException("Invalid URI: " + string);
        }
        if (n5 > -1 && !this.acceptsFragment()) {
            throw new MalformedURLException("URI fragments not supported: " + string);
        }
        if (n2 == string.length() - 1 && !this.isSchemeOnly(string)) {
            throw this.newInvalidURISchemeException(string);
        }
        this.scheme = string.substring(0, n2);
        this.hasAuthority = string.startsWith("//", ++n2);
        if (n5 > -1 && n4 > n5) {
            n4 = -1;
        }
        int n6 = n4 > -1 ? n4 : (n = n5 > -1 ? n5 : string.length());
        if (this.hasAuthority) {
            int n7 = n2 += 2;
            int n8 = string.indexOf(47, n2);
            if (n8 == -1 || n4 > -1 && n4 < n8) {
                n8 = n4;
            }
            if (n8 == -1 || n5 > -1 && n5 < n8) {
                n8 = n5;
            }
            if (n8 < 0) {
                n8 = string.length();
            }
            if (string.startsWith(":", n2)) {
                this.host = "";
                if (n8 > ++n2) {
                    this.port = Integer.parseInt(string.substring(n2, n8));
                }
            } else {
                try {
                    URI uRI = new URI(string.substring(0, n8) + "/");
                    String string2 = string.substring(n7, n8);
                    this.host = uRI.getHost();
                    this.port = uRI.getPort();
                    String string3 = uRI.getRawPath();
                    String string4 = uRI.getRawQuery();
                    String string5 = uRI.getRawFragment();
                    String string6 = uRI.getRawUserInfo();
                    if (string6 != null) {
                        throw new MalformedURLException("user info not supported in authority: " + string6);
                    }
                    if (!"/".equals(string3)) {
                        throw new MalformedURLException("invalid authority: " + string2);
                    }
                    if (string4 != null) {
                        throw new MalformedURLException("invalid trailing characters in authority: ?" + string4);
                    }
                    if (string5 != null) {
                        throw new MalformedURLException("invalid trailing characters in authority: #" + string5);
                    }
                    String string7 = (this.host == null ? "" : this.host) + (this.port == -1 ? "" : ":" + this.port);
                    if (!string2.equals(string7)) {
                        throw new MalformedURLException("unsupported authority: " + string2);
                    }
                }
                catch (URISyntaxException uRISyntaxException) {
                    MalformedURLException malformedURLException = new MalformedURLException(uRISyntaxException.getMessage());
                    malformedURLException.initCause(uRISyntaxException);
                    throw malformedURLException;
                }
            }
            n2 = n8;
        }
        this.path = string.substring(n2, n);
        if (n4 > -1) {
            this.query = n5 > -1 ? string.substring(n4, n5) : string.substring(n4);
        }
        if (n5 > -1) {
            this.fragment = string.substring(n5);
        }
    }

    protected boolean isSchemeOnly(String string) {
        return false;
    }

    protected boolean checkSchemeOnly(String string, String string2) {
        return string.equals(string2 + ":");
    }

    protected MalformedURLException newInvalidURISchemeException(String string) {
        return new MalformedURLException("Invalid URI scheme: " + string);
    }

    protected boolean acceptsFragment() {
        return this.parseMode() == ParseMode.LEGACY;
    }

    private void parseLegacy(String string) throws MalformedURLException {
        int n;
        int n2 = string.indexOf(58);
        if (n2 < 0) {
            throw new MalformedURLException("Invalid URI: " + string);
        }
        this.scheme = string.substring(0, n2);
        this.hasAuthority = string.startsWith("//", ++n2);
        if (this.hasAuthority) {
            n = string.indexOf(47, n2 += 2);
            if (n < 0) {
                n = string.length();
            }
            if (string.startsWith("[", n2)) {
                int n3 = string.indexOf(93, n2 + 1);
                if (n3 < 0 || n3 > n) {
                    throw new MalformedURLException("Invalid URI: " + string);
                }
                this.host = string.substring(n2, n3 + 1);
                n2 = n3 + 1;
            } else {
                int n4;
                int n5 = string.indexOf(58, n2);
                int n6 = n4 = n5 < 0 || n5 > n ? n : n5;
                if (n2 < n4) {
                    this.host = string.substring(n2, n4);
                }
                n2 = n4;
            }
            if (n2 + 1 < n && string.startsWith(":", n2)) {
                this.port = Integer.parseInt(string.substring(++n2, n));
            }
            n2 = n;
        }
        if ((n = string.indexOf(63, n2)) < 0) {
            this.path = string.substring(n2);
        } else {
            this.path = string.substring(n2, n);
            this.query = string.substring(n);
        }
    }

    public static enum ParseMode {
        STRICT,
        COMPAT,
        LEGACY;

    }
}

