/*
 * Decompiled with CFR 0.152.
 */
package sun.security.ssl;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.Locale;
import javax.crypto.SecretKey;
import javax.net.ssl.SNIHostName;
import sun.misc.HexDumpEncoder;
import sun.security.ssl.Alert;
import sun.security.ssl.ClientHandshakeContext;
import sun.security.ssl.ConnectionContext;
import sun.security.ssl.HandshakeContext;
import sun.security.ssl.HandshakeOutStream;
import sun.security.ssl.HandshakeProducer;
import sun.security.ssl.KrbClientKeyExchangeHelper;
import sun.security.ssl.KrbKeyExchange;
import sun.security.ssl.ProtocolVersion;
import sun.security.ssl.Record;
import sun.security.ssl.SSLConsumer;
import sun.security.ssl.SSLHandshake;
import sun.security.ssl.SSLKeyDerivation;
import sun.security.ssl.SSLKeyExchange;
import sun.security.ssl.SSLLogger;
import sun.security.ssl.SSLPossession;
import sun.security.ssl.SSLTrafficKeyDerivation;
import sun.security.ssl.ServerHandshakeContext;
import sun.security.ssl.Utilities;

final class KrbClientKeyExchange {
    static final SSLConsumer krbHandshakeConsumer = new KrbClientKeyExchangeConsumer();
    static final HandshakeProducer krbHandshakeProducer = new KrbClientKeyExchangeProducer();

    KrbClientKeyExchange() {
    }

    private static final class KrbClientKeyExchangeConsumer
    implements SSLConsumer {
        private KrbClientKeyExchangeConsumer() {
        }

        @Override
        public void consume(ConnectionContext connectionContext, ByteBuffer byteBuffer) throws IOException {
            SSLKeyExchange sSLKeyExchange;
            SSLPossession sSLPossession2;
            ServerHandshakeContext serverHandshakeContext = (ServerHandshakeContext)connectionContext;
            Object object = null;
            for (SSLPossession sSLPossession2 : serverHandshakeContext.handshakePossessions) {
                if (!(sSLPossession2 instanceof KrbKeyExchange.KrbServiceCreds)) continue;
                object = ((KrbKeyExchange.KrbServiceCreds)sSLPossession2).serviceCreds;
                break;
            }
            if (object == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "No Kerberos service credentials for KRB Client Key Exchange");
            }
            KrbClientKeyExchangeMessage krbClientKeyExchangeMessage = new KrbClientKeyExchangeMessage((HandshakeContext)serverHandshakeContext, byteBuffer, object, serverHandshakeContext.conContext.acc);
            sSLPossession2 = KrbKeyExchange.KrbPremasterSecret.decode(serverHandshakeContext.negotiatedProtocol, ProtocolVersion.valueOf(serverHandshakeContext.clientHelloVersion), krbClientKeyExchangeMessage.getPlainPreMasterSecret(), serverHandshakeContext.sslContext.getSecureRandom());
            serverHandshakeContext.handshakeSession.setPeerPrincipal(krbClientKeyExchangeMessage.getPeerPrincipal());
            serverHandshakeContext.handshakeSession.setLocalPrincipal(krbClientKeyExchangeMessage.getLocalPrincipal());
            serverHandshakeContext.handshakeCredentials.add(sSLPossession2);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Consuming KRB5 ClientKeyExchange handshake message", krbClientKeyExchangeMessage);
            }
            if ((sSLKeyExchange = SSLKeyExchange.valueOf(serverHandshakeContext.negotiatedCipherSuite.keyExchange, serverHandshakeContext.negotiatedProtocol)) == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            SSLKeyDerivation sSLKeyDerivation = sSLKeyExchange.createKeyDerivation(serverHandshakeContext);
            SecretKey secretKey = sSLKeyDerivation.deriveKey("MasterSecret", null);
            serverHandshakeContext.handshakeSession.setMasterSecret(secretKey);
            SSLTrafficKeyDerivation sSLTrafficKeyDerivation = SSLTrafficKeyDerivation.valueOf(serverHandshakeContext.negotiatedProtocol);
            if (sSLTrafficKeyDerivation == null) {
                throw serverHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)serverHandshakeContext.negotiatedProtocol));
            }
            serverHandshakeContext.handshakeKeyDerivation = sSLTrafficKeyDerivation.createKeyDerivation(serverHandshakeContext, secretKey);
        }
    }

    private static final class KrbClientKeyExchangeProducer
    implements HandshakeProducer {
        private KrbClientKeyExchangeProducer() {
        }

        @Override
        public byte[] produce(ConnectionContext connectionContext, SSLHandshake.HandshakeMessage handshakeMessage) throws IOException {
            Object object;
            ClientHandshakeContext clientHandshakeContext = (ClientHandshakeContext)connectionContext;
            KrbClientKeyExchangeMessage krbClientKeyExchangeMessage = null;
            String string = null;
            if (clientHandshakeContext.negotiatedServerName != null) {
                if (clientHandshakeContext.negotiatedServerName.getType() == 0) {
                    object = null;
                    if (clientHandshakeContext.negotiatedServerName instanceof SNIHostName) {
                        object = (SNIHostName)clientHandshakeContext.negotiatedServerName;
                    } else {
                        try {
                            object = new SNIHostName(clientHandshakeContext.negotiatedServerName.getEncoded());
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                    if (object != null) {
                        string = ((SNIHostName)object).getAsciiName();
                    }
                }
            } else {
                string = clientHandshakeContext.handshakeSession.getPeerHost();
            }
            try {
                object = KrbKeyExchange.KrbPremasterSecret.createPremasterSecret(clientHandshakeContext.negotiatedProtocol, clientHandshakeContext.sslContext.getSecureRandom());
                krbClientKeyExchangeMessage = new KrbClientKeyExchangeMessage((HandshakeContext)clientHandshakeContext, ((KrbKeyExchange.KrbPremasterSecret)object).preMaster, string, clientHandshakeContext.conContext.acc);
                clientHandshakeContext.handshakePossessions.add(object);
            }
            catch (IOException iOException) {
                if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                    SSLLogger.fine("Error generating KRB premaster secret. Hostname: " + string + " - Negotiated server name: " + clientHandshakeContext.negotiatedServerName, new Object[0]);
                }
                throw clientHandshakeContext.conContext.fatal(Alert.ILLEGAL_PARAMETER, "Cannot generate KRB premaster secret", iOException);
            }
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("Produced KRB5 ClientKeyExchange handshake message", krbClientKeyExchangeMessage);
            }
            clientHandshakeContext.handshakeSession.setPeerPrincipal(krbClientKeyExchangeMessage.getPeerPrincipal());
            clientHandshakeContext.handshakeSession.setLocalPrincipal(krbClientKeyExchangeMessage.getLocalPrincipal());
            krbClientKeyExchangeMessage.write(clientHandshakeContext.handshakeOutput);
            clientHandshakeContext.handshakeOutput.flush();
            object = SSLKeyExchange.valueOf(clientHandshakeContext.negotiatedCipherSuite.keyExchange, clientHandshakeContext.negotiatedProtocol);
            if (object == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key exchange type");
            }
            SSLKeyDerivation sSLKeyDerivation = ((SSLKeyExchange)object).createKeyDerivation(clientHandshakeContext);
            SecretKey secretKey = sSLKeyDerivation.deriveKey("MasterSecret", null);
            clientHandshakeContext.handshakeSession.setMasterSecret(secretKey);
            SSLTrafficKeyDerivation sSLTrafficKeyDerivation = SSLTrafficKeyDerivation.valueOf(clientHandshakeContext.negotiatedProtocol);
            if (sSLTrafficKeyDerivation == null) {
                throw clientHandshakeContext.conContext.fatal(Alert.INTERNAL_ERROR, "Not supported key derivation: " + (Object)((Object)clientHandshakeContext.negotiatedProtocol));
            }
            clientHandshakeContext.handshakeKeyDerivation = sSLTrafficKeyDerivation.createKeyDerivation(clientHandshakeContext, secretKey);
            return null;
        }
    }

    private static final class KrbClientKeyExchangeMessage
    extends SSLHandshake.HandshakeMessage {
        private static final String KRB5_CLASS_NAME = "sun.security.ssl.krb5.KrbClientKeyExchangeHelperImpl";
        private static final Class<?> krb5Class = (Class)AccessController.doPrivileged(new PrivilegedAction<Class<?>>(){

            @Override
            public Class<?> run() {
                try {
                    return Class.forName(KrbClientKeyExchangeMessage.KRB5_CLASS_NAME, true, null);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    return null;
                }
            }
        });
        private final KrbClientKeyExchangeHelper krb5Helper = KrbClientKeyExchangeMessage.newKrb5Instance();

        private static KrbClientKeyExchangeHelper newKrb5Instance() {
            if (krb5Class != null) {
                try {
                    return (KrbClientKeyExchangeHelper)krb5Class.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                    throw new AssertionError((Object)reflectiveOperationException);
                }
            }
            return null;
        }

        private KrbClientKeyExchangeMessage(HandshakeContext handshakeContext) {
            super(handshakeContext);
            if (this.krb5Helper == null) {
                throw new IllegalStateException("Kerberos is unavailable");
            }
        }

        KrbClientKeyExchangeMessage(HandshakeContext handshakeContext, byte[] byArray, String string, AccessControlContext accessControlContext) throws IOException {
            this(handshakeContext);
            this.krb5Helper.init(byArray, string, accessControlContext);
        }

        KrbClientKeyExchangeMessage(HandshakeContext handshakeContext, ByteBuffer byteBuffer, Object object, AccessControlContext accessControlContext) throws IOException {
            this(handshakeContext);
            byte[] byArray = Record.getBytes16(byteBuffer);
            if (SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("encoded Kerberos service ticket", new Object[]{byArray});
            }
            Record.getBytes16(byteBuffer);
            byte[] byArray2 = Record.getBytes16(byteBuffer);
            if (byArray2 != null && SSLLogger.isOn && SSLLogger.isOn("ssl,handshake")) {
                SSLLogger.fine("encrypted Kerberos pre-master secret", new Object[]{byArray2});
            }
            this.krb5Helper.init(byArray, byArray2, object, accessControlContext);
        }

        @Override
        SSLHandshake handshakeType() {
            return SSLHandshake.CLIENT_KEY_EXCHANGE;
        }

        @Override
        int messageLength() {
            return 6 + this.krb5Helper.getEncodedTicket().length + this.krb5Helper.getEncryptedPreMasterSecret().length;
        }

        @Override
        void send(HandshakeOutStream handshakeOutStream) throws IOException {
            handshakeOutStream.putBytes16(this.krb5Helper.getEncodedTicket());
            handshakeOutStream.putBytes16(null);
            handshakeOutStream.putBytes16(this.krb5Helper.getEncryptedPreMasterSecret());
        }

        byte[] getPlainPreMasterSecret() {
            return this.krb5Helper.getPlainPreMasterSecret();
        }

        Principal getPeerPrincipal() {
            return this.krb5Helper.getPeerPrincipal();
        }

        Principal getLocalPrincipal() {
            return this.krb5Helper.getLocalPrincipal();
        }

        public String toString() {
            MessageFormat messageFormat = new MessageFormat("\"KRB5 ClientKeyExchange\": '{'\n  \"ticket\": '{'\n{0}\n  '}'\n  \"pre-master\": '{'\n    \"plain\": '{'\n{1}\n    '}'\n    \"encrypted\": '{'\n{2}\n    '}'\n  '}'\n'}'", Locale.ENGLISH);
            HexDumpEncoder hexDumpEncoder = new HexDumpEncoder();
            Object[] objectArray = new Object[]{Utilities.indent(hexDumpEncoder.encodeBuffer(this.krb5Helper.getEncodedTicket()), "  "), Utilities.indent(hexDumpEncoder.encodeBuffer(this.krb5Helper.getPlainPreMasterSecret()), "      "), Utilities.indent(hexDumpEncoder.encodeBuffer(this.krb5Helper.getEncryptedPreMasterSecret()), "      ")};
            return messageFormat.format(objectArray);
        }
    }
}

