/*
 * Decompiled with CFR 0.152.
 */
package jdk.test.lib.hexdump;

import java.io.CharArrayWriter;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UTFDataFormatException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.BiConsumer;
import jdk.test.lib.hexdump.HexPrinter;

public class ObjectStreamPrinter
implements HexPrinter.Formatter {
    private int nextHandle = 0;
    private List<Handle> labels = new ArrayList<Handle>();
    static final Handle EMPTY_HANDLE = new Handle("");
    static final Handle INVALID_HANDLE = new Handle("invalid handle");
    static final Handle NULL_HANDLE = new Handle("null");
    static final Handle RESET_HANDLE = new Handle("reset");
    static final Handle EXCEPTION_HANDLE = new Handle("exception");
    static final Handle END_HANDLE = new Handle("end");
    static final Handle BLOCK_HANDLE = new Handle("block");
    static final Handle BLOCKLONG_HANDLE = new Handle("blocklong");
    static final Handle ARRAY_HANDLE = new Handle("array");
    static final Handle ENUM_HANDLE = new Handle("enum");
    static final Handle OBJ_HANDLE = new Handle("obj");
    static final Handle CLASS_HANDLE = new Handle("class");
    static final Handle HEADER_HANDLE = new Handle("header");

    public static ObjectStreamPrinter formatter() {
        return new ObjectStreamPrinter();
    }

    private ObjectStreamPrinter() {
    }

    public String annotate(DataInputStream in) throws IOException {
        StringBuilder sb = new StringBuilder();
        try {
            this.annotate(in, sb);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return sb.toString();
    }

    @Override
    public void annotate(DataInputStream in, Appendable out) throws IOException {
        this.annotate(in, out, 0);
    }

    public void annotate(DataInputStream in, Appendable out, int indent) throws IOException {
        if (this.formatObject(in, out, indent).equals(HEADER_HANDLE)) {
            this.formatObject(in, out, indent);
        }
    }

    Handle formatObject(DataInputStream in, Appendable infoOut, int indent) throws IOException {
        int tc = in.read();
        if ((tc < 112 || tc > 126) && tc != 172) {
            if (tc < 0) {
                throw new EOFException();
            }
            infoOut.append("raw: [ " + tc + " ");
            while ((tc = in.read()) >= 0 && (tc < 112 || tc > 126)) {
                infoOut.append(tc + " ");
            }
            infoOut.append("] ");
            if (tc < 0) {
                throw new EOFException();
            }
        }
        switch (tc) {
            case 112: {
                return this.formatTC_NULL(in, infoOut);
            }
            case 113: {
                return this.formatTC_REFERENCE(in, infoOut);
            }
            case 114: {
                return this.formatTC_CLASSDESC(in, infoOut, indent);
            }
            case 115: {
                return this.formatTC_OBJECT(in, infoOut, indent);
            }
            case 116: {
                return this.formatTC_STRING(in, infoOut, indent);
            }
            case 117: {
                return this.formatTC_ARRAY(in, infoOut, indent);
            }
            case 118: {
                return this.formatTC_CLASS(in, infoOut, indent);
            }
            case 119: {
                return this.formatTC_BLOCKDATA(in, infoOut);
            }
            case 120: {
                return this.formatTC_ENDBLOCKDATA(in, infoOut);
            }
            case 121: {
                return this.formatTC_RESET(in, infoOut);
            }
            case 122: {
                return this.formatTC_BLOCKDATALONG(in, infoOut);
            }
            case 123: {
                return this.formatTC_EXCEPTION(in, infoOut);
            }
            case 124: {
                return this.formatTC_LONGSTRING(in, infoOut);
            }
            case 125: {
                return this.formatTC_PROXYCLASSDESC(in, infoOut, indent);
            }
            case 126: {
                return this.formatTC_ENUM(in, infoOut, indent);
            }
            case 172: {
                return this.formatSTREAM_MAGIC(in, infoOut, indent);
            }
        }
        infoOut.append("data: " + tc + " ");
        return EMPTY_HANDLE;
    }

    private Handle formatTC_STRING(DataInputStream in, Appendable infoOut, int indent) throws IOException {
        String s = in.readUTF();
        Handle handle = new Handle(s);
        this.setLabel(this.nextHandle, handle);
        infoOut.append(String.format("STRING #%d \"%s\" ", this.nextHandle++, s));
        return handle;
    }

    private Handle formatTC_LONGSTRING(DataInputStream in, Appendable infoOut) throws IOException {
        long utflen = in.readLong();
        String s = "longstring " + this.nextHandle + ",len: " + utflen;
        Handle handle = new Handle(s);
        this.setLabel(this.nextHandle, handle);
        infoOut.append(String.format("LONGSTRING #%d \"", this.nextHandle++));
        long count = 0L;
        while (count < utflen) {
            char c = (char)(in.readUnsignedByte() & 0xFF);
            switch (c >> 4) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    ++count;
                    break;
                }
                case 12: 
                case 13: {
                    if ((count += 2L) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    int char2 = in.readUnsignedByte() & 0xFF;
                    if ((char2 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + count);
                    }
                    c = (char)((c & 0x1F) << 6 | char2 & 0x3F);
                    break;
                }
                case 14: {
                    if ((count += 3L) > utflen) {
                        throw new UTFDataFormatException("malformed input: partial character at end");
                    }
                    int char2 = in.readUnsignedByte() & 0xFF;
                    int char3 = in.readUnsignedByte() & 0xFF;
                    if ((char2 & 0xC0) != 128 || (char3 & 0xC0) != 128) {
                        throw new UTFDataFormatException("malformed input around byte " + (count - 1L));
                    }
                    c = (char)((c & 0xF) << 12 | (char2 & 0x3F) << 6 | (char3 & 0x3F) << 0);
                    break;
                }
                default: {
                    throw new UTFDataFormatException("malformed input around byte " + count);
                }
            }
            infoOut.append(c);
        }
        infoOut.append("\" ");
        return handle;
    }

    private Handle formatTC_NULL(DataInputStream in, Appendable infoOut) throws IOException {
        infoOut.append("NULL; ");
        return NULL_HANDLE;
    }

    private Handle formatTC_REFERENCE(DataInputStream in, Appendable infoOut) throws IOException {
        int offset = in.readInt();
        int h = offset - 0x7E0000;
        Handle handle = this.getHandle(h);
        infoOut.append("REF #" + h + " " + this.getLabel(h) + " ");
        return handle;
    }

    private Handle formatTC_CLASSDESC(DataInputStream in, Appendable infoOut, int indent) throws IOException {
        char[] buf = new char[1];
        String name = in.readUTF();
        ClassHandle handle = new ClassHandle(name);
        this.setLabel(this.nextHandle, handle);
        infoOut.append(String.format("CLASSDESC #%d %s", this.nextHandle++, name));
        this.newlineIndent(infoOut, indent + 2);
        long svid = in.readLong();
        infoOut.append(String.format("svid: %dL", svid));
        this.newlineIndent(infoOut, indent + 2);
        int flags = in.readUnsignedByte();
        handle.setFlags(flags);
        StringJoiner flagsJoiner = new StringJoiner(", ");
        if (handle.hasFlag(1)) {
            flagsJoiner.add("WRITE_OBJECT");
        }
        if (handle.hasFlag(2)) {
            flagsJoiner.add("SERIALIZABLE");
        }
        if (handle.hasFlag(4)) {
            flagsJoiner.add("EXTERNALIZABLE");
        }
        if (handle.hasFlag(8)) {
            flagsJoiner.add("BLOCK_DATA");
        }
        if (handle.hasFlag(16)) {
            flagsJoiner.add("ENUM");
        }
        infoOut.append(String.format("flags: %s", flagsJoiner.toString()));
        this.newlineIndent(infoOut, indent + 2);
        int numFields = in.readShort();
        infoOut.append(String.format("%d field(s) {", numFields));
        CharArrayWriter caw = new CharArrayWriter();
        for (int i = 0; i < numFields; ++i) {
            String typeName;
            this.newlineIndent(infoOut, indent + 4);
            buf[0] = (char)in.readByte();
            String fname = in.readUTF();
            caw.write(buf[0]);
            caw.write(32);
            caw.write(fname);
            caw.write(32);
            if (buf[0] == 'L' || buf[0] == '[') {
                typeName = this.formatObject(in, caw, 0).toString();
            } else {
                typeName = new String(buf);
                caw.write(this.mapClassName(typeName).toString());
            }
            caw.write("; ");
            infoOut.append(caw.toString());
            caw.reset();
            handle.addField(fname, typeName);
        }
        if (numFields > 0) {
            this.newlineIndent(infoOut, indent + 2);
        }
        infoOut.append("} ");
        this.skipCustomData(in, infoOut, indent);
        this.newlineIndent(infoOut, indent + 2);
        infoOut.append("Super: ");
        Handle sup = this.formatObject(in, infoOut, indent);
        if (sup instanceof ClassHandle) {
            handle.superClass((ClassHandle)sup);
        }
        return handle;
    }

    private Appendable newlineIndent(Appendable infoOut, int indent) throws IOException {
        return infoOut.append(System.lineSeparator()).append(" ".repeat(indent));
    }

    private void skipCustomData(DataInputStream in, Appendable infoOut, int indent) throws IOException {
        while (!this.formatObject(in, infoOut, indent).equals(END_HANDLE)) {
        }
    }

    private Handle formatTC_PROXYCLASSDESC(DataInputStream in, Appendable infoOut, int indent) throws IOException {
        int numIfaces = in.readInt();
        this.setLabel(this.nextHandle, CLASS_HANDLE);
        infoOut.append(String.format("PROXYCLASSDESC #%d %d ", this.nextHandle++, numIfaces));
        if (numIfaces > 0) {
            CharArrayWriter caw = new CharArrayWriter();
            PrintWriter pw = new PrintWriter(caw);
            pw.append("{");
            String delim = "";
            for (int i = 0; i < numIfaces; ++i) {
                caw.write(delim);
                caw.write(in.readUTF());
                delim = ", ";
            }
            pw.write("} ");
            infoOut.append(caw.toString());
        }
        this.skipCustomData(in, infoOut, indent);
        this.newlineIndent(infoOut, indent + 2);
        infoOut.append("Super: ");
        this.formatObject(in, infoOut, indent);
        return CLASS_HANDLE;
    }

    private Handle formatTC_CLASS(DataInputStream in, Appendable infoOut, int indent) throws IOException {
        Handle label = new Handle("class#" + this.nextHandle);
        this.setLabel(this.nextHandle, label);
        infoOut.append(String.format("CLASS #%d; ", this.nextHandle++));
        this.formatObject(in, infoOut, indent);
        return label;
    }

    private Handle formatTC_OBJECT(DataInputStream in, Appendable infoOut, int indent) throws IOException {
        infoOut.append("READ ");
        Handle type = this.formatObject(in, infoOut, indent);
        this.setLabel(this.nextHandle, OBJ_HANDLE);
        this.newlineIndent(infoOut, indent);
        infoOut.append(String.format("OBJ #%d %s ", this.nextHandle++, type.label()));
        if (type instanceof ClassHandle) {
            ClassHandle[] types;
            for (ClassHandle ch : types = ((ClassHandle)type).allClasses()) {
                Handle skipped;
                ch.forEachField((n, v) -> {
                    try {
                        this.newlineIndent(infoOut, indent + 2).append((CharSequence)n).append(":");
                        Class<?> cl = this.mapClassName(v.substring(0, 1));
                        if (cl != Object.class) {
                            HexPrinter.Formatter f = HexPrinter.getFormatter(cl, "%s ");
                            f.annotate(in, infoOut);
                        } else {
                            this.formatObject(in, infoOut, indent + 2);
                        }
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                });
                if (!ch.hasFlag(1)) continue;
                this.newlineIndent(infoOut, indent + 2);
                infoOut.append("CustomData: ");
                do {
                    this.newlineIndent(infoOut, indent + 4);
                } while (!(skipped = this.formatObject(in, infoOut, indent + 4)).equals(END_HANDLE));
            }
        }
        return OBJ_HANDLE;
    }

    private Handle formatTC_ENUM(DataInputStream in, Appendable infoOut, int indent) throws IOException {
        this.setLabel(this.nextHandle, ENUM_HANDLE);
        infoOut.append(String.format("READ ", new Object[0]));
        Handle enumType = this.formatObject(in, infoOut, indent);
        Handle h = this.formatObject(in, infoOut, indent + 2);
        this.setLabel(this.nextHandle, h);
        this.newlineIndent(infoOut, indent);
        infoOut.append(String.format("ENUM #%d %s.%s ", this.nextHandle++, enumType.label(), h.label()));
        return ENUM_HANDLE;
    }

    private Handle formatTC_ARRAY(DataInputStream in, Appendable infoOut, int indent) throws IOException {
        infoOut.append("READ ");
        Handle type = this.formatObject(in, infoOut, indent);
        this.newlineIndent(infoOut, indent);
        this.setLabel(this.nextHandle, ARRAY_HANDLE);
        int nelements = in.readInt();
        infoOut.append(String.format("ARRAY #%d ", this.nextHandle++));
        infoOut.append(String.format("%d", nelements));
        if (type.toString().charAt(0) == '[') {
            infoOut.append("[");
            this.formatArray(in, infoOut, nelements, type.toString().charAt(1), indent + 2);
            infoOut.append("] ");
        }
        return ARRAY_HANDLE;
    }

    private Handle formatTC_BLOCKDATA(DataInputStream in, Appendable infoOut) throws IOException {
        int l = in.readUnsignedByte();
        StringBuilder sb = new StringBuilder(32 + l + 2);
        sb.append("BLOCKDATA " + l + "[ ");
        for (int i = 0; i < l; ++i) {
            int v = in.readUnsignedByte();
            sb.append(this.toPrintable((char)v));
        }
        sb.append("]; ");
        infoOut.append(sb.toString());
        return BLOCK_HANDLE;
    }

    private Handle formatTC_BLOCKDATALONG(DataInputStream in, Appendable infoOut) throws IOException {
        int l = in.readInt();
        StringBuilder sb = new StringBuilder(32 + l + 2);
        sb.append("BLOCKDATALONG: " + l + " [ ");
        for (int i = 0; i < l; ++i) {
            int v = in.readUnsignedByte();
            sb.append(String.format("%02x ", v));
        }
        sb.append("]; ");
        infoOut.append(sb.toString());
        return BLOCKLONG_HANDLE;
    }

    private Handle formatTC_ENDBLOCKDATA(DataInputStream in, Appendable infoOut) throws IOException {
        infoOut.append("ENDBLOCK; ");
        return END_HANDLE;
    }

    private Handle formatTC_EXCEPTION(DataInputStream in, Appendable infoOut) throws IOException {
        infoOut.append("EXCEPTION; ");
        return EXCEPTION_HANDLE;
    }

    private Handle formatTC_RESET(DataInputStream in, Appendable infoOut) throws IOException {
        this.nextHandle = 0;
        infoOut.append("RESET; ");
        return RESET_HANDLE;
    }

    private Handle formatSTREAM_MAGIC(DataInputStream in, Appendable out, int indent) throws IOException {
        int high = 172;
        String prefix = " ".repeat(indent);
        int low = in.read();
        if (low != 237 || high != 172) {
            out.append(prefix).append("data: " + high + ", " + low).append(System.lineSeparator());
            if (low < 0) {
                throw new EOFException();
            }
            throw new IOException("malformed stream header");
        }
        int s1 = in.readUnsignedShort();
        out.append(" ".repeat(indent));
        out.append(String.format("ObjectStream Version: %d", s1));
        this.newlineIndent(out, indent);
        return HEADER_HANDLE;
    }

    private void setLabel(int handle, String label) {
        this.setLabel(handle, new Handle(label));
    }

    private void setLabel(int handle, Handle label) {
        while (this.labels.size() <= handle) {
            this.labels.add(label);
        }
        this.labels.set(handle, label);
    }

    private String getLabel(int handle) {
        return this.getHandle(handle).label();
    }

    private Handle getHandle(int handle) {
        return handle < 0 || handle >= this.labels.size() ? INVALID_HANDLE : this.labels.get(handle);
    }

    private Class<?> mapClassName(String name) {
        switch (name.substring(0, 1)) {
            case "I": {
                return Integer.TYPE;
            }
            case "J": {
                return Long.TYPE;
            }
            case "Z": {
                return Boolean.TYPE;
            }
            case "S": {
                return Short.TYPE;
            }
            case "C": {
                return Character.TYPE;
            }
            case "F": {
                return Float.TYPE;
            }
            case "D": {
                return Double.TYPE;
            }
            case "B": {
                return Byte.TYPE;
            }
            case "L": 
            case "[": {
                return Object.class;
            }
        }
        throw new RuntimeException("unknown class char: " + name);
    }

    private void formatArray(DataInputStream in, Appendable infoOut, int count, char type, int indent) throws IOException {
        switch (type) {
            case 'I': {
                while (count-- > 0) {
                    int v = in.readInt();
                    infoOut.append(Integer.toString(v));
                    if (count <= 0) continue;
                    infoOut.append(' ');
                }
                break;
            }
            case 'J': {
                while (count-- > 0) {
                    long v = in.readLong();
                    infoOut.append(Long.toString(v));
                    if (count <= 0) continue;
                    infoOut.append(' ');
                }
                break;
            }
            case 'C': {
                while (count-- > 0) {
                    int v = in.readUnsignedShort();
                    infoOut.append((char)v);
                    if (count <= 0) continue;
                    infoOut.append(' ');
                }
                break;
            }
            case 'S': {
                while (count-- > 0) {
                    int v = in.readUnsignedShort();
                    infoOut.append(Integer.toString(v));
                    if (count <= 0) continue;
                    infoOut.append(' ');
                }
                break;
            }
            case 'F': {
                while (count-- > 0) {
                    float v = in.readFloat();
                    infoOut.append(Float.toString(v));
                    if (count <= 0) continue;
                    infoOut.append(' ');
                }
                break;
            }
            case 'D': {
                while (count-- > 0) {
                    double v = in.readDouble();
                    infoOut.append(Double.toString(v));
                    if (count <= 0) continue;
                    infoOut.append(' ');
                }
                break;
            }
            case 'Z': {
                while (count-- > 0) {
                    boolean v = in.readBoolean();
                    infoOut.append(v ? "true" : "false");
                    if (count <= 0) continue;
                    infoOut.append(' ');
                }
                break;
            }
            case 'L': {
                while (count-- > 0) {
                    this.formatObject(in, infoOut, indent + 2);
                    if (count <= 0) continue;
                    this.newlineIndent(infoOut, indent);
                }
                break;
            }
            default: {
                while (count-- > 0) {
                    int v = in.readUnsignedByte();
                    infoOut.append(this.toPrintable((char)v));
                }
                break block0;
            }
        }
    }

    private char toPrintable(char ch) {
        if (ch >= 'a' && ch <= 'z' || ch >= 'A' && ch <= 'Z' || ch >= '0' && ch <= '9') {
            return ch;
        }
        switch (ch) {
            case ' ': 
            case '\'': 
            case '(': 
            case ')': 
            case '+': 
            case ',': 
            case '-': 
            case '.': 
            case '/': 
            case ':': 
            case '=': 
            case '?': {
                return ch;
            }
        }
        return '.';
    }

    public static void main(String[] args) {
        if (args.length < 1) {
            System.out.println("Usage:  <object stream files>");
            return;
        }
        ObjectStreamPrinter fmt = ObjectStreamPrinter.formatter();
        for (String file : args) {
            System.out.printf("%s%n", file);
            try (InputStream is = Files.newInputStream(Path.of(file, new String[0]), new OpenOption[0]);){
                DataInputStream dis = new DataInputStream(is);
                HexPrinter p = HexPrinter.simple().dest(System.out).formatter(ObjectStreamPrinter.formatter(), "; ", 100);
                p.format(dis);
            }
            catch (EOFException eof) {
                System.out.println();
            }
            catch (IOException ioe) {
                System.out.printf("%s: %s%n", file, ioe);
            }
        }
    }

    static class Handle {
        private final String label;

        Handle(String label) {
            this.label = label;
        }

        String label() {
            return this.label;
        }

        public String toString() {
            return this.label;
        }
    }

    static class ClassHandle
    extends Handle {
        private final Map<String, String> fields = new LinkedHashMap<String, String>();
        private int flags;
        private ClassHandle[] allClasses = new ClassHandle[]{this};

        ClassHandle(String label) {
            super(label);
        }

        void addField(String name, String type) {
            this.fields.put(name, type);
        }

        void superClass(ClassHandle superClass) {
            ClassHandle[] types = superClass.allClasses();
            types = Arrays.copyOf(types, types.length + 1);
            types[types.length - 1] = this;
            this.allClasses = types;
        }

        void setFlags(int flags) {
            this.flags = flags;
        }

        boolean hasFlag(int flagBits) {
            return (this.flags & flagBits) != 0;
        }

        void forEachField(BiConsumer<String, String> doit) {
            this.fields.forEach(doit);
        }

        ClassHandle[] allClasses() {
            return this.allClasses;
        }

        @Override
        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(super.toString()).append(": ");
            this.fields.forEach((k, v) -> sb.append((String)k).append('=').append((String)v).append(", ").append((String)(this.allClasses == null ? "" : "; super: " + this.allClasses[this.allClasses.length - 1].label())));
            return sb.toString();
        }
    }
}

