/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.dom.parser.cpp.semantics;

import org.eclipse.cdt.core.dom.ast.IASTExpression;
import org.eclipse.cdt.core.dom.ast.IASTNode;
import org.eclipse.cdt.core.dom.ast.IBinding;
import org.eclipse.cdt.core.dom.ast.IType;
import org.eclipse.cdt.core.dom.ast.IValue;
import org.eclipse.cdt.core.dom.ast.cpp.ICPPTemplateParameterMap;
import org.eclipse.cdt.core.parser.util.ArrayUtil;
import org.eclipse.cdt.internal.core.dom.parser.ITypeMarshalBuffer;
import org.eclipse.cdt.internal.core.dom.parser.IntegralValue;
import org.eclipse.cdt.internal.core.dom.parser.cpp.CPPBasicType;
import org.eclipse.cdt.internal.core.dom.parser.cpp.ICPPEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.InstantiationContext;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.ActivationRecord;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPDependentEvaluation;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.CPPTemplates;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalBinary;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalComma;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.EvalFixed;
import org.eclipse.cdt.internal.core.dom.parser.cpp.semantics.TypeOfDependentExpression;
import org.eclipse.core.runtime.CoreException;

public class EvalFoldExpression
extends CPPDependentEvaluation {
    private static final EvalFixed EVAL_TRUE = new EvalFixed(CPPBasicType.BOOLEAN, IASTExpression.ValueCategory.PRVALUE, IntegralValue.create(true));
    private static final EvalFixed EVAL_FALSE = new EvalFixed(CPPBasicType.BOOLEAN, IASTExpression.ValueCategory.PRVALUE, IntegralValue.create(false));
    private final int fOperator;
    private final boolean fIsComma;
    private final boolean fIsLeftFold;
    private ICPPEvaluation[] fPackEvals;
    private ICPPEvaluation fInitEval;
    private IType fType;
    private boolean fCheckedIsConstantExpression;
    private boolean fIsConstantExpression;
    private ICPPEvaluation fEvaluation;

    public EvalFoldExpression(int operator, boolean isComma, boolean isLeftFold, ICPPEvaluation[] packEvals, ICPPEvaluation initEval, IASTNode pointOfDefinition) {
        this(operator, isComma, isLeftFold, packEvals, initEval, EvalFoldExpression.findEnclosingTemplate(pointOfDefinition));
    }

    public EvalFoldExpression(int operator, boolean isComma, boolean isLeftFold, ICPPEvaluation[] packEvals, ICPPEvaluation initEval, IBinding templateDefinition) {
        super(templateDefinition);
        this.fOperator = operator;
        this.fIsComma = isComma;
        this.fIsLeftFold = isLeftFold;
        this.fPackEvals = packEvals;
        this.fInitEval = initEval;
    }

    public int getOperator() {
        return this.fOperator;
    }

    public boolean getIsComma() {
        return this.fIsComma;
    }

    public boolean getIsLeftFold() {
        return this.fIsLeftFold;
    }

    public ICPPEvaluation[] getExpansionPatterns() {
        return this.fPackEvals;
    }

    public ICPPEvaluation getInitExpression() {
        return this.fInitEval;
    }

    @Override
    public boolean isInitializerList() {
        return false;
    }

    @Override
    public boolean isFunctionSet() {
        return false;
    }

    @Override
    public boolean isTypeDependent() {
        return EvalFoldExpression.containsDependentType(this.fPackEvals) || this.fInitEval != null && this.fInitEval.isTypeDependent();
    }

    @Override
    public boolean isValueDependent() {
        return EvalFoldExpression.containsDependentValue(this.fPackEvals) || this.fInitEval != null && this.fInitEval.isValueDependent();
    }

    @Override
    public boolean isConstantExpression() {
        if (!this.fCheckedIsConstantExpression) {
            this.fCheckedIsConstantExpression = true;
            this.fIsConstantExpression = this.computeIsConstantExpression();
        }
        return this.fIsConstantExpression;
    }

    @Override
    public boolean isEquivalentTo(ICPPEvaluation other) {
        if (!(other instanceof EvalFoldExpression)) {
            return false;
        }
        EvalFoldExpression o = (EvalFoldExpression)other;
        return this.fOperator == o.fOperator && this.fIsComma == o.fIsComma && this.fIsLeftFold == o.fIsLeftFold && this.fPackEvals == o.fPackEvals && (this.fInitEval == null ? o.fInitEval == null : this.fInitEval.isEquivalentTo(o.fInitEval));
    }

    private boolean computeIsConstantExpression() {
        return EvalFoldExpression.areAllConstantExpressions(this.fPackEvals) && (this.fInitEval == null || this.fInitEval.isConstantExpression());
    }

    @Override
    public IType getType() {
        if (this.fType == null) {
            this.fType = this.isTypeDependent() || this.isValueDependent() ? new TypeOfDependentExpression(this) : this.computeEvaluation().getType();
        }
        return this.fType;
    }

    @Override
    public IValue getValue() {
        ICPPEvaluation evaluation = this.computeEvaluation();
        return evaluation.getValue();
    }

    private ICPPEvaluation computeEvaluation() {
        if (this.fEvaluation == null) {
            if (this.fInitEval == null && this.fPackEvals.length == 0) {
                this.fEvaluation = this.fIsComma ? EvalFixed.INCOMPLETE : (this.fOperator == 15 ? EVAL_TRUE : (this.fOperator == 16 ? EVAL_FALSE : EvalFixed.INCOMPLETE));
            } else if (this.fIsComma) {
                ICPPEvaluation[] evals;
                int offset = 0;
                if (this.fInitEval != null) {
                    evals = new ICPPEvaluation[this.fPackEvals.length + 1];
                    if (this.fIsLeftFold) {
                        evals[0] = this.fInitEval;
                        offset = 1;
                    } else {
                        evals[this.fPackEvals.length] = this.fInitEval;
                        offset = 0;
                    }
                } else {
                    evals = new ICPPEvaluation[this.fPackEvals.length];
                    offset = 0;
                }
                ICPPEvaluation[] iCPPEvaluationArray = this.fPackEvals;
                int n = this.fPackEvals.length;
                int n2 = 0;
                while (n2 < n) {
                    ICPPEvaluation packElement = iCPPEvaluationArray[n2];
                    evals[offset++] = packElement;
                    ++n2;
                }
                this.fEvaluation = new EvalComma(evals, this.getTemplateDefinition());
            } else {
                ICPPEvaluation folded = this.fInitEval;
                ICPPEvaluation[] iCPPEvaluationArray = this.fPackEvals;
                int n = this.fPackEvals.length;
                int n3 = 0;
                while (n3 < n) {
                    ICPPEvaluation packElement = iCPPEvaluationArray[n3];
                    folded = folded == null ? packElement : (this.fIsLeftFold ? new EvalBinary(this.fOperator, folded, packElement, this.getTemplateDefinition()) : new EvalBinary(this.fOperator, packElement, folded, this.getTemplateDefinition()));
                    ++n3;
                }
                this.fEvaluation = folded;
            }
        }
        return this.fEvaluation;
    }

    @Override
    public IASTExpression.ValueCategory getValueCategory() {
        return IASTExpression.ValueCategory.PRVALUE;
    }

    @Override
    public void marshal(ITypeMarshalBuffer buffer, boolean includeValue) throws CoreException {
        int firstBytes = 23;
        if (this.fIsComma) {
            firstBytes = (short)(firstBytes | 0x20);
        }
        if (this.fIsLeftFold) {
            firstBytes = (short)(firstBytes | 0x40);
        }
        buffer.putShort((byte)firstBytes);
        buffer.putInt(this.fOperator);
        buffer.putInt(this.fPackEvals.length);
        ICPPEvaluation[] iCPPEvaluationArray = this.fPackEvals;
        int n = this.fPackEvals.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            buffer.marshalEvaluation(arg, includeValue);
            ++n2;
        }
        buffer.marshalEvaluation(this.fInitEval, includeValue);
        this.marshalTemplateDefinition(buffer);
    }

    public static ICPPEvaluation unmarshal(short firstBytes, ITypeMarshalBuffer buffer) throws CoreException {
        boolean isComma = (firstBytes & 0x20) != 0;
        boolean isLeftFold = (firstBytes & 0x40) != 0;
        int operator = buffer.getInt();
        int len = buffer.getInt();
        ICPPEvaluation[] packEvals = new ICPPEvaluation[len];
        int i = 0;
        while (i < packEvals.length) {
            packEvals[i] = buffer.unmarshalEvaluation();
            ++i;
        }
        ICPPEvaluation initEval = buffer.unmarshalEvaluation();
        IBinding templateDefinition = buffer.unmarshalBinding();
        return new EvalFoldExpression(operator, isComma, isLeftFold, packEvals, initEval, templateDefinition);
    }

    @Override
    public ICPPEvaluation instantiate(InstantiationContext context, int maxDepth) {
        ICPPEvaluation initEval;
        Object[] packEvals = EvalFoldExpression.instantiateExpressions(this.fPackEvals, context, maxDepth);
        ICPPEvaluation iCPPEvaluation = initEval = this.fInitEval == null ? null : this.fInitEval.instantiate(context, maxDepth);
        if (packEvals == this.fPackEvals && initEval == this.fInitEval) {
            return this;
        }
        if (!this.fIsLeftFold) {
            ArrayUtil.reverse(packEvals);
        }
        return new EvalFoldExpression(this.fOperator, this.fIsComma, this.fIsLeftFold, (ICPPEvaluation[])packEvals, initEval, this.getTemplateDefinition());
    }

    @Override
    public ICPPEvaluation computeForFunctionCall(ActivationRecord record, ICPPEvaluation.ConstexprEvaluationContext context) {
        ICPPEvaluation initEval;
        if (context.getStepsPerformed() >= 1024) {
            return EvalFixed.INCOMPLETE;
        }
        ICPPEvaluation[] packEvals = new ICPPEvaluation[this.fPackEvals.length];
        int i = 0;
        while (i < this.fPackEvals.length) {
            ICPPEvaluation arg;
            packEvals[i] = arg = this.fPackEvals[i].computeForFunctionCall(record, context.recordStep());
            ++i;
        }
        ICPPEvaluation iCPPEvaluation = initEval = this.fInitEval == null ? null : this.fInitEval.computeForFunctionCall(record, context.recordStep());
        if (packEvals == this.fPackEvals && initEval == this.fInitEval) {
            return this;
        }
        return new EvalFoldExpression(this.fOperator, this.fIsComma, this.fIsLeftFold, packEvals, initEval, this.getTemplateDefinition());
    }

    @Override
    public int determinePackSize(ICPPTemplateParameterMap tpMap) {
        int r = Integer.MAX_VALUE;
        ICPPEvaluation[] iCPPEvaluationArray = this.fPackEvals;
        int n = this.fPackEvals.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation packElement = iCPPEvaluationArray[n2];
            r = CPPTemplates.combinePackSize(r, packElement.determinePackSize(tpMap));
            ++n2;
        }
        return r;
    }

    @Override
    public boolean referencesTemplateParameter() {
        ICPPEvaluation[] iCPPEvaluationArray = this.fPackEvals;
        int n = this.fPackEvals.length;
        int n2 = 0;
        while (n2 < n) {
            ICPPEvaluation arg = iCPPEvaluationArray[n2];
            if (arg.referencesTemplateParameter()) {
                return true;
            }
            ++n2;
        }
        return this.fInitEval != null && this.fInitEval.referencesTemplateParameter();
    }

    @Override
    public boolean isNoexcept() {
        int i = 0;
        while (i < this.fPackEvals.length) {
            ICPPEvaluation eval = this.fPackEvals[i];
            if (!eval.isNoexcept()) {
                return false;
            }
            ++i;
        }
        if (this.fInitEval != null) {
            return this.fInitEval.isNoexcept();
        }
        return true;
    }
}

