/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.params;

import java.lang.reflect.Executable;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.ParameterContext;
import org.junit.jupiter.api.extension.ParameterResolutionException;
import org.junit.jupiter.api.extension.ParameterResolver;
import org.junit.jupiter.api.extension.TestInstantiationAwareExtension;
import org.junit.jupiter.params.EvaluatedArgumentSet;
import org.junit.jupiter.params.ResolutionCache;
import org.junit.jupiter.params.ResolverFacade;

abstract class ParameterizedInvocationParameterResolver
implements ParameterResolver {
    private final ResolverFacade resolverFacade;
    private final EvaluatedArgumentSet arguments;
    private final int invocationIndex;
    private final ResolutionCache resolutionCache;

    ParameterizedInvocationParameterResolver(ResolverFacade resolverFacade, EvaluatedArgumentSet arguments, int invocationIndex, ResolutionCache resolutionCache) {
        this.resolverFacade = resolverFacade;
        this.arguments = arguments;
        this.invocationIndex = invocationIndex;
        this.resolutionCache = resolutionCache;
    }

    public final TestInstantiationAwareExtension.ExtensionContextScope getTestInstantiationExtensionContextScope(ExtensionContext rootContext) {
        return TestInstantiationAwareExtension.ExtensionContextScope.TEST_METHOD;
    }

    public final boolean supportsParameter(ParameterContext parameterContext, ExtensionContext extensionContext) {
        return this.isSupportedOnConstructorOrMethod(parameterContext.getDeclaringExecutable(), extensionContext) && this.resolverFacade.isSupportedParameter(parameterContext, this.arguments);
    }

    public final @Nullable Object resolveParameter(ParameterContext parameterContext, ExtensionContext extensionContext) throws ParameterResolutionException {
        return this.resolverFacade.resolve(parameterContext, extensionContext, this.arguments, this.invocationIndex, this.resolutionCache);
    }

    protected abstract boolean isSupportedOnConstructorOrMethod(Executable var1, ExtensionContext var2);
}

