/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.ui.interpreter.internal.view.actions;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.sirius.ui.interpreter.internal.InterpreterMessages;
import org.eclipse.sirius.ui.interpreter.internal.view.Variable;
import org.eclipse.sirius.ui.interpreter.internal.view.wizards.NewVariableWizard;
import org.eclipse.ui.PlatformUI;

public class NewVariableWizardAction
extends Action {
    protected final TreeViewer variableViewer;
    private final Variable variable;

    public NewVariableWizardAction(TreeViewer variableViewer, Variable variable) {
        super(InterpreterMessages.getString("interpreter.action.wizard.newvariable.name"));
        this.variableViewer = variableViewer;
        this.variable = variable;
    }

    public void run() {
        NewVariableWizard wizard = new NewVariableWizard(this.variable, this.getExistingVariables());
        WizardDialog dialog = new WizardDialog(PlatformUI.getWorkbench().getDisplay().getActiveShell(), (IWizard)wizard);
        int result = dialog.open();
        if (result == 0) {
            Object currentValue;
            String variableName = wizard.getVariableName();
            Object variableValue = wizard.getVariableValue();
            Variable target = this.variable != null && variableName.equals(this.variable.getName()) ? this.variable : this.getExistingVariable(variableName);
            if (target == null) {
                target = this.createVariable(variableName);
            }
            if ((currentValue = target.getValue()) != null && !(currentValue instanceof Collection)) {
                ArrayList<Object> newValue = new ArrayList<Object>(2);
                newValue.add(currentValue);
                newValue.add(variableValue);
                target.setValue(newValue);
            } else if (currentValue instanceof Collection) {
                ((Collection)currentValue).add(variableValue);
            } else {
                target.setValue(variableValue);
            }
            this.variableViewer.expandToLevel((Object)new TreePath(new Object[]{target, variableValue}), 0);
            this.variableViewer.refresh();
        }
    }

    private Variable createVariable(String name) {
        Variable result = new Variable(name);
        ArrayList input = this.variableViewer.getInput();
        if (input == null) {
            input = new ArrayList();
            this.variableViewer.setInput(input);
        } else if (input instanceof Variable) {
            ArrayList<Variable> newInput = new ArrayList<Variable>();
            newInput.add((Variable)((Object)input));
            this.variableViewer.setInput(newInput);
        }
        if (input instanceof Collection) {
            ((Collection)input).add(result);
        }
        return result;
    }

    private Variable getExistingVariable(String name) {
        Object input = this.variableViewer.getInput();
        if (input instanceof Iterable) {
            for (Variable candidate : (Iterable)input) {
                if (!name.equals(candidate.getName())) continue;
                return candidate;
            }
        }
        Variable result = null;
        if (input instanceof Variable && name.equals(((Variable)input).getName())) {
            result = (Variable)input;
        }
        return result;
    }

    private List<Variable> getExistingVariables() {
        ArrayList<Variable> result = new ArrayList<Variable>();
        Object input = this.variableViewer.getInput();
        if (input instanceof Iterable) {
            for (Variable candidate : (Iterable)input) {
                result.add(candidate);
            }
        } else if (input instanceof Variable) {
            result.add((Variable)input);
        }
        return result;
    }
}

