/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.tests.swtbot.support.api.matcher.geometry;

import org.eclipse.draw2d.geometry.Point;
import org.hamcrest.BaseMatcher;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class PointAround
extends BaseMatcher<Point> {
    private final int distance;
    private final Point expected;

    protected PointAround(Point expected, int distance) {
        this.expected = expected;
        this.distance = distance;
    }

    public boolean matches(Object item) {
        if (item instanceof Point) {
            Point other = (Point)item;
            return PointAround.isAround(this.expected, other, this.distance);
        }
        return false;
    }

    protected static boolean isAround(Point expected, Point actual, int distance) {
        return actual.getDistance(expected) <= (double)distance;
    }

    public void describeTo(Description description) {
        description.appendText("A point around ");
        description.appendValue((Object)this.expected);
        description.appendText("and whom distance from this point is less or equal to " + this.distance);
    }

    public static Matcher<Point> around(Point expected, int distance) {
        return new PointAround(expected, distance);
    }
}

