/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rap.ui.internal.launch.rwt.tab;

import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.rap.ui.internal.launch.rwt.config.RWTLaunchConfig;
import org.eclipse.rap.ui.internal.launch.rwt.tab.BrowserSection;
import org.eclipse.rap.ui.internal.launch.rwt.tab.EntryPointSection;
import org.eclipse.rap.ui.internal.launch.rwt.tab.HelpContextIds;
import org.eclipse.rap.ui.internal.launch.rwt.tab.JavaProjectSelectionDialog;
import org.eclipse.rap.ui.internal.launch.rwt.tab.RWTLaunchTab;
import org.eclipse.rap.ui.internal.launch.rwt.tab.RuntimeSettingsSection;
import org.eclipse.rap.ui.internal.launch.rwt.util.Images;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class RWTMainTab
extends RWTLaunchTab {
    private Text txtProject;
    private Button btnSelectProject;
    private EntryPointSection entryPointSection = new EntryPointSection();
    private RuntimeSettingsSection runtimeSettingsSection = new RuntimeSettingsSection();
    private BrowserSection browserSection = new BrowserSection();

    public String getName() {
        return "Main";
    }

    public Image getImage() {
        return Images.getImage("VIEW_MAIN_TAB");
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        container.setLayoutData((Object)new GridData(4, 4, true, true));
        container.setLayout((Layout)new GridLayout(1, false));
        this.createProjectSection(container);
        this.entryPointSection.createControl(container);
        this.runtimeSettingsSection.createControl(container);
        this.browserSection.createControl(container);
        Dialog.applyDialogFont((Control)container);
        this.setControl((Control)container);
        HelpContextIds.assign(this.getControl(), "org.eclipse.ra.ui.launch.rwt.launch_configuration_dialog_main_tab");
    }

    private void createProjectSection(Composite container) {
        Group group = new Group(container, 0);
        group.setText("Project");
        group.setLayoutData((Object)new GridData(4, 128, true, false));
        group.setLayout((Layout)new GridLayout(2, false));
        this.txtProject = new Text((Composite)group, 2048);
        this.txtProject.setLayoutData((Object)new GridData(4, 128, true, false));
        this.txtProject.addModifyListener((ModifyListener)new TextModifyListener());
        this.btnSelectProject = new Button((Composite)group, 8);
        this.btnSelectProject.setText("&Browse...");
        GridData gridData = new GridData(16384, 128, false, false);
        this.btnSelectProject.setLayoutData((Object)gridData);
        this.btnSelectProject.addSelectionListener((SelectionListener)new JavaProjectSelectionListener());
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        super.setLaunchConfigurationDialog(dialog);
        this.entryPointSection.setLaunchConfigurationDialog(dialog);
        this.runtimeSettingsSection.setLaunchConfigurationDialog(dialog);
        this.browserSection.setLaunchConfigurationDialog(dialog);
    }

    public void initializeFrom(RWTLaunchConfig launchConfig) {
        this.txtProject.setText(launchConfig.getProjectName());
        this.entryPointSection.initializeFrom(launchConfig);
        this.runtimeSettingsSection.initializeFrom(launchConfig);
        this.browserSection.initializeFrom(launchConfig);
    }

    public void performApply(RWTLaunchConfig launchConfig) {
        launchConfig.setProjectName(this.txtProject.getText().trim());
        this.entryPointSection.performApply(launchConfig);
        this.runtimeSettingsSection.performApply(launchConfig);
        this.browserSection.performApply(launchConfig);
    }

    private void handleSelectJavaProject() {
        IJavaProject project = this.selectJavaProject();
        if (project != null) {
            String projectName = project.getElementName();
            this.txtProject.setText(projectName);
        }
    }

    private IJavaProject selectJavaProject() {
        Shell shell = this.getShell();
        JavaProjectSelectionDialog dialog = new JavaProjectSelectionDialog(shell);
        dialog.setInitialSelection(this.getJavaProject());
        return dialog.open();
    }

    private IJavaProject getJavaProject() {
        IJavaProject result = null;
        String projectName = this.txtProject.getText().trim();
        if (projectName.length() > 0) {
            result = RWTMainTab.getJavaModel().getJavaProject(projectName);
        }
        return result;
    }

    private static IJavaModel getJavaModel() {
        IWorkspaceRoot workspaceRoot = ResourcesPlugin.getWorkspace().getRoot();
        return JavaCore.create((IWorkspaceRoot)workspaceRoot);
    }

    private class JavaProjectSelectionListener
    extends SelectionAdapter {
        private JavaProjectSelectionListener() {
        }

        public void widgetSelected(SelectionEvent event) {
            RWTMainTab.this.handleSelectJavaProject();
            RWTMainTab.this.updateLaunchConfigurationDialog();
        }
    }

    private class TextModifyListener
    implements ModifyListener {
        private TextModifyListener() {
        }

        public void modifyText(ModifyEvent event) {
            RWTMainTab.this.updateLaunchConfigurationDialog();
        }
    }
}

