/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.ws.internal.explorer.platform.favorites.actions;

import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.wst.ws.internal.explorer.platform.actions.LinkAction;
import org.eclipse.wst.ws.internal.explorer.platform.datamodel.TreeElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesFolderElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.datamodel.FavoritesMainElement;
import org.eclipse.wst.ws.internal.explorer.platform.favorites.perspective.FavoritesPerspective;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Controller;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.Node;
import org.eclipse.wst.ws.internal.explorer.platform.perspective.NodeManager;

public class FavoritesRestoreDefaultFavoritesAction
extends LinkAction {
    public FavoritesRestoreDefaultFavoritesAction(Controller controller) {
        super(controller);
    }

    public static String getActionLink(int nodeID, int toolID, int viewID, int viewToolID) {
        StringBuffer actionLink = new StringBuffer("favorites/actions/RestoreDefaultFavoritesConfirmJSP.jsp");
        return actionLink.toString();
    }

    protected boolean processLinkParameters(HttpServletRequest request) {
        return true;
    }

    public boolean run() {
        FavoritesPerspective favPerspective = this.controller_.getFavoritesPerspective();
        NodeManager nodeManager = favPerspective.getNodeManager();
        Node mainNode = nodeManager.getRootNode();
        FavoritesMainElement mainElement = (FavoritesMainElement)mainNode.getTreeElement();
        boolean actionResult = mainElement.restoreFavoritesDefault();
        if (actionResult) {
            Vector folderNodes = mainNode.getChildNodes();
            int i = 0;
            while (i < folderNodes.size()) {
                Node folderNode = (Node)folderNodes.elementAt(i);
                TreeElement treeElement = folderNode.getTreeElement();
                if (treeElement instanceof FavoritesFolderElement) {
                    FavoritesFolderElement folderElement = (FavoritesFolderElement)treeElement;
                    folderElement.removeAllFavorites(this.controller_.getServletEngineStateLocation());
                    folderElement.init(mainElement);
                }
                ++i;
            }
            favPerspective.getMessageQueue().addMessage(favPerspective.getMessage("MSG_INFO_FAVORITES_RESTORED_TO_DEFAULT"));
            return true;
        }
        favPerspective.getMessageQueue().addMessage(favPerspective.getMessage("MSG_ERROR_OPEN_FAVORITES_BACKUP"));
        return false;
    }
}

