/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wb.internal.core.model.property.order;

import java.util.List;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.wb.core.model.AbstractComponentInfo;
import org.eclipse.wb.core.model.JavaInfo;
import org.eclipse.wb.core.model.ObjectInfo;
import org.eclipse.wb.core.model.broadcast.ObjectInfoDelete;
import org.eclipse.wb.internal.core.model.property.Property;
import org.eclipse.wb.internal.core.model.property.order.TabOrderInfo;
import org.eclipse.wb.internal.core.model.property.order.TabOrderPropertyEditor;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipProvider;
import org.eclipse.wb.internal.core.model.property.table.PropertyTooltipTextProvider;
import org.eclipse.wb.internal.core.model.util.TemplateUtils;
import org.eclipse.wb.internal.core.utils.ast.DomGenerics;
import org.eclipse.wb.internal.core.utils.check.Assert;
import org.eclipse.wb.internal.core.utils.execution.ExecutionUtils;
import org.eclipse.wb.internal.core.utils.execution.RunnableEx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class TabOrderProperty
extends Property {
    protected final JavaInfo m_container;

    public TabOrderProperty(JavaInfo container) {
        super(TabOrderPropertyEditor.INSTANCE);
        this.m_container = container;
        this.m_container.addBroadcastListener(new ObjectInfoDelete(){

            public void before(ObjectInfo parent, ObjectInfo child) throws Exception {
                TabOrderProperty.this.handleDeleteOrderElement(parent, child);
            }
        });
    }

    public final String getTitle() {
        return "tab order";
    }

    public final boolean isModified() throws Exception {
        return this.getOrderedArray() != null;
    }

    public final Object getValue() throws Exception {
        TabOrderInfo orderInfo = new TabOrderInfo();
        List<? extends AbstractComponentInfo> components = this.getTabPossibleChildren();
        orderInfo.getInfos().addAll(components);
        ArrayInitializer arrayInitializer = this.getOrderedArray();
        if (arrayInitializer == null) {
            orderInfo.setDefault();
            for (AbstractComponentInfo abstractComponentInfo : components) {
                if (!this.isDefaultOrdered(abstractComponentInfo)) continue;
                orderInfo.addOrderedInfo(abstractComponentInfo);
            }
        } else {
            for (Expression expression : DomGenerics.expressions(arrayInitializer)) {
                JavaInfo component = this.m_container.getChildRepresentedBy((ASTNode)expression);
                if (!(component instanceof AbstractComponentInfo)) continue;
                orderInfo.addOrderedInfo((AbstractComponentInfo)component);
            }
            orderInfo.reorder();
        }
        return orderInfo;
    }

    public final String getDisplayText() throws Exception {
        ArrayInitializer arrayInitializer = this.getOrderedArray();
        if (arrayInitializer == null) {
            return "";
        }
        StringBuffer textBuffer = new StringBuffer("[");
        for (Expression expression : DomGenerics.expressions(arrayInitializer)) {
            JavaInfo component = this.m_container.getChildRepresentedBy((ASTNode)expression);
            if (!(component instanceof AbstractComponentInfo)) continue;
            if (textBuffer.length() > 1) {
                textBuffer.append(", ");
            }
            textBuffer.append(component.getVariableSupport().getTitle());
        }
        textBuffer.append(']');
        return textBuffer.toString();
    }

    public final void setValue(final Object value) throws Exception {
        ExecutionUtils.run((ObjectInfo)this.m_container, (RunnableEx)new RunnableEx(){

            public void run() throws Exception {
                TabOrderProperty.this.setValueEx(value);
            }
        });
    }

    private void setValueEx(Object value) throws Exception {
        if (value == UNKNOWN_VALUE) {
            this.removePropertyAssociation();
        } else {
            TabOrderInfo orderInfo = (TabOrderInfo)value;
            List<AbstractComponentInfo> orderedInfos = orderInfo.getOrderedInfos();
            this.removePropertyAssociation();
            if (!orderedInfos.isEmpty()) {
                StringBuffer source = new StringBuffer("{");
                for (AbstractComponentInfo component : orderedInfos) {
                    if (source.length() != 1) {
                        source.append(", ");
                    }
                    source.append(TabOrderProperty.getComponentReference(component));
                }
                source.append("}");
                this.setOrderedArraySource(source.toString());
                ArrayInitializer arrayInitializer = this.getOrderedArray();
                Assert.isNotNull((Object)arrayInitializer);
                List<Expression> arrayArguments = DomGenerics.expressions(arrayInitializer);
                int size = arrayArguments.size();
                Assert.equals((int)orderedInfos.size(), (int)size);
                int i = 0;
                while (i < size) {
                    orderedInfos.get(i).addRelatedNode((ASTNode)arrayArguments.get(i));
                    ++i;
                }
            }
        }
    }

    private static String getComponentReference(AbstractComponentInfo component) throws Exception {
        return TemplateUtils.getExpression(component);
    }

    protected abstract List<? extends AbstractComponentInfo> getTabPossibleChildren() throws Exception;

    protected abstract boolean isDefaultOrdered(AbstractComponentInfo var1) throws Exception;

    protected abstract ArrayInitializer getOrderedArray() throws Exception;

    protected abstract void setOrderedArraySource(String var1) throws Exception;

    protected abstract void removePropertyAssociation() throws Exception;

    private final void handleDeleteOrderElement(ObjectInfo parent, ObjectInfo child) throws Exception {
        TabOrderInfo orderInfo;
        if (this.hasOrderElement(parent, child) && !(orderInfo = (TabOrderInfo)this.getValue()).isDefault() && orderInfo.getOrderedInfos().remove(child)) {
            this.setValue(orderInfo);
        }
    }

    protected boolean hasOrderElement(ObjectInfo parent, ObjectInfo child) throws Exception {
        return parent == this.m_container;
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (adapter == PropertyTooltipProvider.class && this.getPropertyTooltipText() != null) {
            return adapter.cast(new PropertyTooltipTextProvider(){

                protected String getText(Property property) throws Exception {
                    return TabOrderProperty.this.getPropertyTooltipText();
                }
            });
        }
        return (T)super.getAdapter(adapter);
    }

    protected abstract String getPropertyTooltipText();
}

