/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.viatra.query.tooling.ui.queryexplorer.content.matcher;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.viatra.query.runtime.matchers.psystem.queries.PProblem;
import org.eclipse.viatra.query.tooling.ui.ViatraQueryGUIPlugin;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.matcher.BaseContent;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.matcher.PatternMatchContent;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.matcher.PatternMatcherContent;
import org.eclipse.viatra.query.tooling.ui.queryexplorer.content.matcher.PatternMatcherRootContent;

public class QueryExplorerLabelProvider
extends ColumnLabelProvider {
    private List<ILabelProviderListener> listeners = new ArrayList<ILabelProviderListener>();

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return property.matches("text");
    }

    public void removeListener(ILabelProviderListener listener) {
        this.listeners.remove(listener);
    }

    public void addListener(ILabelProviderListener listener) {
        this.listeners.add(listener);
    }

    public Image getImage(Object element) {
        ImageRegistry imageRegistry = ViatraQueryGUIPlugin.getDefault().getImageRegistry();
        if (element instanceof PatternMatcherRootContent) {
            PatternMatcherRootContent root = (PatternMatcherRootContent)element;
            if (root.isTainted() || root.getStatus().getSeverity() == 4) {
                return imageRegistry.get("error");
            }
            return imageRegistry.get("navigator_root");
        }
        if (element instanceof PatternMatcherContent) {
            if (((PatternMatcherContent)element).isCreated()) {
                return imageRegistry.get("matcher");
            }
            return imageRegistry.get("error");
        }
        if (element instanceof PatternMatchContent) {
            return imageRegistry.get("match");
        }
        return null;
    }

    public String getText(Object element) {
        if (element instanceof BaseContent) {
            return ((BaseContent)element).getText();
        }
        return null;
    }

    public String getToolTipText(Object element) {
        if (element instanceof PatternMatcherRootContent) {
            IStatus status = ((PatternMatcherRootContent)element).getStatus();
            if (!status.isOK()) {
                return String.format("%s. For details, check the Error Log view.", status.getMessage());
            }
        } else if (element instanceof PatternMatcherContent) {
            PatternMatcherContent pmContent = (PatternMatcherContent)element;
            Exception exception = pmContent.getException();
            List pProblems = pmContent.getSpecification().getInternalQueryRepresentation().getPProblems();
            if (!pProblems.isEmpty()) {
                StringBuilder sb = new StringBuilder();
                sb.append("The following problems have been detected in the query specification: \n");
                for (PProblem pProblem : pProblems) {
                    sb.append(String.format(" * %s%n", pProblem.getShortMessage()));
                }
                return sb.toString();
            }
            if (exception != null) {
                StringWriter sw = new StringWriter();
                PrintWriter pw = new PrintWriter(sw);
                pw.println("The following exception occured during query evaluation:");
                String msg = exception.getLocalizedMessage();
                String exceptionClassName = exception.getClass().getName();
                if (msg == null) {
                    pw.println("\t " + exceptionClassName);
                } else {
                    pw.println("\t " + exceptionClassName + ": " + msg);
                }
                pw.println("See Error Log for detailed stack trace.");
                return sw.toString();
            }
        }
        return super.getToolTipText(element);
    }

    public Color getForeground(Object element) {
        PatternMatcherContent matcher;
        Display display = Display.getCurrent();
        if (element instanceof PatternMatcherContent && (matcher = (PatternMatcherContent)element).isGenerated()) {
            return display.getSystemColor(16);
        }
        return display.getSystemColor(2);
    }
}

