/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model;

import java.util.LinkedList;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlModelFactory;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.ITmfXmlStateAttribute;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.model.TmfXmlScenarioInfo;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.IXmlStateSystemContainer;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.XmlUtils;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.w3c.dom.Element;

public class TmfXmlLocation {
    private final List<ITmfXmlStateAttribute> fPath = new LinkedList<ITmfXmlStateAttribute>();
    private final String fId;
    private final IXmlStateSystemContainer fContainer;

    public TmfXmlLocation(ITmfXmlModelFactory modelFactory, Element location, IXmlStateSystemContainer container) {
        String id;
        this.fId = id = location.getAttribute("id");
        this.fContainer = container;
        List<@Nullable Element> childElements = XmlUtils.getChildElements(location);
        for (Element attribute : childElements) {
            if (attribute == null) continue;
            ITmfXmlStateAttribute xAttribute = modelFactory.createStateAttribute(attribute, this.fContainer);
            this.fPath.add(xAttribute);
        }
    }

    public String getId() {
        return this.fId;
    }

    public int getLocationQuark(@Nullable ITmfEvent event, int startQuark, @Nullable TmfXmlScenarioInfo scenarioInfo) {
        int quark = startQuark;
        for (ITmfXmlStateAttribute attrib : this.fPath) {
            quark = attrib.getAttributeQuark(event, quark, scenarioInfo);
            if (quark == -1) break;
        }
        return quark;
    }

    public int getLocationQuark(int startQuark, @Nullable TmfXmlScenarioInfo scenarioInfo) {
        int quark = startQuark;
        for (ITmfXmlStateAttribute attrib : this.fPath) {
            quark = attrib.getAttributeQuark(quark, scenarioInfo);
            if (quark == -1) break;
        }
        return quark;
    }

    public String toString() {
        return "TmfXmlLocation " + this.fId + ": " + this.fPath;
    }
}

