/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.lttng2.ust.core.analysis.memory;

import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.memory.UstMemoryStateProvider;
import org.eclipse.tracecompass.lttng2.ust.core.analysis.memory.Messages;
import org.eclipse.tracecompass.lttng2.ust.core.trace.LttngUstTrace;
import org.eclipse.tracecompass.lttng2.ust.core.trace.layout.ILttngUstEventLayout;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAbstractAnalysisRequirement;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAnalysisEventRequirement;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.statesystem.ITmfStateProvider;
import org.eclipse.tracecompass.tmf.core.statesystem.TmfStateSystemAnalysisModule;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class UstMemoryAnalysisModule
extends TmfStateSystemAnalysisModule {
    public static final @NonNull String ID = "org.eclipse.linuxtools.lttng2.ust.analysis.memory";
    private @Nullable Set<TmfAbstractAnalysisRequirement> fAnalysisRequirements;

    protected ITmfStateProvider createStateProvider() {
        return new UstMemoryStateProvider((LttngUstTrace)((Object)NonNullUtils.checkNotNull((Object)((Object)this.getTrace()))));
    }

    public boolean setTrace(ITmfTrace trace) throws TmfAnalysisException {
        if (!(trace instanceof LttngUstTrace)) {
            return false;
        }
        return super.setTrace(trace);
    }

    public LttngUstTrace getTrace() {
        return (LttngUstTrace)super.getTrace();
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public Iterable<TmfAbstractAnalysisRequirement> getAnalysisRequirements() {
        ImmutableSet requirements = this.fAnalysisRequirements;
        if (requirements == null) {
            LttngUstTrace trace = this.getTrace();
            ILttngUstEventLayout layout = trace == null ? ILttngUstEventLayout.DEFAULT_LAYOUT : trace.getEventLayout();
            @NonNull @NonNull ImmutableSet requiredEvents = ImmutableSet.of((Object)layout.eventLibcMalloc(), (Object)layout.eventLibcFree(), (Object)layout.eventLibcCalloc(), (Object)layout.eventLibcRealloc(), (Object)layout.eventLibcMemalign(), (Object)layout.eventLibcPosixMemalign(), (Object[])new String[0]);
            TmfAnalysisEventRequirement eventsReq = new TmfAnalysisEventRequirement((Collection)requiredEvents, TmfAbstractAnalysisRequirement.PriorityLevel.MANDATORY);
            eventsReq.addInformation(NonNullUtils.nullToEmptyString((Object)Messages.UstMemoryAnalysisModule_EventsLoadingInformation));
            eventsReq.addInformation(NonNullUtils.nullToEmptyString((Object)Messages.UstMemoryAnalysisModule_EventsLoadingExampleInformation));
            this.fAnalysisRequirements = requirements = ImmutableSet.of((Object)eventsReq);
        }
        return requirements;
    }
}

