/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect;

import java.util.Comparator;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.aspect.LamiTableEntryAspect;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.module.LamiTableEntry;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiData;
import org.eclipse.tracecompass.internal.provisional.analysis.lami.core.types.LamiProcess;

public class LamiProcessTIDAspect
extends LamiTableEntryAspect {
    private final int fColIndex;

    public LamiProcessTIDAspect(String colName, int colIndex) {
        super(String.valueOf(colName) + " (TID)", null);
        this.fColIndex = colIndex;
    }

    @Override
    public boolean isContinuous() {
        return false;
    }

    @Override
    public boolean isTimeStamp() {
        return false;
    }

    @Override
    public @Nullable String resolveString(LamiTableEntry entry) {
        LamiData data = entry.getValue(this.fColIndex);
        if (data instanceof LamiProcess) {
            Long tid = ((LamiProcess)data).getTID();
            if (tid == null) {
                return null;
            }
            return tid.toString();
        }
        return data.toString();
    }

    @Override
    public @Nullable Number resolveNumber(LamiTableEntry entry) {
        LamiData data = entry.getValue(this.fColIndex);
        if (data instanceof LamiProcess) {
            Long tid = ((LamiProcess)data).getTID();
            return tid;
        }
        return null;
    }

    @Override
    public Comparator<LamiTableEntry> getComparator() {
        return (o1, o2) -> {
            Number d1 = this.resolveNumber((LamiTableEntry)o1);
            Number d2 = this.resolveNumber((LamiTableEntry)o2);
            if (d1 == null && d2 == null) {
                return 0;
            }
            if (d1 == null) {
                return 1;
            }
            if (d2 == null) {
                return -1;
            }
            return Long.compare(d1.longValue(), d2.longValue());
        };
    }
}

