/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui.operations;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.TeamException;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSTag;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteFile;
import org.eclipse.team.internal.ccvs.core.ICVSRemoteResource;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.ICVSResource;
import org.eclipse.team.internal.ccvs.core.ILogEntry;
import org.eclipse.team.internal.ccvs.core.client.Command;
import org.eclipse.team.internal.ccvs.core.client.RLog;
import org.eclipse.team.internal.ccvs.core.client.Session;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.ILogEntryListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.LogListener;
import org.eclipse.team.internal.ccvs.core.resources.CVSWorkspaceRoot;
import org.eclipse.team.internal.ccvs.core.util.Util;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.Policy;
import org.eclipse.team.internal.ccvs.ui.operations.RepositoryLocationOperation;
import org.eclipse.ui.IWorkbenchPart;

public class RemoteLogOperation
extends RepositoryLocationOperation {
    private RLog rlog = new RLog();
    private CVSTag tag1;
    private CVSTag tag2;
    private LogEntryCache entryCache;

    public RemoteLogOperation(IWorkbenchPart part, ICVSRemoteResource[] remoteResources, CVSTag tag1, CVSTag tag2, LogEntryCache cache) {
        super(part, remoteResources);
        this.tag1 = tag1;
        this.tag2 = tag2;
        this.entryCache = cache;
    }

    @Override
    protected void execute(ICVSRepositoryLocation location, ICVSRemoteResource[] remoteResources, IProgressMonitor monitor) throws CVSException {
        monitor.beginTask(NLS.bind((String)CVSUIMessages.RemoteLogOperation_0, (Object[])new String[]{location.getHost()}), 100);
        Session s = new Session(location, CVSWorkspaceRoot.getCVSFolderFor((IContainer)ResourcesPlugin.getWorkspace().getRoot()), false);
        LogListener listener = new LogListener((ILogEntryListener)this.entryCache);
        ICVSRemoteResource[] remotes = remoteResources;
        Command.LocalOption[] localOptions = this.getLocalOptions(this.tag1, this.tag2);
        if (this.tag1 == null || this.tag2 == null) {
            ArrayList<ICVSRemoteResource> unCachedRemotes = new ArrayList<ICVSRemoteResource>();
            int i = 0;
            while (i < remoteResources.length) {
                ICVSRemoteResource r = remoteResources[i];
                if (this.entryCache.getLogEntry(r) == null) {
                    unCachedRemotes.add(r);
                }
                ++i;
            }
            remotes = unCachedRemotes.toArray(new ICVSRemoteResource[unCachedRemotes.size()]);
        }
        if (remotes.length > 0) {
            try {
                s.open(Policy.subMonitorFor(monitor, 10));
                IStatus status = this.rlog.execute(s, Command.NO_GLOBAL_OPTIONS, localOptions, (ICVSResource[])remotes, (ICommandOutputListener)listener, Policy.subMonitorFor(monitor, 90));
                this.collectStatus(status);
            }
            finally {
                s.close();
            }
        }
    }

    @Override
    protected String getTaskName() {
        return CVSUIMessages.RemoteLogOperation_1;
    }

    protected Command.LocalOption[] getLocalOptions(CVSTag tag1, CVSTag tag2) {
        if (tag1 != null && tag2 != null) {
            return new Command.LocalOption[]{RLog.NO_TAGS, RLog.ONLY_INCLUDE_CHANGES, RLog.makeTagOption((CVSTag)tag1, (CVSTag)tag2)};
        }
        if (tag1 != null) {
            if (tag1.getType() == 0 || tag1.getType() == 2) {
                return new Command.LocalOption[]{RLog.NO_TAGS, RLog.ONLY_INCLUDE_CHANGES, RLog.getCurrentTag((CVSTag)tag1)};
            }
            if (tag1.getType() == 3) {
                return new Command.LocalOption[]{RLog.NO_TAGS, RLog.ONLY_INCLUDE_CHANGES, RLog.REVISIONS_ON_DEFAULT_BRANCH, RLog.getCurrentTag((CVSTag)tag1)};
            }
            return new Command.LocalOption[]{RLog.getCurrentTag((CVSTag)tag1)};
        }
        return new Command.LocalOption[]{RLog.NO_TAGS, RLog.ONLY_INCLUDE_CHANGES};
    }

    public static class LogEntryCache
    implements ILogEntryListener {
        private Map entries = new HashMap();

        private Map internalGetLogEntries(String path) {
            return (Map)this.entries.get(path);
        }

        public ILogEntry[] getLogEntries(String path) {
            Map map = this.internalGetLogEntries(path);
            return map.values().toArray(new ILogEntry[map.values().size()]);
        }

        private ILogEntry internalGetLogEntry(String path, String revision) {
            Map fileEntries = this.internalGetLogEntries(path);
            if (fileEntries != null) {
                return (ILogEntry)fileEntries.get(revision);
            }
            return null;
        }

        public String[] getCachedFilePaths() {
            return this.entries.keySet().toArray(new String[this.entries.size()]);
        }

        public synchronized ILogEntry getLogEntry(ICVSRemoteResource resource) {
            if (resource instanceof ICVSRemoteFile) {
                try {
                    String path = this.getFullPath(resource);
                    String revision = ((ICVSRemoteFile)resource).getRevision();
                    return this.internalGetLogEntry(path, revision);
                }
                catch (TeamException e) {
                    CVSUIPlugin.log((CoreException)((Object)e));
                }
            }
            return null;
        }

        public synchronized ILogEntry[] getLogEntries(ICVSRemoteResource resource) {
            Map fileEntries = this.internalGetLogEntries(this.getFullPath(resource));
            if (fileEntries != null) {
                return fileEntries.values().toArray(new ILogEntry[fileEntries.size()]);
            }
            return new ILogEntry[0];
        }

        private String getFullPath(ICVSRemoteResource resource) {
            return Util.appendPath((String)resource.getRepository().getLocation(false), (String)resource.getRepositoryRelativePath());
        }

        public synchronized void clearEntries() {
            this.entries.clear();
        }

        public synchronized ICVSRemoteFile getImmediatePredecessor(ICVSRemoteFile file) throws TeamException {
            String revision;
            String predecessorRevision;
            ILogEntry[] allLogs = this.getLogEntries((ICVSRemoteResource)file);
            ICVSRemoteFile predecessor = this.findRevison(allLogs, predecessorRevision = this.getPredecessorRevision(revision = file.getRevision()));
            if (predecessor == null && this.isBrancheRevision(revision)) {
                predecessorRevision = this.getBaseRevision(revision);
                predecessor = this.findRevison(allLogs, predecessorRevision);
            }
            return predecessor;
        }

        private ICVSRemoteFile findRevison(ILogEntry[] allLogs, String predecessorRevision) throws TeamException {
            int i = 0;
            while (i < allLogs.length) {
                ILogEntry entry = allLogs[i];
                ICVSRemoteFile file = entry.getRemoteFile();
                if (file.getRevision().equals(predecessorRevision)) {
                    return file;
                }
                ++i;
            }
            return null;
        }

        private String getPredecessorRevision(String revision) {
            int[] digits = Util.convertToDigits((String)revision);
            int n = digits.length - 1;
            digits[n] = digits[n] - 1;
            StringBuffer buffer = new StringBuffer(revision.length());
            int i = 0;
            while (i < digits.length) {
                buffer.append(Integer.toString(digits[i]));
                if (i < digits.length - 1) {
                    buffer.append('.');
                }
                ++i;
            }
            return buffer.toString();
        }

        private boolean isBrancheRevision(String revision) {
            return Util.convertToDigits((String)revision).length > 2;
        }

        private String getBaseRevision(String revision) {
            int[] digits = Util.convertToDigits((String)revision);
            int length = digits.length - 1;
            if (length % 2 == 1) {
                --length;
            }
            StringBuffer buffer = new StringBuffer(revision.length());
            int i = 0;
            while (i < length) {
                buffer.append(Integer.toString(digits[i]));
                if (i < length - 1) {
                    buffer.append('.');
                }
                ++i;
            }
            return buffer.toString();
        }

        public synchronized void clearEntries(ICVSRemoteResource resource) {
            String remotePath = this.getFullPath(resource);
            this.entries.remove(remotePath);
        }

        public void handleLogEntryReceived(ILogEntry entry) {
            ICVSRemoteFile file = entry.getRemoteFile();
            String fullPath = this.getFullPath((ICVSRemoteResource)file);
            String revision = entry.getRevision();
            HashMap<String, ILogEntry> fileEntries = this.internalGetLogEntries(fullPath);
            if (fileEntries == null) {
                fileEntries = new HashMap<String, ILogEntry>();
                this.entries.put(fullPath, fileEntries);
            }
            fileEntries.put(revision, entry);
        }
    }
}

