/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sphinx.emf.mwe.dynamic.launching.ui;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.SWTFactory;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.emf.mwe2.runtime.workflow.Workflow;
import org.eclipse.jdt.core.IType;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.sphinx.emf.mwe.dynamic.internal.WorkflowInstanceFactory;
import org.eclipse.sphinx.emf.mwe.dynamic.launching.IWorkflowLaunchConfigurationConstants;
import org.eclipse.sphinx.emf.mwe.dynamic.launching.ui.internal.Activator;
import org.eclipse.sphinx.emf.mwe.dynamic.launching.ui.internal.messages.Messages;
import org.eclipse.sphinx.emf.mwe.dynamic.ui.util.WorkflowRunnerUIHelper;
import org.eclipse.sphinx.emf.mwe.dynamic.util.WorkflowRunnerHelper;
import org.eclipse.sphinx.platform.ui.fields.IField;
import org.eclipse.sphinx.platform.ui.groups.IGroupListener;
import org.eclipse.sphinx.platform.ui.groups.NameValueTableGroup;
import org.eclipse.sphinx.platform.util.PlatformLogUtil;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Text;

public class WorkflowLaunchConfigurationTab
extends AbstractLaunchConfigurationTab {
    private Image image;
    protected Text workflowText;
    protected Button browseWorkflowPushButton;
    protected Text modelText;
    protected Button browseModelPushButton;
    protected Button autoSaveCheckButton;
    protected NameValueTableGroup argumentsGroup;
    protected Button envAddButton;
    protected Button envEditButton;
    protected Button envRemoveButton;
    protected WorkflowRunnerHelper helper = new WorkflowRunnerHelper();
    protected WorkflowRunnerUIHelper uiHelper = new WorkflowRunnerUIHelper();

    public WorkflowLaunchConfigurationTab() {
        this.image = PDEPluginImages.DESC_MAIN_TAB.createImage();
    }

    public String getName() {
        return Messages.tab_workflow_name;
    }

    public Image getImage() {
        return this.image;
    }

    public void createControl(Composite parent) {
        Composite composite = SWTFactory.createComposite((Composite)parent, (int)1, (int)1, (int)1808);
        this.createWorkflowGroup(composite);
        this.createModelGroup(composite);
        this.createArgumentsGroup(composite);
        this.setControl((Control)composite);
    }

    protected void createWorkflowGroup(Composite parent) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)Messages.group_workflow_label, (int)2, (int)1, (int)768);
        this.workflowText = SWTFactory.createSingleText((Composite)group, (int)1);
        this.workflowText.addFocusListener((FocusListener)new AbstractFocusListener(){

            public void focusLost(FocusEvent e) {
                WorkflowLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
                WorkflowLaunchConfigurationTab.this.updateArguments();
            }
        });
        this.browseWorkflowPushButton = this.createPushButton((Composite)group, Messages.pushButton_browse_label, null);
        this.browseWorkflowPushButton.addSelectionListener((SelectionListener)new AbstractSelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                IType workflowType = WorkflowLaunchConfigurationTab.this.uiHelper.promptForWorkflowType();
                if (workflowType != null) {
                    WorkflowLaunchConfigurationTab.this.workflowText.setText(WorkflowLaunchConfigurationTab.this.helper.toWorkflowString(workflowType));
                }
                WorkflowLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
                WorkflowLaunchConfigurationTab.this.updateArguments();
            }
        });
    }

    protected void createModelGroup(Composite parent) {
        Group group = SWTFactory.createGroup((Composite)parent, (String)Messages.group_model_label, (int)2, (int)1, (int)768);
        this.modelText = SWTFactory.createSingleText((Composite)group, (int)1);
        this.modelText.addFocusListener((FocusListener)new AbstractFocusListener(){

            public void focusLost(FocusEvent e) {
                WorkflowLaunchConfigurationTab.this.autoSaveCheckButton.setEnabled(!WorkflowLaunchConfigurationTab.this.modelText.getText().isEmpty());
                WorkflowLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
        this.browseModelPushButton = this.createPushButton((Composite)group, Messages.pushButton_browse_label, null);
        this.browseModelPushButton.setEnabled(false);
        this.autoSaveCheckButton = this.createCheckButton((Composite)group, Messages.checkButton_autoSave_label);
        this.autoSaveCheckButton.setEnabled(false);
    }

    protected void createArgumentsGroup(Composite composite) {
        this.argumentsGroup = new NameValueTableGroup(Messages.group_arguments_label){

            public void setInput(Map<String, String> entries) {
                super.setInput(new HashMap<String, String>(entries));
            }
        };
        this.argumentsGroup.createContent(composite, 1, true);
        this.argumentsGroup.addGroupListener(new IGroupListener(){

            public void groupChanged(IField field) {
                WorkflowLaunchConfigurationTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        try {
            String workflow = configuration.getAttribute(IWorkflowLaunchConfigurationConstants.ATTR_WORKFLOW, "");
            this.workflowText.setText(workflow);
            String model = configuration.getAttribute(IWorkflowLaunchConfigurationConstants.ATTR_MODEL, "");
            this.modelText.setText(model);
            boolean autoSave = configuration.getAttribute(IWorkflowLaunchConfigurationConstants.ATTR_AUTO_SAVE, true);
            this.autoSaveCheckButton.setSelection(autoSave);
            Map arguments = configuration.getAttribute(IWorkflowLaunchConfigurationConstants.ATTR_ARGUMENTS, IWorkflowLaunchConfigurationConstants.ATTR_ARGUMENTS_DEFAULT);
            this.argumentsGroup.setInput(arguments);
            this.updateArguments();
        }
        catch (CoreException ex) {
            PlatformLogUtil.logAsError((Plugin)Activator.getPlugin(), (Object)((Object)ex));
        }
    }

    protected void updateArguments() {
        try {
            String workflowString = this.workflowText.getText();
            Object workflow = this.helper.toWorkflowObject(workflowString);
            WorkflowInstanceFactory factory = new WorkflowInstanceFactory();
            Workflow instance = factory.createWorkflowInstance(workflow);
            Map parameters = factory.getWorkflowParameters(instance);
            Map arguments = this.argumentsGroup.getInput();
            parameters.keySet().removeAll(arguments.keySet());
            for (String missingArgument : parameters.keySet()) {
                this.argumentsGroup.addEntry(missingArgument, "");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IWorkflowLaunchConfigurationConstants.ATTR_WORKFLOW, "");
        configuration.setAttribute(IWorkflowLaunchConfigurationConstants.ATTR_MODEL, "");
        configuration.setAttribute(IWorkflowLaunchConfigurationConstants.ATTR_AUTO_SAVE, true);
        configuration.setAttribute(IWorkflowLaunchConfigurationConstants.ATTR_ARGUMENTS, IWorkflowLaunchConfigurationConstants.ATTR_ARGUMENTS_DEFAULT);
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        configuration.setAttribute(IWorkflowLaunchConfigurationConstants.ATTR_WORKFLOW, this.workflowText.getText());
        configuration.setAttribute(IWorkflowLaunchConfigurationConstants.ATTR_MODEL, this.modelText.getText());
        configuration.setAttribute(IWorkflowLaunchConfigurationConstants.ATTR_AUTO_SAVE, this.autoSaveCheckButton.getSelection());
        configuration.setAttribute(IWorkflowLaunchConfigurationConstants.ATTR_ARGUMENTS, this.argumentsGroup.getInput());
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        this.setErrorMessage(null);
        this.setMessage(null);
        String workflowString = this.workflowText.getText();
        if (workflowString.isEmpty()) {
            this.setErrorMessage(Messages.error_workflowNotSpecified);
            return false;
        }
        try {
            this.helper.toWorkflowObject(workflowString);
        }
        catch (Exception ex) {
            this.setErrorMessage(ex.getLocalizedMessage());
            return false;
        }
        String modelURIString = this.modelText.getText();
        try {
            this.helper.toModelURIObject(modelURIString);
        }
        catch (Exception ex) {
            this.setErrorMessage(ex.getLocalizedMessage());
            return false;
        }
        return true;
    }

    public void dispose() {
        this.image.dispose();
        super.dispose();
    }

    protected static abstract class AbstractFocusListener
    implements FocusListener {
        protected AbstractFocusListener() {
        }

        public void focusGained(FocusEvent e) {
        }
    }

    protected static abstract class AbstractSelectionListener
    implements SelectionListener {
        protected AbstractSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

