/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sapphire.internal;

import java.util.Set;
import org.eclipse.sapphire.ListProperty;
import org.eclipse.sapphire.PossibleValues;
import org.eclipse.sapphire.PossibleValuesService;
import org.eclipse.sapphire.PropertyDef;
import org.eclipse.sapphire.ValueProperty;
import org.eclipse.sapphire.modeling.CapitalizationType;
import org.eclipse.sapphire.services.ServiceCondition;
import org.eclipse.sapphire.services.ServiceContext;

public final class StaticPossibleValuesService
extends PossibleValuesService {
    private String[] values;

    @Override
    protected void initPossibleValuesService() {
        PropertyDef pdef = this.context(PropertyDef.class);
        PossibleValues a = pdef.getAnnotation(PossibleValues.class);
        this.values = a.values();
        String invalidValueMessage = a.invalidValueMessage();
        if (invalidValueMessage.length() > 0) {
            this.invalidValueMessage = pdef.getLocalizationService().text(invalidValueMessage, CapitalizationType.NO_CAPS, false);
        }
        this.invalidValueSeverity = a.invalidValueSeverity();
        this.ordered = a.ordered();
    }

    @Override
    protected void compute(Set<String> values) {
        String[] stringArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            values.add(value);
            ++n2;
        }
    }

    public static final class ListPropertyCondition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            PropertyDef property = context.find(PropertyDef.class);
            return property instanceof ListProperty && property.hasAnnotation(PossibleValues.class) && property.getAnnotation(PossibleValues.class).values().length > 0;
        }
    }

    public static final class ValuePropertyCondition
    extends ServiceCondition {
        @Override
        public boolean applicable(ServiceContext context) {
            PropertyDef property = context.find(PropertyDef.class);
            return property instanceof ValueProperty && property.hasAnnotation(PossibleValues.class) && property.getAnnotation(PossibleValues.class).values().length > 0;
        }
    }
}

