/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.statics.rcp;

import com.google.common.base.Function;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IInitializer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.codeassist.InternalCompletionProposal;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.recommenders.completion.rcp.IProposalNameProvider;
import org.eclipse.recommenders.completion.rcp.IRecommendersCompletionContext;
import org.eclipse.recommenders.completion.rcp.processable.IProcessableProposal;
import org.eclipse.recommenders.completion.rcp.processable.OverlayImageProposalProcessor;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessor;
import org.eclipse.recommenders.completion.rcp.processable.ProposalProcessorManager;
import org.eclipse.recommenders.completion.rcp.processable.SessionProcessor;
import org.eclipse.recommenders.completion.rcp.processable.SimpleProposalProcessor;
import org.eclipse.recommenders.internal.statics.rcp.StaticsRcpPreferences;
import org.eclipse.recommenders.models.IUniqueName;
import org.eclipse.recommenders.models.UniqueTypeName;
import org.eclipse.recommenders.models.rcp.IProjectCoordinateProvider;
import org.eclipse.recommenders.rcp.SharedImages;
import org.eclipse.recommenders.rcp.utils.JdtUtils;
import org.eclipse.recommenders.statics.IStaticsModel;
import org.eclipse.recommenders.statics.IStaticsModelProvider;
import org.eclipse.recommenders.utils.Recommendation;
import org.eclipse.recommenders.utils.Recommendations;
import org.eclipse.recommenders.utils.Result;
import org.eclipse.recommenders.utils.names.IMethodName;
import org.eclipse.recommenders.utils.names.VmMethodName;
import org.eclipse.recommenders.utils.rcp.Formatting;

public class StaticsCompletionSessionProcessor
extends SessionProcessor {
    private final Provider<IProjectCoordinateProvider> pcProvider;
    private final IStaticsModelProvider modelProvider;
    private final IProposalNameProvider methodNameProvider;
    private final StaticsRcpPreferences prefs;
    private final OverlayImageProposalProcessor overlayProcessor;
    private Map<IMethodName, Double> recommendations;

    @Inject
    public StaticsCompletionSessionProcessor(Provider<IProjectCoordinateProvider> pcProvider, IStaticsModelProvider modelProvider, IProposalNameProvider methodNameProvider, SharedImages images, StaticsRcpPreferences prefs) {
        this.pcProvider = pcProvider;
        this.modelProvider = modelProvider;
        this.methodNameProvider = methodNameProvider;
        this.prefs = prefs;
        this.overlayProcessor = new OverlayImageProposalProcessor(images.getDescriptor((SharedImages.ImageResource)SharedImages.Images.OVR_STAR), 0);
    }

    public boolean startSession(IRecommendersCompletionContext context) {
        HashMultimap proposals = HashMultimap.create();
        this.recommendations = Maps.newHashMap();
        for (CompletionProposal coreProposal : context.getProposals().values()) {
            InternalCompletionProposal internalProposal;
            Binding binding;
            if (coreProposal == null || !this.isStaticMethodCallInternalCompletionProposal(coreProposal) || !((binding = (internalProposal = (InternalCompletionProposal)coreProposal).getBinding()) instanceof MethodBinding)) continue;
            MethodBinding methodBinding = (MethodBinding)binding;
            if (methodBinding.declaringClass == null) continue;
            proposals.put((Object)methodBinding.declaringClass, (Object)coreProposal);
        }
        for (TypeBinding typeBinding : proposals.keySet()) {
            UniqueTypeName uniqueTypeName;
            IStaticsModel model;
            Result result;
            IType type = (IType)JdtUtils.createUnresolvedType((TypeBinding)typeBinding).orNull();
            if (type == null || !(result = ((IProjectCoordinateProvider)this.pcProvider.get()).tryToUniqueName(type)).isPresent() || (model = (IStaticsModel)this.modelProvider.acquireModel((IUniqueName)(uniqueTypeName = (UniqueTypeName)result.get())).orNull()) == null) continue;
            IJavaElement enclosingMethod = (IJavaElement)context.getEnclosingElement().orNull();
            if (enclosingMethod != null) {
                switch (enclosingMethod.getElementType()) {
                    case 9: {
                        IMethodName enclosingMethodName = (IMethodName)((IProjectCoordinateProvider)this.pcProvider.get()).toName((IMethod)enclosingMethod).orNull();
                        model.setEnclosingMethod(enclosingMethodName);
                        break;
                    }
                    case 10: {
                        IMethodName enclosingMethodName;
                        try {
                            int flags = ((IInitializer)enclosingMethod).getFlags();
                            enclosingMethodName = VmMethodName.get((String)"Lsome", (String)(Flags.isStatic((int)flags) ? "<clinit>()V" : "<init>()V"));
                            model.setEnclosingMethod(enclosingMethodName);
                        }
                        catch (JavaModelException javaModelException) {}
                        break;
                    }
                }
            }
            Iterable recommendations = Recommendations.filterRelevance((Iterable)Recommendations.top((Iterable)model.recommendCalls(), (int)this.prefs.maxNumberOfProposals), (double)(Math.max((double)this.prefs.minProposalPercentage, 0.01) / 100.0));
            for (Recommendation r : recommendations) {
                this.recommendations.put((IMethodName)r.getProposal(), r.getRelevance());
            }
            this.modelProvider.releaseModel((Object)model);
        }
        if (this.recommendations.isEmpty()) {
            return false;
        }
        if (this.recommendations.size() <= this.prefs.maxNumberOfProposals) {
            return true;
        }
        List topRecommendations = Ordering.natural().onResultOf((Function)new Function<Map.Entry<IMethodName, Double>, Double>(){

            public Double apply(Map.Entry<IMethodName, Double> recommendation) {
                return recommendation.getValue();
            }
        }).greatestOf(this.recommendations.entrySet(), this.prefs.maxNumberOfProposals);
        this.recommendations.clear();
        for (Map.Entry entry : topRecommendations) {
            this.recommendations.put((IMethodName)entry.getKey(), (Double)entry.getValue());
        }
        return true;
    }

    private boolean isStaticMethodCallInternalCompletionProposal(CompletionProposal p) {
        return p.getKind() == 6 && Flags.isStatic((int)p.getFlags()) && p instanceof InternalCompletionProposal;
    }

    public void process(IProcessableProposal proposal) throws Exception {
        CompletionProposal coreProposal = (CompletionProposal)proposal.getCoreProposal().orNull();
        if (coreProposal == null || coreProposal.getKind() != 6) {
            return;
        }
        IMethodName methodName = (IMethodName)this.methodNameProvider.toMethodName(coreProposal).orNull();
        if (methodName == null) {
            return;
        }
        Double p = this.recommendations.get(methodName);
        if (p == null) {
            return;
        }
        ProposalProcessorManager mgr = proposal.getProposalProcessorManager();
        int score = p < 0.01 ? 0 : 1 + (int)Math.rint(p * 100.0);
        String text = Formatting.toPercentage((double)p);
        mgr.addProcessor((ProposalProcessor)new SimpleProposalProcessor(score, text));
        if (this.prefs.decorateProposalIcon) {
            mgr.addProcessor((ProposalProcessor)this.overlayProcessor);
        }
    }
}

