/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.overrides;

import com.google.common.base.Optional;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.recommenders.models.IInputStreamTransformer;
import org.eclipse.recommenders.models.IUniqueName;
import org.eclipse.recommenders.overrides.IOverrideModel;
import org.eclipse.recommenders.overrides.IOverrideModelProvider;
import org.eclipse.recommenders.overrides.JayesOverrideModel;
import org.eclipse.recommenders.utils.IOUtils;
import org.eclipse.recommenders.utils.Openable;
import org.eclipse.recommenders.utils.Zips;
import org.eclipse.recommenders.utils.names.ITypeName;

public class SingleZipOverrideModelProvider
implements IOverrideModelProvider,
Openable {
    private final File models;
    private ZipFile zip;
    private Map<String, IInputStreamTransformer> transformers;

    public SingleZipOverrideModelProvider(File models, Map<String, IInputStreamTransformer> transformers) {
        this.models = models;
        this.transformers = transformers;
    }

    public void open() throws IOException {
        Zips.readFully((File)this.models);
        this.zip = new ZipFile(this.models);
    }

    public void close() throws IOException {
        Zips.closeQuietly((ZipFile)this.zip);
    }

    public Set<ITypeName> acquireableTypes() {
        Set acquireableTypesSet = Zips.types(this.zip.entries(), (String)".json");
        for (Map.Entry<String, IInputStreamTransformer> transformer : this.transformers.entrySet()) {
            acquireableTypesSet.addAll(Zips.types(this.zip.entries(), (String)(".json." + transformer.getKey())));
        }
        return acquireableTypesSet;
    }

    public void releaseModel(IOverrideModel value) {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<IOverrideModel> acquireModel(IUniqueName<ITypeName> key) {
        InputStream stream = null;
        try {
            String path = Zips.path((ITypeName)((ITypeName)key.getName()), (String)".json");
            stream = (InputStream)this.getInputStream(this.zip, path).orNull();
            if (stream == null) {
                Optional optional = Optional.absent();
                IOUtils.closeQuietly((Closeable)stream);
                return optional;
            }
            Optional optional = Optional.of((Object)JayesOverrideModel.load(stream, (ITypeName)key.getName()));
            IOUtils.closeQuietly((Closeable)stream);
            return optional;
        }
        catch (IOException iOException) {
            Optional optional = Optional.absent();
            return optional;
        }
        finally {
            IOUtils.closeQuietly(stream);
        }
    }

    private Optional<InputStream> getInputStream(ZipFile zip, String path) throws IOException {
        for (Map.Entry<String, IInputStreamTransformer> transformer : this.transformers.entrySet()) {
            ZipEntry toTransform = zip.getEntry(String.valueOf(path) + "." + transformer.getKey());
            if (toTransform == null) continue;
            return Optional.of((Object)transformer.getValue().transform(zip.getInputStream(toTransform)));
        }
        ZipEntry entry = zip.getEntry(path);
        if (entry == null) {
            return Optional.absent();
        }
        return Optional.of((Object)zip.getInputStream(entry));
    }
}

