/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.recommenders.internal.completion.rcp;

import com.google.common.annotations.Beta;
import org.eclipse.jdt.core.CompletionContext;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.text.java.FieldProposalInfo;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaMethodCompletionProposal;
import org.eclipse.jdt.internal.ui.text.java.MethodProposalInfo;
import org.eclipse.jdt.internal.ui.text.java.ParameterGuessingProposal;
import org.eclipse.jdt.internal.ui.text.java.ProposalInfo;
import org.eclipse.jdt.internal.ui.viewsupport.JavaElementImageProvider;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.recommenders.internal.completion.rcp.AccessibleCompletionProposal;
import org.eclipse.recommenders.utils.Checks;
import org.eclipse.swt.graphics.Image;

@Beta
public class JavaCompletionProposals {
    public static JavaCompletionProposal newLocalVariableRefProposal(AccessibleCompletionProposal localRef) {
        Checks.ensureEquals((Object)localRef.getKind(), (Object)5, (String)"Proposal kind is not a reference to a local variable.");
        String replacementString = String.valueOf(localRef.getCompletion());
        int replacementOffset = localRef.getReplaceStart();
        int replacementLength = localRef.getReplaceEnd() - localRef.getReplaceStart();
        StyledString displayString = new StyledString(String.valueOf(localRef.getName())).append(" : " + String.valueOf(localRef.getTypeName()), StyledString.QUALIFIER_STYLER);
        Image image = JavaPluginImages.get((String)"org.eclipse.jdt.ui.localvariable_obj.gif");
        int relevance = localRef.getRelevance();
        return new JavaCompletionProposal(replacementString, replacementOffset, replacementLength, image, displayString, relevance);
    }

    public static JavaCompletionProposal newFieldRef(AccessibleCompletionProposal fieldRef) {
        Checks.ensureEquals((Object)fieldRef.getKind(), (Object)2, (String)"Proposal kind is not a reference to a field.");
        String replacementString = String.valueOf(fieldRef.getCompletion());
        int replacementStart = fieldRef.getReplaceStart();
        int replacementLength = fieldRef.getReplaceEnd() - replacementStart;
        String fieldName = String.valueOf(fieldRef.getName());
        String typeName = String.valueOf(fieldRef.getTypeName());
        StyledString displayString = new StyledString(fieldName).append(" : " + typeName, StyledString.QUALIFIER_STYLER);
        Image image = JavaElementImageProvider.getFieldImageDescriptor((boolean)false, (int)fieldRef.getFlags()).createImage();
        JavaCompletionProposal p = new JavaCompletionProposal(replacementString, replacementStart, replacementLength, image, displayString, fieldRef.getRelevance());
        IJavaProject project = (IJavaProject)fieldRef.getData(IJavaProject.class).orNull();
        if (project != null) {
            p.setProposalInfo((ProposalInfo)new FieldProposalInfo(project, (CompletionProposal)fieldRef));
        }
        return p;
    }

    public static JavaMethodCompletionProposal newMethodRef(AccessibleCompletionProposal methodRef, JavaContentAssistInvocationContext context) {
        CompletionContext coreContext = context.getCoreContext();
        Object res = coreContext != null && coreContext.isExtended() ? new ParameterGuessingProposal((CompletionProposal)methodRef, context, coreContext, true) : new JavaMethodCompletionProposal((CompletionProposal)methodRef, context);
        IJavaProject project = (IJavaProject)methodRef.getData(IJavaProject.class).orNull();
        if (project != null) {
            res.setProposalInfo((ProposalInfo)new MethodProposalInfo(project, (CompletionProposal)methodRef));
        }
        return res;
    }
}

