/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rcptt.ctx.preferences.ui;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.databinding.EMFObservables;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.jface.databinding.swt.SWTObservables;
import org.eclipse.jface.databinding.viewers.IViewerObservableList;
import org.eclipse.jface.databinding.viewers.ViewersObservables;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.EditingSupport;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.rcptt.core.model.ModelException;
import org.eclipse.rcptt.core.scenario.Context;
import org.eclipse.rcptt.ctx.preferences.ui.wizard.PreferencesAddWizard;
import org.eclipse.rcptt.ctx.preferences.ui.wizard.PreferencesImportWizard;
import org.eclipse.rcptt.internal.preferences.PrefUtils;
import org.eclipse.rcptt.internal.ui.Images;
import org.eclipse.rcptt.internal.ui.Q7UIPlugin;
import org.eclipse.rcptt.preferences.ListPrefData;
import org.eclipse.rcptt.preferences.PrefData;
import org.eclipse.rcptt.preferences.PrefNode;
import org.eclipse.rcptt.preferences.PreferencesContext;
import org.eclipse.rcptt.preferences.PreferencesPackage;
import org.eclipse.rcptt.preferences.SecurePrefNode;
import org.eclipse.rcptt.preferences.SettingsNode;
import org.eclipse.rcptt.preferences.StringPrefData;
import org.eclipse.rcptt.ui.commons.listcelleditor.StringListCellEditor;
import org.eclipse.rcptt.ui.context.BaseContextEditor;
import org.eclipse.rcptt.ui.controls.SectionWithComposite;
import org.eclipse.rcptt.ui.editors.EditorHeader;
import org.eclipse.rcptt.ui.editors.IQ7Editor;
import org.eclipse.rcptt.ui.utils.UIContentAdapter;
import org.eclipse.rcptt.ui.utils.WorkbenchUtils;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class PreferencesContextEditor
extends BaseContextEditor {
    private TreeViewer viewer;
    private EContentAdapter adapter;

    public PreferencesContext getContextElement() {
        try {
            return (PreferencesContext)super.getElement().getNamedElement();
        }
        catch (ModelException e) {
            Q7UIPlugin.log((Throwable)e);
            return null;
        }
    }

    public Control create(Composite parent, FormToolkit toolkit, IWorkbenchSite site, EditorHeader header) {
        Section section = new SectionWithComposite("Preferences", 322).numColumns(2).create(parent, toolkit);
        Composite composite = (Composite)section.getClient();
        Button cleanPreferences = toolkit.createButton(composite, "Clear preferences", 32);
        this.dbc.bindValue((IObservableValue)SWTObservables.observeSelection((Control)cleanPreferences), EMFObservables.observeValue((EObject)this.getContextElement(), (EStructuralFeature)PreferencesPackage.Literals.PREFERENCES_CONTEXT__CLEAN_PREFERENCES));
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)cleanPreferences);
        this.createTree(composite, toolkit);
        Composite panel = this.createPanel(composite, toolkit);
        GridDataFactory.fillDefaults().grab(false, true).applyTo((Control)panel);
        return section;
    }

    private Tree createTree(Composite parent, FormToolkit toolkit) {
        Tree tree = new Tree(parent, 67586);
        GridDataFactory.fillDefaults().grab(true, true).hint(100, 50).applyTo((Control)tree);
        tree.setHeaderVisible(true);
        toolkit.adapt((Composite)tree);
        tree.setLinesVisible(true);
        this.viewer = new TreeViewer(tree);
        this.viewer.setContentProvider((IContentProvider)new PreferencesContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new PreferencesLabelProvider());
        TreeColumn nodeColumn = new TreeColumn(tree, 16384);
        nodeColumn.setText("Preference");
        nodeColumn.setWidth(350);
        TreeColumn valueColumn = new TreeColumn(tree, 16384);
        valueColumn.setText("Value");
        valueColumn.setWidth(200);
        TreeViewerColumn column = new TreeViewerColumn(this.viewer, valueColumn);
        column.setEditingSupport((EditingSupport)new PreferenceEditingSupport(this.viewer));
        column.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                if (element instanceof StringPrefData) {
                    return ((StringPrefData)element).getValue();
                }
                if (element instanceof ListPrefData) {
                    return PreferencesContextEditor.this.getValuesRepresentation((ListPrefData)element);
                }
                return null;
            }
        });
        this.viewer.setInput((Object)this.getContextElement());
        this.adapter = new UIContentAdapter(){

            protected void changed(Notification notification) {
                PreferencesContextEditor.this.viewer.refresh();
            }
        };
        this.getContextElement().eAdapters().add((Object)this.adapter);
        this.viewer.getControl().addKeyListener(new KeyListener(){

            public void keyReleased(KeyEvent e) {
            }

            public void keyPressed(KeyEvent e) {
                if ('\u007f' == e.character && e.stateMask == 0 && !PreferencesContextEditor.this.viewer.getSelection().isEmpty()) {
                    PreferencesContextEditor.this.removeSelected();
                    e.doit = false;
                }
            }
        });
        return tree;
    }

    private Composite createPanel(Composite parent, FormToolkit toolkit) {
        Composite panel = toolkit.createComposite(parent);
        GridLayoutFactory.fillDefaults().applyTo(panel);
        Button importButton = toolkit.createButton(panel, "Import Preferences...", 8);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)importButton);
        importButton.setImage(Images.getImageDescriptor((String)"icons/preferences/import.gif").createImage());
        importButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesImportWizard wizard = new PreferencesImportWizard((IQ7Editor<Context>)PreferencesContextEditor.this);
                WizardDialog dialog = new WizardDialog(WorkbenchUtils.getShell(), (IWizard)wizard);
                dialog.open();
            }
        });
        Button addButton = toolkit.createButton(panel, "Add...", 8);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)addButton);
        addButton.setImage(Images.getImageDescriptor((String)"icons/preferences/import.gif").createImage());
        addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesAddWizard wizard = new PreferencesAddWizard((IQ7Editor<Context>)PreferencesContextEditor.this);
                WizardDialog dialog = new WizardDialog(WorkbenchUtils.getShell(), (IWizard)wizard);
                dialog.open();
            }
        });
        Button removeButton = toolkit.createButton(panel, "Remove", 8);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)removeButton);
        removeButton.setImage(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_ETOOL_DELETE").createImage());
        this.dbc.bindValue((IObservableValue)SWTObservables.observeEnabled((Control)removeButton), (IObservableValue)new ComputedValue(){

            protected Object calculate() {
                IViewerObservableList selection = ViewersObservables.observeMultiSelection((Viewer)PreferencesContextEditor.this.viewer);
                return !selection.isEmpty();
            }
        });
        removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                PreferencesContextEditor.this.removeSelected();
            }
        });
        return panel;
    }

    protected void removeSelected() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        for (Object o : selection.toList()) {
            if (o instanceof SettingsNode) {
                this.getContextElement().setSettings(null);
                this.viewer.remove(o);
                continue;
            }
            PrefUtils.remove((EObject)((EObject)o));
        }
    }

    private String getValuesRepresentation(ListPrefData listPrefData) {
        StringBuilder builder = new StringBuilder();
        Iterator it = listPrefData.getValues().iterator();
        while (it.hasNext()) {
            builder.append((String)it.next());
            if (!it.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    public void addContext(PreferencesContext context) {
        PreferencesContext current = this.getContextElement();
        this.mergePrefNodes((EList<PrefNode>)current.getContent(), (EList<PrefNode>)context.getContent());
    }

    private void mergePrefNodes(EList<PrefNode> content, EList<PrefNode> newContent) {
        ArrayList<PrefNode> toAdd = new ArrayList<PrefNode>();
        for (PrefNode prefNode : newContent) {
            boolean newNode = true;
            for (PrefNode oldPrefNode : content) {
                if (!oldPrefNode.getName().equals(prefNode.getName())) continue;
                newNode = false;
                this.mergePrefNodes((EList<PrefNode>)oldPrefNode.getChilds(), (EList<PrefNode>)prefNode.getChilds());
                this.mergePrefData(prefNode, oldPrefNode);
            }
            if (!newNode) continue;
            toAdd.add(prefNode);
        }
        content.addAll(toAdd);
    }

    private void mergePrefData(PrefNode prefNode, PrefNode oldPrefNode) {
        EList data = oldPrefNode.getData();
        EList newData = prefNode.getData();
        ArrayList<PrefData> toAdd = new ArrayList<PrefData>();
        for (PrefData prefData : newData) {
            boolean ndata = true;
            for (PrefData oldPrefData : data) {
                if (!oldPrefData.getKey().equals(prefData.getKey()) || !oldPrefData.eClass().equals(prefData.eClass())) continue;
                ndata = false;
                if (oldPrefData instanceof ListPrefData) {
                    EList oldValues = ((ListPrefData)oldPrefData).getValues();
                    oldValues.clear();
                    oldValues.addAll((Collection)((ListPrefData)prefData).getValues());
                    continue;
                }
                if (!(oldPrefData instanceof StringPrefData)) continue;
                ((StringPrefData)oldPrefData).setValue(((StringPrefData)prefData).getValue());
            }
            if (!ndata) continue;
            toAdd.add(prefData);
        }
        data.addAll(toAdd);
    }

    private class PreferenceEditingSupport
    extends EditingSupport {
        public PreferenceEditingSupport(TreeViewer treeViewer) {
            super((ColumnViewer)treeViewer);
        }

        protected boolean canEdit(Object element) {
            return element instanceof StringPrefData || element instanceof ListPrefData;
        }

        protected CellEditor getCellEditor(Object element) {
            if (element instanceof StringPrefData) {
                return new TextCellEditor((Composite)this.getViewer().getControl());
            }
            if (element instanceof ListPrefData) {
                ListPrefData listPrefData = (ListPrefData)element;
                return new StringListCellEditor((Composite)this.getViewer().getControl(), (List)listPrefData.getValues(), listPrefData.getKey());
            }
            return null;
        }

        protected Object getValue(Object element) {
            if (element instanceof StringPrefData) {
                return ((StringPrefData)element).getValue();
            }
            if (element instanceof ListPrefData) {
                return PreferencesContextEditor.this.getValuesRepresentation((ListPrefData)element);
            }
            return null;
        }

        protected void setValue(Object element, Object value) {
            if (element instanceof StringPrefData) {
                String input = (String)value;
                StringPrefData prefData = (StringPrefData)element;
                if (!input.equals(prefData.getValue())) {
                    prefData.setValue(input);
                }
            } else if (element instanceof ListPrefData) {
                ListPrefData listPrefData = (ListPrefData)element;
                List newValues = (List)value;
                listPrefData.getValues().clear();
                for (String newVal : newValues) {
                    listPrefData.getValues().add((Object)newVal);
                }
            }
        }
    }

    private class PreferencesContentProvider
    implements ITreeContentProvider {
        private PreferencesContentProvider() {
        }

        public boolean hasChildren(Object element) {
            PrefNode prefNode;
            return element instanceof PrefNode && ((prefNode = (PrefNode)element).getChilds().size() > 0 || prefNode.getData().size() > 0);
        }

        public Object[] getChildren(Object element) {
            if (element instanceof PrefNode) {
                PrefNode prefNode = (PrefNode)element;
                ArrayList<PrefData> result = new ArrayList<PrefData>();
                result.addAll((Collection<PrefData>)prefNode.getChilds());
                if (result.size() > 0) {
                    Collections.sort(result, new Comparator<Object>(){

                        @Override
                        public int compare(Object o1, Object o2) {
                            return ((PrefNode)o1).getName().compareTo(((PrefNode)o2).getName());
                        }
                    });
                }
                result.addAll(this.getSortedPrefData(prefNode));
                if (result.size() > 0) {
                    return result.toArray();
                }
            }
            return null;
        }

        private List<PrefData> getSortedPrefData(PrefNode prefNode) {
            ArrayList<PrefData> result = new ArrayList<PrefData>();
            result.addAll((Collection<PrefData>)prefNode.getData());
            if (result.size() > 0) {
                Collections.sort(result, new Comparator<PrefData>(){

                    @Override
                    public int compare(PrefData o1, PrefData o2) {
                        return o1.getKey().compareTo(o2.getKey());
                    }
                });
            }
            return result;
        }

        public Object[] getElements(Object inputElement) {
            PreferencesContext context = (PreferencesContext)inputElement;
            ArrayList<SettingsNode> result = new ArrayList<SettingsNode>();
            result.addAll((Collection<SettingsNode>)context.getContent());
            if (context.getSettings() != null) {
                result.add(context.getSettings());
            }
            return result.toArray();
        }

        public Object getParent(Object element) {
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class PreferencesLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        private PreferencesLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                if (element instanceof SettingsNode) {
                    return Images.getImage((String)"icons/preferences/settings.gif");
                }
                if (element instanceof SecurePrefNode) {
                    return Images.getImage((String)"icons/preferences/secure_pref_node.gif");
                }
                if (element instanceof PrefNode) {
                    PrefNode prefNode = (PrefNode)element;
                    if (this.isRootNode(prefNode)) {
                        if ("project".equals(prefNode.getName())) {
                            return Images.getImage((String)"icons/preferences/scope_project.gif");
                        }
                        if ("instance".equals(prefNode.getName())) {
                            return Images.getImage((String)"icons/preferences/scope_instance.gif");
                        }
                        return Images.getImage((String)"icons/preferences/scope_unknown.gif");
                    }
                    return Images.getImage((String)"icons/preferences/pref_node.gif");
                }
                return Images.getImage((String)"icons/preferences/pref_data.gif");
            }
            return null;
        }

        private boolean isRootNode(PrefNode prefNode) {
            PreferencesContext context = PreferencesContextEditor.this.getContextElement();
            for (PrefNode node : context.getContent()) {
                if (!node.equals(prefNode)) continue;
                return true;
            }
            return false;
        }

        public String getColumnText(Object element, int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    if (element instanceof PrefNode) {
                        PrefNode prefNode = (PrefNode)element;
                        if (this.isRootNode(prefNode) && prefNode.getName().equals("instance")) {
                            return "general";
                        }
                        return prefNode.getName();
                    }
                    if (!(element instanceof PrefData)) break;
                    return ((PrefData)element).getKey();
                }
            }
            return null;
        }
    }
}

