/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.model.elements;

import java.util.List;
import org.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;
import org.eclipse.php.phpunit.model.connection.MessageEventType;
import org.eclipse.php.phpunit.model.connection.MessageTest;
import org.eclipse.php.phpunit.model.elements.PHPUnitElement;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestException;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestGroup;

public class PHPUnitTest
extends PHPUnitElement {
    public static final int STATUS_STARTED = 0;
    public static final int STATUS_PASS = 1;
    public static final int STATUS_SKIP = 2;
    public static final int STATUS_INCOMPLETE = 3;
    public static final int STATUS_FAIL = 4;
    public static final int STATUS_ERROR = 5;
    public static final String METHOD_SEPARATOR = "::";
    protected PHPUnitTestException exception = null;
    protected List<PHPUnitElement> warnings = null;
    protected String name = "";
    protected int status = 0;
    protected double time = 0.0;

    public PHPUnitTest(MessageTest test, PHPUnitTestGroup parent, RemoteDebugger remoteDebugger) {
        super(test, parent, remoteDebugger);
        if (test != null) {
            this.processName(test.getName());
        }
    }

    protected void processName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getRunCount() {
        return 1;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setStatus(MessageEventType sStatus) {
        if (sStatus == MessageEventType.pass) {
            this.setStatus(1);
        } else if (sStatus == MessageEventType.skip) {
            this.setStatus(2);
        } else if (sStatus == MessageEventType.incomplete) {
            this.setStatus(3);
        } else if (sStatus == MessageEventType.fail) {
            this.setStatus(4);
        } else if (sStatus == MessageEventType.error) {
            this.setStatus(5);
        } else if (sStatus == MessageEventType.start) {
            this.setStatus(0);
        }
    }

    public String getFilterName() {
        return this.getName();
    }

    public double getTime() {
        return this.time;
    }

    public void setTime(double time) {
        if (this.parent instanceof PHPUnitTest) {
            PHPUnitTest p = (PHPUnitTest)this.parent;
            p.setTime(p.time - this.time + time);
        }
        this.time = time;
    }

    public PHPUnitTestException getException() {
        return this.exception;
    }

    public List<PHPUnitElement> getWarnings() {
        return this.warnings;
    }

    public void setException(PHPUnitTestException exception) {
        this.exception = exception;
    }

    public void setWarnings(List<PHPUnitElement> warnings) {
        this.warnings = warnings;
    }

    public String toString() {
        return String.valueOf(this.file) + ":" + String.valueOf(this.line) + "$" + this.name;
    }
}

