/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.processors;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.InstallableUnitProposal;
import org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.processors.DelegateProcessor;
import org.eclipse.pde.internal.genericeditor.target.extension.autocomplete.processors.Messages;
import org.eclipse.pde.internal.genericeditor.target.extension.model.LocationNode;
import org.eclipse.pde.internal.genericeditor.target.extension.model.RepositoryCache;
import org.eclipse.pde.internal.genericeditor.target.extension.model.TargetNode;
import org.eclipse.pde.internal.genericeditor.target.extension.model.UnitNode;
import org.eclipse.pde.internal.genericeditor.target.extension.model.xml.Parser;
import org.eclipse.pde.internal.genericeditor.target.extension.p2.UpdateJob;

public class AttributeValueCompletionProcessor
extends DelegateProcessor {
    private String prefix;
    private String acKey;
    private int offset;

    public AttributeValueCompletionProcessor(String prefix, String acKey, int offset) {
        this.prefix = prefix;
        this.acKey = acKey;
        this.offset = offset;
    }

    @Override
    public ICompletionProposal[] getCompletionProposals() {
        Parser parser = Parser.getDefault();
        TargetNode rootNode = parser.getRootNode();
        if (rootNode == null) {
            return new ICompletionProposal[0];
        }
        UnitNode node = rootNode.getEnclosingUnit(this.offset);
        boolean replaceId = false;
        if ("id".equalsIgnoreCase(this.acKey) && node != null) {
            LocationNode location = node.getParent();
            String repoLocation = location.getRepositoryLocation();
            if (repoLocation == null) {
                return this.getErrorCompletion();
            }
            RepositoryCache cache = RepositoryCache.getDefault();
            if (!cache.isUpToDate(repoLocation)) {
                this.scheduleUpdateJob(location);
                return this.getInformativeProposal();
            }
            List<UnitNode> units = cache.getUnitsByPrefix(repoLocation, this.prefix);
            replaceId = !"".equals(node.getId());
            return this.convertToProposals(units, replaceId);
        }
        boolean replaceVersion = false;
        if ("version".equalsIgnoreCase(this.acKey) && node != null) {
            LocationNode location = node.getParent();
            String repoLocation = location.getRepositoryLocation();
            if (repoLocation == null) {
                return this.getErrorCompletion();
            }
            RepositoryCache cache = RepositoryCache.getDefault();
            if (!cache.isUpToDate(repoLocation)) {
                this.scheduleUpdateJob(location);
                return this.getInformativeProposal();
            }
            List<UnitNode> byPrefix = cache.getUnitsByPrefix(repoLocation, node.getId());
            List<String> versions = byPrefix.get(0).getAvailableVersions();
            replaceVersion = !"".equals(node.getVersion());
            return this.convertToVersionProposals(versions, replaceVersion);
        }
        return new ICompletionProposal[0];
    }

    private void scheduleUpdateJob(LocationNode location) {
        UpdateJob job = new UpdateJob(location);
        job.setUser(true);
        job.schedule();
    }

    private ICompletionProposal[] convertToVersionProposals(List<String> versions, boolean replace) {
        ArrayList<String> dest = new ArrayList<String>();
        dest.addAll(versions);
        if (!versions.contains("0.0.0")) {
            dest.add("0.0.0");
        }
        ArrayList<InstallableUnitProposal> result = new ArrayList<InstallableUnitProposal>();
        for (String version : dest) {
            if (version == null || !version.startsWith(this.prefix)) continue;
            InstallableUnitProposal proposal = new InstallableUnitProposal(version, this.offset, this.prefix.length(), replace);
            result.add(proposal);
        }
        return result.toArray(new ICompletionProposal[result.size()]);
    }

    private ICompletionProposal[] convertToProposals(List<UnitNode> units, boolean replace) {
        ArrayList<InstallableUnitProposal> result = new ArrayList<InstallableUnitProposal>();
        for (UnitNode unit : units) {
            InstallableUnitProposal proposal = new InstallableUnitProposal(unit.getId(), this.offset, this.prefix.length(), replace);
            result.add(proposal);
        }
        return result.toArray(new ICompletionProposal[result.size()]);
    }

    private ICompletionProposal[] getInformativeProposal() {
        String displayString = Messages.AttributeValueCompletionProcessor_StartedJob;
        CompletionProposal p = new CompletionProposal("", this.offset, 0, 0, null, displayString, null, null);
        return new ICompletionProposal[]{p};
    }

    private ICompletionProposal[] getErrorCompletion() {
        String replacementString = Messages.AttributeValueCompletionProcessor_RepositoryRequired;
        return new ICompletionProposal[]{new CompletionProposal("", this.offset, 0, 0, null, replacementString, null, null)};
    }
}

