/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.properties.editors;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.papyrus.infra.properties.ui.widgets.AbstractPropertyEditor;
import org.eclipse.papyrus.infra.widgets.creation.ReferenceValueFactory;
import org.eclipse.papyrus.infra.widgets.editors.AbstractValueEditor;
import org.eclipse.papyrus.infra.widgets.providers.IStaticContentProvider;
import org.eclipse.papyrus.infra.widgets.util.INameResolutionHelper;
import org.eclipse.papyrus.uml.properties.widgets.AutoCompleteReferenceDialog;
import org.eclipse.swt.widgets.Composite;

public class AutoCompletePropertyEditor
extends AbstractPropertyEditor {
    protected AutoCompleteReferenceDialog editor;
    protected ReferenceValueFactory factory;

    public AutoCompletePropertyEditor(Composite parent, int style) {
        this.editor = this.createReferenceDialog(parent, style);
        this.setEditor((AbstractValueEditor)this.editor);
    }

    protected AutoCompleteReferenceDialog createReferenceDialog(Composite parent, int style) {
        return new AutoCompleteReferenceDialog(parent, style);
    }

    protected void doBinding() {
        IStaticContentProvider provider = this.input.getContentProvider(this.propertyPath);
        ILabelProvider labelProvider = this.input.getLabelProvider(this.propertyPath);
        this.editor.setLabelProvider(labelProvider);
        this.editor.setContentProvider(provider);
        this.editor.setDirectCreation(this.input.getDirectCreation(this.propertyPath));
        this.editor.setMandatory(this.input.isMandatory(this.propertyPath));
        if (this.factory == null) {
            this.editor.setValueFactory(this.input.getValueFactory(this.propertyPath));
        } else {
            this.editor.setValueFactory(this.factory);
        }
        INameResolutionHelper nameResolutionHelper = this.input.getNameResolutionHelper(this.propertyPath);
        if (nameResolutionHelper != null) {
            this.editor.setNameResolutionHelper(nameResolutionHelper);
        }
        super.doBinding();
    }

    public void setFactory(ReferenceValueFactory factory) {
        this.factory = factory;
        this.editor.setValueFactory(factory);
    }

    public ReferenceValueFactory getFactory() {
        return this.factory;
    }
}

