/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.diagram.common.stereotype.display;

import org.eclipse.gmf.runtime.notation.BasicCompartment;
import org.eclipse.gmf.runtime.notation.DecorationNode;
import org.eclipse.gmf.runtime.notation.Node;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.diagram.common.stereotype.StereotypeLocationEnum;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.IStereotypeViewProvider;
import org.eclipse.papyrus.uml.diagram.common.stereotype.display.helper.StereotypeDisplayUtil;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Stereotype;

public class StereotypeViewProvider
implements IStereotypeViewProvider {
    private View mainView;
    private static StereotypeDisplayUtil helper = StereotypeDisplayUtil.getInstance();

    public StereotypeViewProvider(View mainView) {
        this.mainView = mainView;
    }

    @Override
    public View getProperty(Property property, Stereotype stereotype, Enum location) {
        View propertyView = null;
        if (StereotypeLocationEnum.IN_COMPARTMENT.equals(location)) {
            propertyView = this.getStereotypePropertyInCompartment(this.mainView, stereotype, property);
        } else if (StereotypeLocationEnum.IN_BRACE.equals(location)) {
            propertyView = this.getStereotypePropertyInBrace(this.mainView, stereotype, property);
        } else if (StereotypeLocationEnum.IN_COMMENT.equals(location)) {
            propertyView = this.getStereotypePropertyInComment(this.mainView, stereotype, property);
        }
        return propertyView;
    }

    @Override
    public View getCompartment(Stereotype stereotype, Enum location) {
        View compartmentView = null;
        if (StereotypeLocationEnum.IN_COMPARTMENT.equals(location)) {
            compartmentView = this.getStereotypeCompartmentInCompartment(this.mainView, stereotype);
        } else if (StereotypeLocationEnum.IN_BRACE.equals(location)) {
            compartmentView = this.getStereotypeCompartmentInBrace(this.mainView, stereotype);
        } else if (StereotypeLocationEnum.IN_COMMENT.equals(location)) {
            compartmentView = this.getStereotypeCompartmentInComment(this.mainView, stereotype);
        }
        return compartmentView;
    }

    @Override
    public View getLabel(Stereotype stereotype) {
        return this.getStereotypeLabel(this.mainView, stereotype);
    }

    public View getStereotypeLabel(View view, Stereotype stereotype) {
        DecorationNode label = helper.getStereotypeLabel(view, stereotype);
        return label;
    }

    public View getStereotypeCompartmentInCompartment(View view, Stereotype stereotype) {
        BasicCompartment compartment = helper.getStereotypeCompartment(view, stereotype);
        return compartment;
    }

    public View getStereotypeCompartmentInBrace(View view, Stereotype stereotype) {
        BasicCompartment compartment = helper.getStereotypeBraceCompartment(view, stereotype);
        return compartment;
    }

    public View getStereotypeCompartmentInComment(View view, Stereotype stereotype) {
        Node comment = helper.getStereotypeComment(view);
        BasicCompartment compartment = helper.getStereotypeCompartment((View)comment, stereotype);
        return compartment;
    }

    public View getStereotypePropertyInCompartment(View view, Stereotype stereotype, Property property) {
        DecorationNode propertyView = helper.getStereotypeProperty(view, stereotype, property);
        return propertyView;
    }

    public View getStereotypePropertyInBrace(View view, Stereotype stereotype, Property property) {
        DecorationNode propertyView = helper.getStereotypePropertyInBrace(view, stereotype, property);
        return propertyView;
    }

    public View getStereotypePropertyInComment(View view, Stereotype stereotype, Property property) {
        DecorationNode propertyView = helper.getStereotypePropertyInComment(view, stereotype, property);
        return propertyView;
    }
}

