/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.tasks.bugs.wizards;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.mylyn.internal.tasks.bugs.AttributeTaskMapper;
import org.eclipse.mylyn.internal.tasks.bugs.SupportRequest;
import org.eclipse.mylyn.internal.tasks.bugs.wizards.Messages;
import org.eclipse.mylyn.tasks.bugs.IProduct;
import org.eclipse.mylyn.tasks.bugs.ITaskContribution;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class ReportErrorPage
extends WizardPage {
    private final IStatus status;
    private final List<AttributeTaskMapper> contributions;
    private AttributeTaskMapper selectedContribution;
    private Combo contributionCombo;

    public ReportErrorPage(SupportRequest request, IStatus status) {
        super("reportError");
        this.status = status;
        this.contributions = new ArrayList<AttributeTaskMapper>();
        this.addContributions(request.getContributions());
        this.setTitle(Messages.ReportErrorPage_Report_as_Bug);
        this.setMessage(MessageFormat.format(Messages.ReportErrorPage_AN_UNEXPETED_ERROR_HAS_OCCURED_IN_PLUGIN, status.getPlugin()));
    }

    private void addContributions(List<ITaskContribution> contributions) {
        for (ITaskContribution contribution : contributions) {
            if (!((AttributeTaskMapper)contribution).isMappingComplete()) continue;
            this.contributions.add((AttributeTaskMapper)contribution);
        }
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite, 0);
        label.setText(Messages.ReportErrorPage_Details);
        Text text = new Text(composite, 2634);
        text.setText(this.status.getMessage());
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)text);
        label = new Label(composite, 0);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)label);
        this.selectedContribution = null;
        if (!this.contributions.isEmpty()) {
            final Button defaultRepositoryButton = new Button(composite, 16);
            defaultRepositoryButton.setSelection(true);
            this.selectedContribution = this.contributions.get(0);
            if (this.contributions.size() == 1) {
                defaultRepositoryButton.setText(NLS.bind((String)Messages.ReportErrorPage_Report_to, (Object)this.getLabel(this.selectedContribution)));
                GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)defaultRepositoryButton);
            } else {
                defaultRepositoryButton.setText(Messages.ReportErrorPage_Report_to_Label);
                this.contributionCombo = new Combo(composite, 8);
                for (AttributeTaskMapper contribution : this.contributions) {
                    this.contributionCombo.add(this.getLabel(contribution));
                }
                this.contributionCombo.select(0);
                this.contributionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        int selectionIndex = ReportErrorPage.this.contributionCombo.getSelectionIndex();
                        if (selectionIndex != -1) {
                            ReportErrorPage.this.selectedContribution = (AttributeTaskMapper)ReportErrorPage.this.contributions.get(selectionIndex);
                        }
                    }
                });
            }
            final Button selectRepositoryButton = new Button(composite, 16);
            selectRepositoryButton.setText(Messages.ReportErrorPage_Select_repository);
            GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)selectRepositoryButton);
            defaultRepositoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (defaultRepositoryButton.getSelection()) {
                        selectRepositoryButton.setSelection(false);
                    }
                    if (ReportErrorPage.this.contributionCombo != null) {
                        ReportErrorPage.this.contributionCombo.setEnabled(true);
                        ReportErrorPage.this.selectedContribution = (AttributeTaskMapper)ReportErrorPage.this.contributions.get(ReportErrorPage.this.contributionCombo.getSelectionIndex());
                    } else {
                        ReportErrorPage.this.selectedContribution = (AttributeTaskMapper)ReportErrorPage.this.contributions.get(0);
                    }
                    ReportErrorPage.this.getContainer().updateButtons();
                }
            });
            selectRepositoryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    if (selectRepositoryButton.getSelection()) {
                        defaultRepositoryButton.setSelection(false);
                        if (ReportErrorPage.this.contributionCombo != null) {
                            ReportErrorPage.this.contributionCombo.setEnabled(false);
                        }
                    }
                    ReportErrorPage.this.selectedContribution = null;
                    ReportErrorPage.this.getContainer().updateButtons();
                }
            });
        }
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
    }

    private String getLabel(AttributeTaskMapper contribution) {
        IProduct product = contribution.getProduct();
        if (product.getName() != null) {
            return NLS.bind((String)Messages.ReportErrorPage_Xprovider_Xproduct, (Object)product.getProvider().getName(), (Object)product.getName());
        }
        return product.getProvider().getName();
    }

    public boolean canFlipToNextPage() {
        return this.selectedContribution == null;
    }

    public AttributeTaskMapper getSelectedContribution() {
        return this.selectedContribution;
    }

    public boolean isPageComplete() {
        return true;
    }
}

