/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.commons.repositories.http.core;

import java.io.IOException;
import javax.net.ssl.TrustManager;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.AbstractHttpClient;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.ContentEncodingHttpClient;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.mylyn.commons.core.net.SslSupport;
import org.eclipse.mylyn.commons.core.net.TrustAllTrustManager;
import org.eclipse.mylyn.commons.core.operations.CancellableOperationMonitorThread;
import org.eclipse.mylyn.commons.core.operations.IOperationMonitor;
import org.eclipse.mylyn.commons.repositories.core.RepositoryLocation;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationCredentials;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationException;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationRequest;
import org.eclipse.mylyn.commons.repositories.core.auth.AuthenticationType;
import org.eclipse.mylyn.commons.repositories.core.auth.CertificateCredentials;
import org.eclipse.mylyn.commons.repositories.core.auth.UserCredentials;
import org.eclipse.mylyn.commons.repositories.http.core.DefaultHttpOperation;
import org.eclipse.mylyn.commons.repositories.http.core.HttpRequestProcessor;
import org.eclipse.mylyn.commons.repositories.http.core.HttpUtil;

public class CommonHttpClient {
    private boolean preemptiveAuthenticationEnabled;
    private boolean authenticated;
    private final ThreadLocal<BasicHttpContext> context = new ThreadLocal();
    private AuthenticationType<UserCredentials> httpAuthenticationType;
    private AbstractHttpClient httpClient;
    private final RepositoryLocation location;
    private CancellableOperationMonitorThread monitorThread = CancellableOperationMonitorThread.getInstance();

    public CommonHttpClient(RepositoryLocation location) {
        this.location = location;
        this.httpAuthenticationType = AuthenticationType.HTTP;
    }

    public <T> T executeGet(String requestPath, IOperationMonitor monitor, HttpRequestProcessor<T> processor) throws IOException {
        HttpGet request = new HttpGet(String.valueOf(this.location.getUrl()) + requestPath);
        DefaultHttpOperation<T> op = new DefaultHttpOperation<T>(this, (HttpRequestBase)request, processor);
        return op.run(monitor);
    }

    public HttpResponse execute(HttpRequestBase request, IOperationMonitor monitor) throws IOException {
        this.prepareRequest(request, monitor);
        return HttpUtil.execute(this.getHttpClient(), HttpUtil.createHost(request), this.getContext(), request, (IProgressMonitor)monitor);
    }

    public HttpContext getContext() {
        if (this.context.get() == null) {
            this.context.set(new BasicHttpContext(null));
        }
        return (HttpContext)this.context.get();
    }

    public AuthenticationType<UserCredentials> getHttpAuthenticationType() {
        return this.httpAuthenticationType;
    }

    public synchronized AbstractHttpClient getHttpClient() {
        if (this.httpClient == null) {
            this.httpClient = this.createHttpClient(null);
        }
        return this.httpClient;
    }

    public RepositoryLocation getLocation() {
        return this.location;
    }

    public boolean isAuthenticated() {
        return this.authenticated;
    }

    public boolean isPreemptiveAuthenticationEnabled() {
        return this.preemptiveAuthenticationEnabled;
    }

    public boolean needsAuthentication() {
        return !this.isAuthenticated() && this.getLocation().getCredentials(AuthenticationType.REPOSITORY, false) != null;
    }

    public void setAuthenticated(boolean authenticated) {
        this.authenticated = authenticated;
    }

    public void setHttpAuthenticationType(AuthenticationType<UserCredentials> httpAuthenticationType) {
        this.httpAuthenticationType = httpAuthenticationType;
    }

    public void setPreemptiveAuthenticationEnabled(boolean preemptiveAuthenticationEnabled) {
        this.preemptiveAuthenticationEnabled = preemptiveAuthenticationEnabled;
    }

    private void prepareRequest(HttpRequestBase request, IOperationMonitor monitor) {
        UserCredentials httpCredentials = (UserCredentials)this.location.getCredentials(this.httpAuthenticationType);
        if (httpCredentials != null) {
            HttpUtil.configureAuthentication(this.getHttpClient(), this.location, httpCredentials);
            if (this.isPreemptiveAuthenticationEnabled()) {
                HttpHost host = HttpUtil.createHost(request);
                Object authCache = this.getContext().getAttribute("http.auth.auth-cache");
                if (authCache == null) {
                    authCache = new BasicAuthCache();
                    this.getContext().setAttribute("http.auth.auth-cache", authCache);
                }
                if (authCache instanceof BasicAuthCache && ((BasicAuthCache)authCache).get(host) == null) {
                    ((BasicAuthCache)authCache).put(host, (AuthScheme)new BasicScheme());
                }
            }
        }
        HttpUtil.configureProxy(this.getHttpClient(), this.location);
        CertificateCredentials socketCredentials = (CertificateCredentials)this.location.getCredentials(AuthenticationType.CERTIFICATE);
        if (socketCredentials != null) {
            SslSupport support = new SslSupport(new TrustManager[]{new TrustAllTrustManager()}, socketCredentials.getKeyStoreFileName(), socketCredentials.getPassword(), socketCredentials.getKeyStoreType());
            request.getParams().setParameter(SslSupport.class.getName(), (Object)support);
        } else {
            this.getContext().removeAttribute("http.user-token");
        }
        this.getContext().setAttribute(HttpUtil.CONTEXT_KEY_MONITOR_THREAD, (Object)this.getMonitorThread());
    }

    protected void authenticate(IOperationMonitor monitor) throws IOException {
    }

    protected AbstractHttpClient createHttpClient(String userAgent) {
        ContentEncodingHttpClient client = new ContentEncodingHttpClient(){

            protected ClientConnectionManager createClientConnectionManager() {
                return CommonHttpClient.this.createHttpClientConnectionManager();
            }
        };
        HttpUtil.configureClient((AbstractHttpClient)client, userAgent);
        return client;
    }

    protected ClientConnectionManager createHttpClientConnectionManager() {
        return HttpUtil.getConnectionManager();
    }

    protected <T extends AuthenticationCredentials> T requestCredentials(AuthenticationRequest<AuthenticationType<T>> request, IProgressMonitor monitor) {
        return (T)this.location.requestCredentials(request, monitor);
    }

    protected void validate(HttpResponse response, IProgressMonitor monitor) throws AuthenticationException {
        int statusCode = response.getStatusLine().getStatusCode();
        if (statusCode == 401) {
            AuthenticationRequest request = new AuthenticationRequest(this.getLocation(), this.httpAuthenticationType);
            throw new AuthenticationException(HttpUtil.getStatusText(statusCode), request);
        }
        if (statusCode == 407) {
            AuthenticationRequest request = new AuthenticationRequest(this.getLocation(), AuthenticationType.PROXY);
            throw new AuthenticationException(HttpUtil.getStatusText(statusCode), request);
        }
    }

    public CancellableOperationMonitorThread getMonitorThread() {
        return this.monitorThread;
    }

    public void setMonitorThread(CancellableOperationMonitorThread monitorThread) {
        this.monitorThread = monitorThread;
    }
}

