/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.drivers.emf4atl.tcs.extractor;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.m2m.atl.dsls.tcs.extractor.ModelAdapter;
import org.eclipse.m2m.atl.engine.vm.nativelib.AMN;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMBoolean;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMCollection;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMEnumLiteral;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMInteger;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModel;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMModelElement;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMOclAny;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMReal;
import org.eclipse.m2m.atl.engine.vm.nativelib.ASMString;

public class ASMModelAdapter
implements ModelAdapter {
    public Object get(Object me, String propName) {
        ASMOclAny ret = AMN.get((ASMModelElement)((ASMModelElement)me), (String)propName);
        return this.asm2java(ret);
    }

    private Object asm2java(Object value) {
        if (value instanceof ASMCollection) {
            ArrayList<Object> newC = new ArrayList<Object>();
            Iterator i = ((ASMCollection)value).iterator();
            while (i.hasNext()) {
                newC.add(this.asm2java(i.next()));
            }
            return newC;
        }
        if (value instanceof ASMString) {
            return ((ASMString)value).getSymbol();
        }
        if (value instanceof ASMInteger) {
            return new Integer(((ASMInteger)value).getSymbol());
        }
        if (value instanceof ASMReal) {
            return new Double(((ASMReal)value).getSymbol());
        }
        if (value instanceof ASMBoolean) {
            return new Boolean(((ASMBoolean)value).getSymbol());
        }
        return value;
    }

    public boolean getBool(Object me, String propName) {
        return AMN.getBool((ASMModelElement)((ASMModelElement)me), (String)propName);
    }

    public boolean getBoolUndefinedIsFalse(Object me, String propName) {
        return AMN.getBoolUndefinedIsFalse((ASMModelElement)((ASMModelElement)me), (String)propName);
    }

    public Iterator getCol(Object me, String propName) {
        return AMN.getCol((ASMModelElement)((ASMModelElement)me), (String)propName);
    }

    public Set getElementsByType(Object model, String typeName) {
        return ((ASMModel)model).getElementsByType(typeName);
    }

    public int getInt(Object me, String propName) {
        return AMN.getInt((ASMModelElement)((ASMModelElement)me), (String)propName);
    }

    public Object getME(Object me, String propName) {
        return AMN.getME((ASMModelElement)((ASMModelElement)me), (String)propName);
    }

    public Object getMetaobject(Object me) {
        return ((ASMModelElement)me).getMetaobject();
    }

    public String getString(Object me, String propName) {
        return AMN.getString((ASMModelElement)((ASMModelElement)me), (String)propName);
    }

    public String getTypeName(Object me) {
        return AMN.getTypeName((ASMModelElement)((ASMModelElement)me));
    }

    public Object refImmediateComposite(Object me) {
        return ((ASMModelElement)me).refImmediateComposite();
    }

    public boolean isAModelElement(Object o) {
        return o instanceof ASMModelElement;
    }

    public Object getPropertyType(Object f, String propName) {
        return ((ASMModelElement)f).getPropertyType(propName);
    }

    public String getName(Object me) {
        return this.getString(me, "name");
    }

    public boolean isPrimitive(Object value) {
        return value instanceof String || value instanceof Boolean || value instanceof Double || value instanceof Integer;
    }

    public boolean isEnumLiteral(Object value) {
        return value instanceof ASMEnumLiteral;
    }

    public String getEnumLiteralName(Object me) {
        return ((ASMEnumLiteral)me).getName();
    }

    public String nextString(Iterator i) {
        return AMN.nextString((Iterator)i);
    }
}

