/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2e.scm.internal.wizards;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.apache.maven.model.Scm;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.m2e.core.ui.internal.actions.SelectionUtil;
import org.eclipse.m2e.core.ui.internal.wizards.AbstractMavenProjectWizard;
import org.eclipse.m2e.core.ui.internal.wizards.MavenProjectWizardLocationPage;
import org.eclipse.m2e.scm.MavenProjectScmInfo;
import org.eclipse.m2e.scm.ScmUrl;
import org.eclipse.m2e.scm.internal.Messages;
import org.eclipse.m2e.scm.internal.wizards.MavenCheckoutLocationPage;
import org.eclipse.m2e.scm.internal.wizards.MavenProjectCheckoutJob;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class MavenCheckoutWizard
extends AbstractMavenProjectWizard
implements IImportWizard,
INewWizard {
    private ScmUrl[] urls;
    private String parentUrl;
    private MavenCheckoutLocationPage scheckoutPage;
    private MavenProjectWizardLocationPage locationPage;

    public MavenCheckoutWizard() {
        this(null);
        this.setNeedsProgressMonitor(true);
    }

    public MavenCheckoutWizard(ScmUrl[] urls) {
        this.setUrls(urls);
        this.setNeedsProgressMonitor(true);
        this.setWindowTitle(Messages.MavenCheckoutWizard_title);
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        super.init(workbench, selection);
        this.selection = selection;
        ArrayList<ScmUrl> urls = new ArrayList<ScmUrl>();
        IAdapterManager adapterManager = Platform.getAdapterManager();
        Iterator it = selection.iterator();
        while (it.hasNext()) {
            ScmUrl url = (ScmUrl)adapterManager.getAdapter(it.next(), ScmUrl.class);
            if (url == null) continue;
            urls.add(url);
        }
        this.setUrls(urls.toArray(new ScmUrl[urls.size()]));
    }

    private void setUrls(ScmUrl[] urls) {
        if (urls != null && urls.length > 0) {
            this.urls = urls;
            this.parentUrl = this.getParentUrl(urls);
        }
    }

    private String getParentUrl(ScmUrl[] urls) {
        if (urls.length == 1) {
            return urls[0].getUrl();
        }
        String parent = urls[0].getParentUrl();
        int i = 1;
        while (parent != null && i < urls.length) {
            String url = urls[i].getParentUrl();
            if (!parent.equals(url)) {
                parent = null;
            }
            ++i;
        }
        return parent;
    }

    public void addPages() {
        this.scheckoutPage = new MavenCheckoutLocationPage(this.importConfiguration);
        this.scheckoutPage.setUrls(this.urls);
        this.scheckoutPage.setParent(this.parentUrl);
        this.locationPage = new MavenProjectWizardLocationPage(this.importConfiguration, Messages.MavenCheckoutWizard_location1, Messages.MavenCheckoutWizard_location2, this.workingSets);
        this.locationPage.setLocationPath(SelectionUtil.getSelectedLocation((IStructuredSelection)this.selection));
        this.addPage((IWizardPage)this.scheckoutPage);
        this.addPage((IWizardPage)this.locationPage);
    }

    public boolean canFinish() {
        if (this.scheckoutPage.isCheckoutAllProjects() && this.scheckoutPage.isPageComplete()) {
            return true;
        }
        return super.canFinish();
    }

    public boolean performFinish() {
        if (!this.canFinish()) {
            return false;
        }
        boolean checkoutAllProjects = this.scheckoutPage.isCheckoutAllProjects();
        Scm[] scms = this.scheckoutPage.getScms();
        final ArrayList<MavenProjectScmInfo> mavenProjects = new ArrayList<MavenProjectScmInfo>();
        int i = 0;
        while (i < scms.length) {
            int n;
            String url = scms[i].getConnection();
            String revision = scms[i].getTag();
            if (url.endsWith("/")) {
                url = url.substring(0, url.length() - 1);
            }
            String label = String.valueOf((n = url.lastIndexOf("/")) == -1 ? url : url.substring(n)) + "/" + "pom.xml";
            MavenProjectScmInfo projectInfo = new MavenProjectScmInfo(label, null, null, revision, url, url);
            mavenProjects.add(projectInfo);
            ++i;
        }
        MavenProjectCheckoutJob job = new MavenProjectCheckoutJob(this.importConfiguration, checkoutAllProjects, this.workingSets){

            @Override
            protected Collection<MavenProjectScmInfo> getProjects(IProgressMonitor monitor) {
                return mavenProjects;
            }
        };
        if (!this.locationPage.isInWorkspace()) {
            job.setLocation(this.locationPage.getLocationPath().toFile());
        }
        job.schedule();
        return true;
    }
}

