/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers.rename;

import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jubula.client.core.businessprocess.IWritableComponentNameCache;
import org.eclipse.jubula.client.core.model.IComponentNamePO;
import org.eclipse.jubula.client.ui.handlers.AbstractSelectionBasedHandler;
import org.eclipse.jubula.client.ui.rcp.Plugin;
import org.eclipse.jubula.client.ui.rcp.dialogs.RenameLogicalCompNameDialog;
import org.eclipse.jubula.client.ui.utils.DialogUtils;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractRenameComponentNameHandler
extends AbstractSelectionBasedHandler {
    protected final IComponentNamePO getSelectedComponentName() {
        IStructuredSelection structuredSelection = this.getSelection();
        Object selectedObject = structuredSelection.getFirstElement();
        if (selectedObject instanceof IComponentNamePO) {
            return (IComponentNamePO)selectedObject;
        }
        return null;
    }

    protected final String getNewName(ExecutionEvent event, IComponentNamePO compName) {
        String originalName = compName.getName();
        RenameLogicalCompNameDialog dialog = new RenameLogicalCompNameDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), originalName);
        dialog.setHelpAvailable(true);
        dialog.create();
        DialogUtils.setWidgetNameForModalDialog((Dialog)dialog);
        Plugin.getHelpSystem().setHelp((Control)dialog.getShell(), "org.eclipse.jubula.client.ua.help.renameComponentNameContextId");
        int result = dialog.open();
        if (result != 0) {
            return null;
        }
        String newName = dialog.getName();
        return newName;
    }

    protected final void rename(IWritableComponentNameCache compNameCache, String guid, String newName) {
        compNameCache.renameComponentName(guid, newName);
    }
}

