/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.ui.rcp.handlers;

import java.util.ArrayList;
import java.util.Collection;
import javax.persistence.EntityManager;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jubula.client.core.events.DataEventDispatcher;
import org.eclipse.jubula.client.core.model.ICategoryPO;
import org.eclipse.jubula.client.core.model.IExecObjContPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecObjContPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.TransactionSupport;
import org.eclipse.jubula.client.core.utils.NativeSQLUtils;
import org.eclipse.jubula.client.ui.handlers.AbstractHandler;
import org.eclipse.jubula.client.ui.rcp.actions.TransactionWrapper;
import org.eclipse.jubula.client.ui.rcp.views.TestSuiteBrowser;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.handlers.HandlerUtil;

public abstract class AbstractNewHandler
extends AbstractHandler {
    protected INodePO getParentNode(ExecutionEvent event) {
        TreePath[] paths;
        ICategoryPO parentNode = null;
        ISelection selection = HandlerUtil.getCurrentSelection((ExecutionEvent)event);
        if (selection instanceof ITreeSelection && (paths = ((ITreeSelection)selection).getPaths()).length > 0) {
            int ind = paths[0].getSegmentCount();
            while (--ind > 0 && !(paths[0].getSegment(ind) instanceof ICategoryPO)) {
            }
            if (ind > 0) {
                parentNode = (INodePO)paths[0].getSegment(ind);
            }
        }
        if (parentNode == null) {
            IWorkbenchPart activePart = HandlerUtil.getActivePart((ExecutionEvent)event);
            parentNode = activePart instanceof TestSuiteBrowser ? IExecObjContPO.TSB_ROOT_NODE : ISpecObjContPO.TCB_ROOT_NODE;
        }
        return parentNode;
    }

    public void addCreatedNode(final INodePO created, ExecutionEvent ev) {
        INodePO parent = this.getParentNode(ev);
        final ArrayList<ISpecObjContPO> toLock = new ArrayList<ISpecObjContPO>();
        IProjectPO pr = GeneralStorage.getInstance().getProject();
        Object par = parent == ISpecObjContPO.TCB_ROOT_NODE ? pr.getSpecObjCont() : (parent == IExecObjContPO.TSB_ROOT_NODE ? pr.getExecObjCont() : parent);
        toLock.add((ISpecObjContPO)par);
        boolean succ = TransactionWrapper.executeOperation(new TransactionSupport.ITransaction((IPersistentObject)par){
            private final /* synthetic */ IPersistentObject val$par;
            {
                this.val$par = iPersistentObject;
            }

            public Collection<? extends IPersistentObject> getToLock() {
                return toLock;
            }

            public Collection<? extends IPersistentObject> getToRefresh() {
                return toLock;
            }

            public void run(EntityManager sess) {
                sess.persist((Object)created);
                NativeSQLUtils.addNodeAFFECTS((EntityManager)sess, (INodePO)created, (IPersistentObject)this.val$par);
            }

            public Collection<? extends IPersistentObject> getToMerge() {
                ArrayList<INodePO> toMerge = new ArrayList<INodePO>();
                toMerge.add(created);
                return toMerge;
            }
        });
        if (succ) {
            INodePO master = (INodePO)GeneralStorage.getInstance().getMasterSession().find(created.getClass(), (Object)created.getId());
            DataEventDispatcher.getInstance().fireDataChangedListener((IPersistentObject)master, DataEventDispatcher.DataState.Added, DataEventDispatcher.UpdateState.all);
        }
    }
}

