/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceException;
import javax.persistence.Query;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jubula.client.core.model.IExecObjContPO;
import org.eclipse.jubula.client.core.model.INodePO;
import org.eclipse.jubula.client.core.model.IPersistentObject;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.ISpecObjContPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.IExecPersistable;
import org.eclipse.jubula.client.core.persistence.ISpecPersistable;

public class NativeSQLUtils {
    private static final int MAXLGT = 990;
    private static final String FAIL = "Operation failed due to database error.";

    private NativeSQLUtils() {
    }

    public static String getIdList(Collection<? extends IPersistentObject> objects) {
        if (objects.isEmpty()) {
            throw new IllegalArgumentException("Collection should not be empty.");
        }
        StringBuilder str = new StringBuilder("(");
        for (IPersistentObject iPersistentObject : objects) {
            str.append(iPersistentObject.getId());
            str.append(",");
        }
        str.deleteCharAt(str.length() - 1);
        str.append(")");
        return str.toString();
    }

    public static List<String> getSlicedIdLists(Collection<? extends IPersistentObject> objects) {
        if (objects.isEmpty()) {
            throw new IllegalArgumentException("Collection should not be empty.");
        }
        StringBuilder str = null;
        int num = 0;
        ArrayList<String> result = new ArrayList<String>();
        for (IPersistentObject iPersistentObject : objects) {
            if (num == 0) {
                str = new StringBuilder("(");
            }
            str.append(iPersistentObject.getId());
            str.append(",");
            if (++num != 990) continue;
            str.deleteCharAt(str.length() - 1);
            str.append(")");
            result.add(str.toString());
            num = 0;
        }
        if (num != 0) {
            str.deleteCharAt(str.length() - 1);
            str.append(")");
            result.add(str.toString());
        }
        return result;
    }

    public static void deleteFromTCTSTreeAFFECTS(EntityManager sess, Collection<INodePO> nodes, IProgressMonitor monitor) {
        for (INodePO node : nodes) {
            node.goingToBeDeleted(sess);
            NativeSQLUtils.removeNodeAFFECTS(sess, node);
            if (monitor == null) continue;
            monitor.worked(1);
        }
        for (String smallList : NativeSQLUtils.getSlicedIdLists(nodes)) {
            Query q = sess.createNativeQuery("delete from NODE where ID in " + smallList);
            q.executeUpdate();
        }
    }

    public static void removeNodeAFFECTS(EntityManager sess, INodePO node) {
        Query q2;
        Query q1;
        IProjectPO proj = GeneralStorage.getInstance().getProject();
        int pos = -1;
        INodePO par = node.getParentNode();
        if (par == ISpecObjContPO.TCB_ROOT_NODE) {
            pos = proj.getSpecObjCont().getSpecObjList().indexOf(node);
            q1 = sess.createNativeQuery("delete from SPEC_CONT_NODE where SPECOBJCONTPO_ID = ?1 and HBMSPECOBJLIST_ID = ?2 and IDX = ?3");
            q1.setParameter(1, (Object)proj.getSpecObjCont().getId());
            q2 = sess.createNativeQuery("update SPEC_CONT_NODE set IDX = IDX - 1 where SPECOBJCONTPO_ID = ?1 and IDX > ?2");
            q2.setParameter(1, (Object)proj.getSpecObjCont().getId());
        } else if (par == IExecObjContPO.TSB_ROOT_NODE) {
            pos = proj.getExecObjCont().getExecObjList().indexOf(node);
            q1 = sess.createNativeQuery("delete from EXEC_CONT_NODE where EXECOBJCONTPO_ID = ?1 and HBMEXECOBJLIST_ID = ?2 and IDX = ?3");
            q1.setParameter(1, (Object)proj.getExecObjCont().getId());
            q2 = sess.createNativeQuery("update EXEC_CONT_NODE set IDX = IDX - 1 where EXECOBJCONTPO_ID = ?1 and IDX > ?2");
            q2.setParameter(1, (Object)proj.getExecObjCont().getId());
        } else {
            pos = par.indexOf(node);
            q1 = sess.createNativeQuery("update NODE set PARENT = null, IDX = null where ID = ?1");
            q1.setParameter(1, (Object)node.getId()).executeUpdate();
            q1 = null;
            q2 = sess.createNativeQuery("update NODE set IDX = IDX - 1 where PARENT = ?1 and IDX > ?2");
            q2.setParameter(1, (Object)par.getId());
        }
        if (q1 != null) {
            q1.setParameter(2, (Object)node.getId()).setParameter(3, (Object)pos);
            int res = q1.executeUpdate();
            if (res != 1) {
                throw new PersistenceException(FAIL);
            }
        }
        q2.setParameter(2, (Object)pos).executeUpdate();
        if (par == ISpecObjContPO.TCB_ROOT_NODE) {
            proj.getSpecObjCont().removeSpecObject((ISpecPersistable)node);
        } else if (par == IExecObjContPO.TSB_ROOT_NODE) {
            proj.getExecObjCont().removeExecObject((IExecPersistable)node);
        } else {
            node.getParentNode().removeNode(node);
        }
    }

    public static void addNodeAFFECTS(EntityManager sess, INodePO toAdd, IPersistentObject par) {
        Query q1;
        GeneralStorage.getInstance().getProject();
        int pos = -1;
        if (par instanceof ISpecObjContPO) {
            pos = ((ISpecObjContPO)par).getSpecObjList().size();
            q1 = sess.createNativeQuery("insert into SPEC_CONT_NODE (SPECOBJCONTPO_ID, HBMSPECOBJLIST_ID, IDX) values (?1, ?2, ?3)");
        } else if (par instanceof IExecObjContPO) {
            pos = ((IExecObjContPO)par).getExecObjList().size();
            q1 = sess.createNativeQuery("insert into EXEC_CONT_NODE (EXECOBJCONTPO_ID, HBMEXECOBJLIST_ID, IDX) values (?1, ?2, ?3)");
        } else {
            pos = ((INodePO)par).getNodeListSize();
            q1 = sess.createNativeQuery("update NODE set PARENT = ?1, IDX = ?3 where ID = ?2");
        }
        q1.setParameter(1, (Object)par.getId()).setParameter(2, (Object)toAdd.getId());
        int res = q1.setParameter(3, (Object)pos).executeUpdate();
        if (res != 1) {
            throw new PersistenceException(FAIL);
        }
        if (par instanceof ISpecObjContPO) {
            ((ISpecObjContPO)par).addSpecObject((ISpecPersistable)toAdd);
        } else if (par instanceof IExecObjContPO) {
            ((IExecObjContPO)par).addExecObject((IExecPersistable)toAdd);
        } else {
            ((INodePO)par).addNode(toAdd);
        }
    }

    public static void moveNode(EntityManager sess, INodePO toMove, IPersistentObject target) {
        NativeSQLUtils.removeNodeAFFECTS(sess, toMove);
        NativeSQLUtils.addNodeAFFECTS(sess, toMove, target);
    }
}

