/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jubula.client.core.businessprocess;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jubula.client.core.businessprocess.AbstractNameBP;
import org.eclipse.jubula.client.core.businessprocess.IParamNameMapper;
import org.eclipse.jubula.client.core.i18n.Messages;
import org.eclipse.jubula.client.core.model.ICapPO;
import org.eclipse.jubula.client.core.model.IParamDescriptionPO;
import org.eclipse.jubula.client.core.model.IParamNamePO;
import org.eclipse.jubula.client.core.model.IProjectPO;
import org.eclipse.jubula.client.core.model.IReusedProjectPO;
import org.eclipse.jubula.client.core.persistence.GeneralStorage;
import org.eclipse.jubula.client.core.persistence.PMException;
import org.eclipse.jubula.client.core.persistence.ParamNamePM;
import org.eclipse.jubula.tools.internal.exception.JBFatalException;
import org.eclipse.jubula.tools.internal.messagehandling.MessageIDs;
import org.eclipse.jubula.tools.internal.xml.businessmodell.Param;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParamNameBP
extends AbstractNameBP<IParamNamePO>
implements IParamNameMapper {
    private static Logger log = LoggerFactory.getLogger(ParamNameBP.class);
    private static ParamNameBP instance = null;
    private Set<IParamDescriptionPO> m_paramDescriptions = new HashSet<IParamDescriptionPO>();

    private ParamNameBP() {
    }

    public void initMap() throws PMException {
        this.clearAllNamePOs();
        IProjectPO project = GeneralStorage.getInstance().getProject();
        if (project != null) {
            List<IParamNamePO> names = ParamNamePM.readAllParamNames(project.getId());
            for (IParamNamePO paramNamePO : names) {
                this.addNamePO(paramNamePO);
            }
        }
    }

    public void initParamNamesOfReusedProject(IReusedProjectPO reusedProject) throws PMException {
        if (reusedProject.getId() != null) {
            List<IParamNamePO> names = ParamNamePM.readAllParamNames(reusedProject.getId());
            for (IParamNamePO paramNamePO : names) {
                this.addNamePO(paramNamePO);
            }
        }
    }

    public static ParamNameBP getInstance() {
        if (instance == null) {
            instance = new ParamNameBP();
        }
        return instance;
    }

    @Override
    public void addParamNamePO(IParamNamePO namePO) {
        this.addNamePO(namePO);
    }

    @Override
    public void removeParamNamePO(String guid) {
        this.removeNamePO(guid);
    }

    @Override
    public String getName(String uniqueId, Long rootProjId) {
        String name = uniqueId;
        IParamNamePO namePO = (IParamNamePO)this.getNamePO(uniqueId);
        if (namePO == null) {
            try {
                namePO = ParamNamePM.readParamNamePO(uniqueId, rootProjId);
            }
            catch (PMException e) {
                throw new JBFatalException((Throwable)((Object)e), MessageIDs.E_DATABASE_GENERAL);
            }
        }
        if (namePO != null) {
            name = namePO.getName();
            this.addNamePO(namePO);
        } else if (log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append(Messages.EmptyParameterName);
            msg.append(".");
            msg.append(" ");
            msg.append(Messages.ParentProjectId);
            msg.append(" ");
            msg.append("=");
            msg.append(" ");
            msg.append(rootProjId);
            msg.append(" ");
            msg.append(Messages.uniqueId);
            msg.append(" ");
            msg.append("=");
            msg.append(" ");
            msg.append(uniqueId);
            log.debug(msg.toString());
        }
        return name;
    }

    public void clearParamNames() {
        this.clearAllNamePOs();
    }

    public void registerParamDescriptionr(IParamDescriptionPO desc) {
        this.m_paramDescriptions.add(desc);
    }

    public void deregisterAllParamDescriptions() {
        this.m_paramDescriptions.clear();
    }

    public IParamNamePO getParamNamePO(String uniqueId) {
        return (IParamNamePO)this.getNamePO(uniqueId);
    }

    public static boolean isOptionalParameter(@NonNull ICapPO cap, @NonNull String uniqueId) {
        for (Param p : cap.getMetaAction().getParams()) {
            if (!p.getName().equals(uniqueId)) continue;
            return p.isOptional();
        }
        return false;
    }
}

