/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jst.jsf.common.internal.policy;

import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OrderedListProvider {
    private List<OrderableObject> _orderableObjects;

    public final List<OrderableObject> getOrderedObjects() {
        if (this._orderableObjects == null) {
            this._orderableObjects = this.createAndPopulateOrderedObjects();
        }
        return this._orderableObjects;
    }

    public final void resetOrderedObjects() {
        this._orderableObjects = null;
    }

    public final void moveUp(OrderableObject object) {
        List<OrderableObject> list = this.getOrderedObjects();
        int index = list.indexOf(object);
        if (index > 0) {
            OrderableObject item = list.remove(index);
            list.add(index - 1, item);
        }
    }

    public final void moveDown(OrderableObject object) {
        List<OrderableObject> list = this.getOrderedObjects();
        int index = list.indexOf(object);
        if (index < list.size() - 1) {
            OrderableObject item = list.remove(index);
            list.add(index + 1, item);
        }
    }

    protected abstract List<OrderableObject> createAndPopulateOrderedObjects();

    public static class OrderableObject
    implements Cloneable {
        private boolean _enabled;
        private Object _object;

        public OrderableObject(Object object, boolean enabled) {
            this._object = object;
            this._enabled = enabled;
        }

        private OrderableObject(OrderableObject copyMe) {
            this._object = copyMe._object;
            this._enabled = copyMe._enabled;
        }

        public boolean isEnabled() {
            return this._enabled;
        }

        public void setEnabled(boolean enabled) {
            this._enabled = enabled;
        }

        public Object getObject() {
            return this._object;
        }

        public void setObject(Object object) {
            this._object = object;
        }

        public OrderableObject clone() {
            return new OrderableObject(this);
        }

        public boolean equals(Object obj) {
            if (obj instanceof OrderableObject && this._enabled == ((OrderableObject)obj)._enabled) {
                Object other = ((OrderableObject)obj)._object;
                if (other != null) {
                    return other.equals(this._object);
                }
                return this._object == null;
            }
            return false;
        }

        public int hashCode() {
            int enabledCode;
            int n = enabledCode = this._enabled ? -858993460 : 0x33333333;
            if (this._object == null) {
                return enabledCode;
            }
            return this._object.hashCode() ^ enabledCode;
        }
    }
}

