/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.utility.internal.transformer;

import org.eclipse.jpt.common.utility.Association;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.jpt.common.utility.internal.iterable.IterableTools;
import org.eclipse.jpt.common.utility.predicate.Predicate;
import org.eclipse.jpt.common.utility.transformer.InterruptibleTransformer;

public class SwitchInterruptibleTransformer<I, O>
implements InterruptibleTransformer<I, O> {
    private final Iterable<Association<Predicate<? super I>, InterruptibleTransformer<? super I, ? extends O>>> transformers;
    private final InterruptibleTransformer<? super I, ? extends O> defaultInterruptibleTransformer;

    public SwitchInterruptibleTransformer(Iterable<Association<Predicate<? super I>, InterruptibleTransformer<? super I, ? extends O>>> transformers, InterruptibleTransformer<? super I, ? extends O> defaultInterruptibleTransformer) {
        if (IterableTools.isOrContainsNull(transformers) || defaultInterruptibleTransformer == null) {
            throw new NullPointerException();
        }
        this.transformers = transformers;
        this.defaultInterruptibleTransformer = defaultInterruptibleTransformer;
    }

    @Override
    public O transform(I input) throws InterruptedException {
        for (Association<Predicate<I>, InterruptibleTransformer<I, O>> association : this.transformers) {
            if (!association.getKey().evaluate(input)) continue;
            return association.getValue().transform(input);
        }
        return this.defaultInterruptibleTransformer.transform(input);
    }

    public String toString() {
        return ObjectTools.toString((Object)this, this.transformers);
    }
}

