/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jpt.common.ui.internal.jface;

import java.io.Serializable;
import org.eclipse.jpt.common.ui.internal.jface.PluggableTextTableLabelProvider;
import org.eclipse.jpt.common.utility.internal.ObjectTools;
import org.eclipse.swt.graphics.Image;

public class PluggableTableLabelProvider<E>
extends PluggableTextTableLabelProvider<E> {
    private volatile PluggableTextTableLabelProvider.Transformer<E, Image> imageTransformer;

    public PluggableTableLabelProvider() {
        this(DefaultImageTransformer.instance(), PluggableTextTableLabelProvider.DefaultTextTransformer.instance());
    }

    public PluggableTableLabelProvider(PluggableTextTableLabelProvider.TextTransformer<E> textTransformer) {
        this(DefaultImageTransformer.instance(), textTransformer);
    }

    public PluggableTableLabelProvider(ImageTransformer<E> imageTransformer, PluggableTextTableLabelProvider.TextTransformer<E> textTransformer) {
        super(textTransformer);
        if (imageTransformer == null) {
            throw new NullPointerException();
        }
        this.imageTransformer = imageTransformer;
    }

    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        return this.imageTransformer.transform(element, columnIndex);
    }

    public void setImageTransformer(ImageTransformer<E> imageTransformer) {
        if (imageTransformer == null) {
            throw new NullPointerException();
        }
        this.imageTransformer = imageTransformer;
    }

    public static class DefaultImageTransformer<E>
    implements ImageTransformer<E>,
    Serializable {
        public static final ImageTransformer<?> INSTANCE = new DefaultImageTransformer();
        private static final long serialVersionUID = 1L;

        public static <R> ImageTransformer<R> instance() {
            return INSTANCE;
        }

        private DefaultImageTransformer() {
        }

        @Override
        public Image transform(E element, int columnIndex) {
            return null;
        }

        public String toString() {
            return ObjectTools.toString((Object)this);
        }

        private Object readResolve() {
            return INSTANCE;
        }
    }

    public static interface ImageTransformer<E>
    extends PluggableTextTableLabelProvider.Transformer<E, Image> {
        @Override
        public Image transform(E var1, int var2);
    }
}

