/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;

public class RootCPListElement
extends CPListElement {
    private String fPathRootNodeName = null;
    private boolean fIsModuleRootNode;

    public RootCPListElement(IJavaProject project, int entryKind) {
        super(project, entryKind);
    }

    public RootCPListElement(IJavaProject project, String name, boolean isModuleRoot) {
        this(project, -1);
        this.fPathRootNodeName = name;
        this.fIsModuleRootNode = isModuleRoot;
    }

    @Override
    public boolean equals(Object other) {
        if (other != null && other.getClass().equals(this.getClass())) {
            return this == other;
        }
        return false;
    }

    void addCPListElement(CPListElement cpe) {
        this.fChildren.add(cpe);
    }

    void addCPListElement(List<CPListElement> elementsToAdd) {
        this.fChildren.addAll(elementsToAdd);
    }

    ArrayList<Object> getChildren() {
        return this.fChildren;
    }

    String getPathRootNodeName() {
        return this.fPathRootNodeName;
    }

    @Override
    boolean isRootNodeForPath() {
        return true;
    }

    @Override
    boolean isModulePathRootNode() {
        return this.fIsModuleRootNode;
    }

    @Override
    boolean isClassPathRootNode() {
        return !this.fIsModuleRootNode;
    }

    public boolean isSourceRootNode(RootNodeChange changeNodeDirection) {
        return RootNodeChange.fromOldAndNew(this.fIsModuleRootNode, !this.fIsModuleRootNode) == changeNodeDirection;
    }

    public boolean isTargetRootNode(RootNodeChange changeNodeDirection) {
        return RootNodeChange.fromOldAndNew(!this.fIsModuleRootNode, this.fIsModuleRootNode) == changeNodeDirection;
    }

    void removeCPListElement(CPListElement element) {
        this.fChildren.remove(element);
    }

    static enum RootNodeChange {
        ToModulepath,
        ToClasspath,
        NoChange;


        static RootNodeChange fromOldAndNew(boolean wasModular, boolean isModular) {
            if (wasModular == isModular) {
                return NoChange;
            }
            if (isModular) {
                return ToModulepath;
            }
            return ToClasspath;
        }
    }
}

