/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.fix;

import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.internal.corext.fix.TypeParametersFix;
import org.eclipse.jdt.internal.ui.fix.AbstractMultiFix;
import org.eclipse.jdt.internal.ui.fix.MultiFixMessages;
import org.eclipse.jdt.ui.cleanup.CleanUpRequirements;
import org.eclipse.jdt.ui.cleanup.ICleanUpFix;
import org.eclipse.jdt.ui.text.java.IProblemLocation;

public class TypeParametersCleanUp
extends AbstractMultiFix {
    private Map<String, String> fOptions;

    public TypeParametersCleanUp(Map<String, String> options) {
        super(options);
        this.fOptions = options;
    }

    public TypeParametersCleanUp() {
    }

    @Override
    public CleanUpRequirements getRequirements() {
        boolean requireAST = this.isEnabled("cleanup.insert_inferred_type_arguments") || this.isEnabled("cleanup.remove_redundant_type_arguments");
        Map<String, String> requiredOptions = requireAST ? this.getRequiredOptions() : null;
        return new CleanUpRequirements(requireAST, false, false, requiredOptions);
    }

    private Map<String, String> getRequiredOptions() {
        Hashtable<String, String> result = new Hashtable<String, String>();
        if (this.isEnabled("cleanup.remove_redundant_type_arguments")) {
            result.put("org.eclipse.jdt.core.compiler.problem.redundantSpecificationOfTypeArguments", "warning");
        }
        return result;
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit compilationUnit) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return TypeParametersFix.createCleanUp(compilationUnit, this.isEnabled("cleanup.insert_inferred_type_arguments"), this.isEnabled("cleanup.remove_redundant_type_arguments"));
    }

    @Override
    protected ICleanUpFix createFix(CompilationUnit compilationUnit, IProblemLocation[] problems) throws CoreException {
        if (compilationUnit == null) {
            return null;
        }
        return TypeParametersFix.createCleanUp(compilationUnit, problems, this.isEnabled("cleanup.insert_inferred_type_arguments"), this.isEnabled("cleanup.remove_redundant_type_arguments"));
    }

    @Override
    public String[] getStepDescriptions() {
        ArrayList<String> result = new ArrayList<String>();
        if (this.isEnabled("cleanup.insert_inferred_type_arguments")) {
            result.add(MultiFixMessages.TypeParametersCleanUp_InsertInferredTypeArguments_description);
        } else if (this.isEnabled("cleanup.remove_redundant_type_arguments")) {
            result.add(MultiFixMessages.TypeParametersCleanUp_RemoveUnnecessaryTypeArguments_description);
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public boolean canFix(ICompilationUnit compilationUnit, IProblemLocation problem) {
        int problemId = problem.getProblemId();
        if (problemId == 16778100) {
            return this.isEnabled("cleanup.remove_redundant_type_arguments");
        }
        if (problemId == 16778099) {
            return this.isEnabled("cleanup.insert_inferred_type_arguments");
        }
        return false;
    }

    @Override
    public int computeNumberOfFixes(CompilationUnit compilationUnit) {
        if (this.fOptions == null) {
            return 0;
        }
        int result = 0;
        IProblem[] problems = compilationUnit.getProblems();
        if (this.isEnabled("cleanup.remove_redundant_type_arguments")) {
            result = TypeParametersCleanUp.getNumberOfProblems(problems, 16778100);
        } else if (this.isEnabled("cleanup.insert_inferred_type_arguments")) {
            result = TypeParametersCleanUp.getNumberOfProblems(problems, 16778099);
        }
        return result;
    }

    @Override
    public String getPreview() {
        StringBuffer buf = new StringBuffer();
        if (this.isEnabled("cleanup.remove_redundant_type_arguments")) {
            buf.append("\nMap<Integer, String> map= new HashMap<>();");
        } else {
            buf.append("\nMap<Integer, String> map= new HashMap<Integer, String>();");
        }
        return buf.toString();
    }
}

